/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc.admin;

import java.io.File;
import java.util.Iterator;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaInfo;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.io.ISVNReporter;
import org.tmatesoft.svn.core.io.ISVNReporterBaton;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.util.ISVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNReporter
implements ISVNReporterBaton {
    private SVNAdminAreaInfo myInfo;
    private SVNDepth myDepth;
    private boolean myIsRestore;
    private boolean myUseDepthCompatibilityTrick;
    private boolean myIsStatus;
    private boolean myIsHonorDepthExclude;
    private File myTarget;
    private ISVNDebugLog myLog;
    private boolean myIsLockOnDemand;
    private long myTotalFilesCount;
    private long myReportedFilesCount;

    public SVNReporter(SVNAdminAreaInfo info, File file, boolean restoreFiles, boolean useDepthCompatibilityTrick, SVNDepth depth, boolean lockOnDemand, boolean isStatus, boolean isHonorDepthExclude, ISVNDebugLog log) {
        this.myInfo = info;
        this.myDepth = depth;
        this.myIsRestore = restoreFiles;
        this.myIsStatus = isStatus;
        this.myUseDepthCompatibilityTrick = useDepthCompatibilityTrick;
        this.myLog = log;
        this.myTarget = file;
        this.myIsLockOnDemand = lockOnDemand;
        this.myIsHonorDepthExclude = isHonorDepthExclude;
        this.myTotalFilesCount = 0L;
        this.myReportedFilesCount = 0L;
    }

    public void report(ISVNReporter reporter) throws SVNException {
        try {
            long revision;
            SVNAdminArea targetArea = this.myInfo.getTarget();
            SVNWCAccess wcAccess = this.myInfo.getWCAccess();
            SVNEntry targetEntry = wcAccess.getEntry(this.myTarget, false);
            if (targetEntry == null || targetEntry.isDirectory() && targetEntry.isScheduledForAddition()) {
                SVNEntry parentEntry = wcAccess.getVersionedEntry(this.myTarget.getParentFile(), false);
                long revision2 = parentEntry.getRevision();
                if (this.myDepth == SVNDepth.UNKNOWN) {
                    this.myDepth = SVNDepth.INFINITY;
                }
                reporter.setPath("", null, revision2, this.myDepth, targetEntry == null || targetEntry.isIncomplete());
                if (targetEntry == null || targetEntry.isIncomplete()) {
                    this.myInfo.addIncompleteEntry("");
                }
                reporter.deletePath("");
                reporter.finishReport();
                ++this.myReportedFilesCount;
                ++this.myTotalFilesCount;
                return;
            }
            SVNEntry parentEntry = null;
            boolean startEmpty = targetEntry.isIncomplete();
            if (this.myUseDepthCompatibilityTrick && targetEntry.getDepth().compareTo(SVNDepth.IMMEDIATES) <= 0 && this.myDepth.compareTo(targetEntry.getDepth()) > 0) {
                startEmpty = true;
            }
            if (!SVNRevision.isValidRevisionNumber(revision = targetEntry.getRevision())) {
                parentEntry = wcAccess.getVersionedEntry(this.myTarget.getParentFile(), false);
                revision = parentEntry.getRevision();
            }
            reporter.setPath("", null, revision, targetEntry.getDepth(), startEmpty);
            if (startEmpty) {
                this.myInfo.addIncompleteEntry("");
            }
            boolean missing = false;
            if (!targetEntry.isScheduledForDeletion()) {
                SVNFileType fileType = SVNFileType.getType(this.myTarget);
                missing = fileType == SVNFileType.NONE;
            }
            this.myTotalFilesCount = 1L;
            this.myReportedFilesCount = 1L;
            if (targetEntry.isDirectory()) {
                if (!(this.myIsStatus || missing || targetEntry.isThisDir())) {
                    missing = true;
                }
                if (missing) {
                    reporter.deletePath("");
                } else if (this.myDepth != SVNDepth.EMPTY) {
                    this.reportEntries(reporter, targetArea, "", revision, startEmpty, this.myDepth);
                }
            } else if (targetEntry.isFile()) {
                if (missing) {
                    this.restoreFile(targetArea, targetEntry.getName());
                }
                parentEntry = parentEntry == null ? wcAccess.getEntry(this.myTarget.getParentFile(), false) : parentEntry;
                String url = targetEntry.getURL();
                String parentURL = parentEntry.getURL();
                String expectedURL = SVNPathUtil.append(parentURL, SVNEncodingUtil.uriEncode(targetEntry.getName()));
                if (parentEntry != null && !expectedURL.equals(url)) {
                    SVNURL svnURL = SVNURL.parseURIEncoded(url);
                    reporter.linkPath(svnURL, "", targetEntry.getLockToken(), targetEntry.getRevision(), targetEntry.getDepth(), false);
                } else if (targetEntry.getRevision() != revision || targetEntry.getLockToken() != null) {
                    reporter.setPath("", targetEntry.getLockToken(), targetEntry.getRevision(), targetEntry.getDepth(), false);
                }
            }
            reporter.finishReport();
        }
        catch (SVNException e) {
            try {
                reporter.abortReport();
            }
            catch (SVNException inner) {
                this.myLog.logFine(SVNLogType.WC, inner);
            }
            throw e;
        }
        catch (Throwable th) {
            this.myLog.logFine(SVNLogType.WC, th);
            try {
                reporter.abortReport();
            }
            catch (SVNException e) {
                this.myLog.logFine(SVNLogType.WC, e);
            }
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "WC report failed: {0}", (Object)th.getMessage());
            SVNErrorManager.error(err, th, SVNLogType.WC);
        }
    }

    private void reportEntries(ISVNReporter reporter, SVNAdminArea adminArea, String dirPath, long dirRevision, boolean reportAll, SVNDepth depth) throws SVNException {
        SVNWCAccess wcAccess = this.myInfo.getWCAccess();
        String externalsProperty = adminArea.getProperties(adminArea.getThisDirName()).getStringPropertyValue("svn:externals");
        SVNEntry thisEntry = adminArea.getEntry(adminArea.getThisDirName(), true);
        if (externalsProperty != null) {
            String areaPath = adminArea.getRelativePath(this.myInfo.getAnchor());
            this.myInfo.addExternal(areaPath, externalsProperty, externalsProperty);
            this.myInfo.addDepth(areaPath, thisEntry.getDepth());
        }
        String parentURL = thisEntry.getURL();
        Iterator e = adminArea.entries(true);
        while (e.hasNext()) {
            SVNURL svnURL;
            String path;
            SVNEntry entry = (SVNEntry)e.next();
            if (adminArea.getThisDirName().equals(entry.getName())) continue;
            ++this.myTotalFilesCount;
            String string = path = "".equals(dirPath) ? entry.getName() : SVNPathUtil.append(dirPath, entry.getName());
            if (entry.isDeleted() || entry.isAbsent()) {
                if (reportAll) continue;
                reporter.deletePath(path);
                ++this.myReportedFilesCount;
                continue;
            }
            if (entry.getDepth() == SVNDepth.EXCLUDE) {
                if (this.myIsHonorDepthExclude) {
                    reporter.setPath(path, null, dirRevision, SVNDepth.EXCLUDE, false);
                    continue;
                }
                if (reportAll) continue;
                reporter.deletePath(path);
                continue;
            }
            if (entry.isScheduledForAddition()) continue;
            File file = adminArea.getFile(entry.getName());
            SVNFileType fileType = SVNFileType.getType(file);
            boolean missing = fileType == SVNFileType.NONE;
            String expectedURL = SVNPathUtil.append(parentURL, SVNEncodingUtil.uriEncode(entry.getName()));
            if (entry.isFile()) {
                SVNURL svnURL2;
                if (missing && !entry.isScheduledForDeletion() && !entry.isScheduledForReplacement()) {
                    adminArea = this.restoreFile(adminArea, entry.getName());
                }
                String url = entry.getURL();
                if (reportAll) {
                    if (!url.equals(expectedURL)) {
                        svnURL2 = SVNURL.parseURIEncoded(url);
                        reporter.linkPath(svnURL2, path, entry.getLockToken(), entry.getRevision(), entry.getDepth(), false);
                        continue;
                    }
                    reporter.setPath(path, entry.getLockToken(), entry.getRevision(), entry.getDepth(), false);
                    ++this.myReportedFilesCount;
                    continue;
                }
                if (!(entry.isScheduledForAddition() || entry.isScheduledForReplacement() || url.equals(expectedURL))) {
                    svnURL2 = SVNURL.parseURIEncoded(url);
                    reporter.linkPath(svnURL2, path, entry.getLockToken(), entry.getRevision(), entry.getDepth(), false);
                    continue;
                }
                if (entry.getRevision() == dirRevision && entry.getLockToken() == null && thisEntry.getDepth() != SVNDepth.EMPTY) continue;
                reporter.setPath(path, entry.getLockToken(), entry.getRevision(), entry.getDepth(), false);
                ++this.myReportedFilesCount;
                continue;
            }
            if (!entry.isDirectory() || depth.compareTo(SVNDepth.FILES) <= 0 && depth != SVNDepth.UNKNOWN) continue;
            if (missing) {
                if (this.myIsRestore) {
                    boolean dropDeletedSchedule;
                    boolean bl = dropDeletedSchedule = this.myInfo.getAnchor().getWCAccess().getMaxFormatVersion() < 10;
                    if (entry.isScheduledForReplacement() || dropDeletedSchedule && entry.isScheduledForDeletion()) {
                        entry.setSchedule(null);
                        adminArea.saveEntries(false);
                    }
                }
                if (reportAll) continue;
                reporter.deletePath(path);
                ++this.myReportedFilesCount;
                continue;
            }
            if (wcAccess.isMissing(adminArea.getFile(entry.getName()))) {
                if (this.myIsStatus) continue;
                reporter.deletePath(path);
                ++this.myReportedFilesCount;
                continue;
            }
            SVNAdminArea childArea = wcAccess.retrieve(adminArea.getFile(entry.getName()));
            SVNEntry childEntry = childArea.getEntry(childArea.getThisDirName(), true);
            String url = childEntry.getURL();
            boolean startEmpty = childEntry.isIncomplete();
            if (this.myUseDepthCompatibilityTrick && childEntry.getDepth().compareTo(SVNDepth.FILES) <= 0 && depth.compareTo(childEntry.getDepth()) > 0) {
                startEmpty = true;
                this.myInfo.addIncompleteEntry(path);
            }
            if (reportAll) {
                if (!url.equals(expectedURL)) {
                    svnURL = SVNURL.parseURIEncoded(url);
                    reporter.linkPath(svnURL, path, childEntry.getLockToken(), childEntry.getRevision(), childEntry.getDepth(), startEmpty);
                } else {
                    reporter.setPath(path, childEntry.getLockToken(), childEntry.getRevision(), childEntry.getDepth(), startEmpty);
                    ++this.myReportedFilesCount;
                }
            } else if (!url.equals(expectedURL)) {
                svnURL = SVNURL.parseURIEncoded(url);
                reporter.linkPath(svnURL, path, childEntry.getLockToken(), childEntry.getRevision(), childEntry.getDepth(), startEmpty);
            } else if (childEntry.getLockToken() != null || childEntry.getRevision() != dirRevision || childEntry.isIncomplete() || thisEntry.getDepth() == SVNDepth.EMPTY || thisEntry.getDepth() == SVNDepth.FILES || thisEntry.getDepth() == SVNDepth.IMMEDIATES && childEntry.getDepth() != SVNDepth.EMPTY || SVNDepth.INFINITY.compareTo(childEntry.getDepth()) > 0 && depth == SVNDepth.INFINITY) {
                reporter.setPath(path, childEntry.getLockToken(), childEntry.getRevision(), childEntry.getDepth(), startEmpty);
                ++this.myReportedFilesCount;
            }
            if (depth != SVNDepth.INFINITY && depth != SVNDepth.UNKNOWN) continue;
            this.reportEntries(reporter, childArea, path, childEntry.getRevision(), startEmpty, depth);
        }
    }

    private SVNAdminArea restoreFile(SVNAdminArea adminArea, String name) throws SVNException {
        if (!this.myIsRestore) {
            return adminArea;
        }
        if (this.myIsLockOnDemand && !adminArea.isLocked()) {
            adminArea.lock(false);
            adminArea = this.myInfo.getWCAccess().upgrade(adminArea.getRoot());
        }
        adminArea.restoreFile(name);
        SVNEntry entry = adminArea.getEntry(name, true);
        this.myInfo.getWCAccess().handleEvent(SVNEventFactory.createSVNEvent(adminArea.getFile(entry.getName()), entry.getKind(), null, entry.getRevision(), SVNEventAction.RESTORE, null, null, null));
        return adminArea;
    }

    public long getReportedFilesCount() {
        return this.myReportedFilesCount;
    }

    public long getTotalFilesCount() {
        return this.myTotalFilesCount;
    }
}

