/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.harmony.analysis.ownership;

import fr.labri.harmony.analysis.ownership.contributions.Contribution;
import fr.labri.harmony.analysis.ownership.contributions.ModuleContributions;
import fr.labri.harmony.analysis.ownership.metric.Metric;
import fr.labri.harmony.analysis.ownership.metric.MetricSet;
import fr.labri.harmony.analysis.ownership.metric.OwnershipMetrics;
import fr.labri.harmony.core.analysis.AbstractAnalysis;
import fr.labri.harmony.core.config.model.AnalysisConfiguration;
import fr.labri.harmony.core.dao.Dao;
import fr.labri.harmony.core.log.HarmonyLogger;
import fr.labri.harmony.core.model.Action;
import fr.labri.harmony.core.model.Author;
import fr.labri.harmony.core.model.Event;
import fr.labri.harmony.core.model.HarmonyModelElement;
import fr.labri.harmony.core.model.Item;
import fr.labri.harmony.core.model.Source;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Properties;

public class ItemOwnershipAnalysis
extends AbstractAnalysis {
    protected static final String OPT_SNAPSHOTS_COMMITS = "snapshots-commits";

    public ItemOwnershipAnalysis() {
    }

    public ItemOwnershipAnalysis(AnalysisConfiguration config, Dao dao, Properties properties) {
        super(config, dao, properties);
    }

    public void runOn(Source src) throws IOException {
        Date fromDate = null;
        Date toDate = null;
        ArrayList snapshotsNativeIds = (ArrayList)src.getConfig().getOptions().get(OPT_SNAPSHOTS_COMMITS);
        if (snapshotsNativeIds != null && !snapshotsNativeIds.isEmpty()) {
            String currentVersion = (String)snapshotsNativeIds.get(0);
            Event currentVersionEvent = this.dao.getEvent(src, currentVersion);
            if (currentVersionEvent == null) {
                HarmonyLogger.error((String)("Could not find snapshot " + currentVersion + " in source " + src.getUrl()));
                return;
            }
            toDate = new Date(currentVersionEvent.getTimestamp());
            if (snapshotsNativeIds.size() > 1) {
                String previousVersion = (String)snapshotsNativeIds.get(1);
                Event previousVersionEvent = this.dao.getEvent(src, previousVersion);
                if (previousVersionEvent == null) {
                    HarmonyLogger.error((String)("Could not find snapshot " + previousVersion + " in source " + src.getUrl()));
                    return;
                }
                fromDate = new Date(previousVersionEvent.getTimestamp());
            }
        }
        this.extractContributions(src, fromDate, toDate);
        this.computeMetrics(src, fromDate, toDate);
    }

    protected void computeMetrics(Source src, Date fromDate, Date toDate) {
        List allContributions = this.dao.getData(this.getPersitenceUnitName(), ModuleContributions.class, (HarmonyModelElement)src);
        for (ModuleContributions contributions : allContributions) {
            OwnershipMetrics ownershipMetrics = new OwnershipMetrics(contributions.getContributions());
            List<Metric> metrics = ownershipMetrics.getMetrics();
            MetricSet metricSet = new MetricSet(contributions.getModuleName(), toDate, fromDate, metrics);
            this.dao.saveData(this.getPersitenceUnitName(), (Object)metricSet, (HarmonyModelElement)src);
        }
    }

    protected void extractContributions(Source src, Date fromDate, Date toDate) {
        List items = null;
        items = fromDate == null ? this.dao.getItems(src, Calendar.getInstance().getTime()) : this.dao.getItems(src, fromDate);
        for (Item item : items) {
            ModuleContributions contributions = this.getItemContributions(fromDate, toDate, item);
            if (contributions == null) continue;
            this.dao.saveData(this.getPersitenceUnitName(), (Object)contributions, (HarmonyModelElement)src);
        }
    }

    protected ModuleContributions getItemContributions(Date fromDate, Date toDate, Item i) {
        ModuleContributions itemContributions = new ModuleContributions(i.getNativeId(), fromDate, toDate);
        List actions = this.dao.getActions(i, fromDate, toDate);
        if (actions.isEmpty()) {
            return new ModuleContributions(i.getNativeId(), fromDate, toDate);
        }
        for (Action action : actions) {
            String author = ((Author)action.getEvent().getAuthors().get(0)).getNativeId();
            Contribution contrib = itemContributions.getContribution(author);
            if (contrib == null) {
                contrib = new Contribution(author, 0, 0);
            }
            contrib.setTouches(contrib.getTouches() + 1);
            String churnString = (String)action.getMetadata().get("churn");
            if (churnString != null) {
                contrib.setChurn(contrib.getChurn() + Integer.parseInt(churnString));
            }
            itemContributions.put(author, contrib);
        }
        return itemContributions;
    }
}

