/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.harmony.analysis.ownership;

import fr.labri.harmony.analysis.ownership.contributions.Contribution;
import fr.labri.harmony.analysis.ownership.contributions.ModuleContributions;
import fr.labri.harmony.analysis.ownership.metric.Metric;
import fr.labri.harmony.analysis.ownership.metric.MetricSet;
import fr.labri.harmony.analysis.ownership.metric.OwnershipMetrics;
import fr.labri.harmony.core.analysis.AbstractAnalysis;
import fr.labri.harmony.core.config.model.AnalysisConfiguration;
import fr.labri.harmony.core.dao.Dao;
import fr.labri.harmony.core.log.HarmonyLogger;
import fr.labri.harmony.core.model.Action;
import fr.labri.harmony.core.model.Author;
import fr.labri.harmony.core.model.Event;
import fr.labri.harmony.core.model.HarmonyModelElement;
import fr.labri.harmony.core.model.Item;
import fr.labri.harmony.core.model.Source;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Properties;

public class ProjectOwnershipAnalysis
extends AbstractAnalysis {
    protected static final String OPT_SNAPSHOTS_COMMITS = "snapshots-commits";

    public ProjectOwnershipAnalysis() {
    }

    public ProjectOwnershipAnalysis(AnalysisConfiguration config, Dao dao, Properties properties) {
        super(config, dao, properties);
    }

    public void runOn(Source src) throws Exception {
        Date fromDate = null;
        Date toDate = null;
        ArrayList snapshotsNativeIds = (ArrayList)src.getConfig().getOptions().get(OPT_SNAPSHOTS_COMMITS);
        if (snapshotsNativeIds != null && !snapshotsNativeIds.isEmpty()) {
            String currentVersion = (String)snapshotsNativeIds.get(0);
            Event currentVersionEvent = this.dao.getEvent(src, currentVersion);
            if (currentVersionEvent == null) {
                HarmonyLogger.error((String)("Could not find snapshot " + currentVersion + " in source " + src.getUrl()));
                return;
            }
            toDate = new Date(currentVersionEvent.getTimestamp());
            if (snapshotsNativeIds.size() > 1) {
                String previousVersion = (String)snapshotsNativeIds.get(1);
                Event previousVersionEvent = this.dao.getEvent(src, previousVersion);
                if (previousVersionEvent == null) {
                    HarmonyLogger.error((String)("Could not find snapshot " + previousVersion + " in source " + src.getUrl()));
                    return;
                }
                fromDate = new Date(previousVersionEvent.getTimestamp());
            }
        }
        ModuleContributions contributions = this.extractContributions(src, fromDate, toDate);
        this.computeMetrics(src, contributions);
    }

    protected ModuleContributions extractContributions(Source src, Date fromDate, Date toDate) {
        List items = null;
        items = fromDate == null ? this.dao.getItems(src, Calendar.getInstance().getTime()) : this.dao.getItems(src, fromDate);
        ModuleContributions contributions = this.getModuleContributions(src.getUrl(), fromDate, toDate, items);
        if (contributions != null) {
            this.dao.saveData(this.getPersitenceUnitName(), (Object)contributions, (HarmonyModelElement)src);
        }
        return contributions;
    }

    protected void computeMetrics(Source src, ModuleContributions contributions) {
        OwnershipMetrics ownershipMetrics = new OwnershipMetrics(contributions.getContributions());
        List<Metric> metrics = ownershipMetrics.getMetrics();
        MetricSet metricSet = new MetricSet(contributions.getModuleName(), contributions.getToDate(), contributions.getFromDate(), metrics);
        this.dao.saveData(this.getPersitenceUnitName(), (Object)metricSet, (HarmonyModelElement)src);
    }

    public ModuleContributions getModuleContributions(String moduleName, Date fromDate, Date toDate, List<Item> itemsInModule) {
        ModuleContributions contribs = new ModuleContributions(moduleName, fromDate, toDate);
        ArrayList actions = new ArrayList();
        for (Item i : itemsInModule) {
            actions.addAll(this.dao.getActions(i, fromDate, toDate));
        }
        for (Action action : actions) {
            Author author = (Author)action.getEvent().getAuthors().get(0);
            if (author.getName().equals("cvs2svn")) continue;
            Contribution contrib = contribs.getContribution(author.getNativeId());
            if (contrib == null) {
                contrib = new Contribution(author.getNativeId(), 0, 0);
            }
            contrib.setTouches(contrib.getTouches() + 1);
            String churnString = (String)action.getMetadata().get("churn");
            if (churnString != null) {
                contrib.setChurn(contrib.getChurn() + Integer.parseInt(churnString));
            }
            contribs.put(author.getNativeId(), contrib);
        }
        return contribs;
    }
}

