/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.harmony.analysis.ownership.contributions;

import fr.labri.harmony.analysis.ownership.contributions.Contribution;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.MapKeyColumn;
import javax.persistence.OneToMany;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
public class ModuleContributions {
    @Id
    @GeneratedValue
    private int id;
    private String moduleName;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date fromDate;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date toDate;
    @OneToMany(mappedBy="moduleContributions", cascade={CascadeType.ALL})
    @MapKeyColumn(name="authorNativeId")
    private Map<String, Contribution> contributions = new HashMap<String, Contribution>();

    public ModuleContributions() {
    }

    public ModuleContributions(String moduleName, Date fromDate, Date toDate) {
        this();
        this.fromDate = fromDate;
        this.toDate = toDate;
        this.moduleName = moduleName;
    }

    public Collection<Contribution> getContributions() {
        return this.contributions.values();
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public void put(String author, Contribution contrib) {
        contrib.setItemContributions(this);
        this.contributions.put(author, contrib);
    }

    public Contribution getContribution(String author) {
        return this.contributions.get(author);
    }
}

