/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.harmony.analysis.ownership.metric;

import fr.labri.harmony.analysis.ownership.contributions.Contribution;
import fr.labri.harmony.analysis.ownership.metric.Metric;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class OwnershipMetrics {
    protected Collection<Contribution> contributions;
    private static final double MAJOR_CONTRIBUTOR_THRESHOLD = 0.05;
    private Float ownership = Float.valueOf(0.0f);
    private Integer major = 0;
    private Integer minor = 0;
    private Integer total = 0;

    public OwnershipMetrics(Collection<Contribution> contributions) {
        this.contributions = contributions;
        this.computeMetrics();
    }

    private void computeMetrics() {
        for (Contribution c : this.contributions) {
            this.total = this.total + c.getTouches();
        }
        for (Contribution c : this.contributions) {
            float own = (float)c.getTouches() / (float)this.total.intValue();
            if ((double)own > 0.05) {
                this.major = this.major + 1;
            } else {
                this.minor = this.minor + 1;
            }
            if (!(own > this.ownership.floatValue())) continue;
            this.ownership = Float.valueOf(own);
        }
    }

    public List<Metric> getMetrics() {
        ArrayList<Metric> metrics = new ArrayList<Metric>();
        Collections.addAll(metrics, new Metric("Ownership", this.ownership), new Metric("Major", this.major), new Metric("Minor", this.minor), new Metric("Total", this.major + this.minor));
        return metrics;
    }
}

