/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.harmony.ownership.output;

import au.com.bytecode.opencsv.CSVWriter;
import fr.labri.harmony.analysis.ownership.metric.Metric;
import fr.labri.harmony.analysis.ownership.metric.MetricSet;
import fr.labri.harmony.core.analysis.AbstractAnalysis;
import fr.labri.harmony.core.config.model.AnalysisConfiguration;
import fr.labri.harmony.core.dao.Dao;
import fr.labri.harmony.core.model.HarmonyModelElement;
import fr.labri.harmony.core.model.Source;
import fr.labri.harmony.core.output.OutputUtils;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class OwnershipMetricsToCsv
extends AbstractAnalysis {
    public OwnershipMetricsToCsv() {
    }

    public OwnershipMetricsToCsv(AnalysisConfiguration config, Dao dao, Properties properties) {
        super(config, dao, properties);
    }

    public void runOn(Source src) throws Exception {
        ArrayList<String[]> lines = new ArrayList<String[]>();
        ArrayList<String> headers = null;
        List metricSets = this.dao.getData(this.getPersitenceUnitName(), MetricSet.class, (HarmonyModelElement)src);
        if (metricSets == null || metricSets.size() == 0) {
            return;
        }
        headers = this.getHeaders(metricSets);
        for (MetricSet metricSet : metricSets) {
            ArrayList<String> nextLine = new ArrayList<String>();
            nextLine.add(metricSet.getElementName());
            for (Metric m : metricSet.getMetrics()) {
                nextLine.add(m.getValue());
            }
            lines.add(nextLine.toArray(new String[nextLine.size()]));
        }
        CSVWriter writer = new CSVWriter((Writer)Files.newBufferedWriter(OutputUtils.buildOutputPath((Source)src, (AbstractAnalysis)this, (String)"ownership.csv"), Charset.defaultCharset(), new OpenOption[0]));
        writer.writeNext(headers.toArray(new String[headers.size()]));
        writer.writeAll(lines);
        writer.close();
    }

    private ArrayList<String> getHeaders(List<MetricSet> metrics) {
        ArrayList<String> headers = new ArrayList<String>();
        headers.add("name");
        for (Metric m : metrics.get(0).getMetrics()) {
            headers.add(m.getName());
        }
        return headers;
    }
}

