/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.jpa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.gemini.jpa.GeminiUtil;
import org.eclipse.gemini.jpa.PUnitInfo;
import org.eclipse.persistence.internal.libraries.asm.ClassWriter;

public class AnchorClassUtil {
    public static final String ANCHOR_CLASS_NAME = "Jpa$Anchor";
    boolean generateAnchorClasses;

    public AnchorClassUtil(boolean generateAnchors) {
        this.generateAnchorClasses = generateAnchors;
    }

    public String getAnchorClassName() {
        return ANCHOR_CLASS_NAME;
    }

    public boolean generateAnchorClasses() {
        return this.generateAnchorClasses;
    }

    public List<String> uniquePackages(Collection<PUnitInfo> pUnits) {
        if (!this.generateAnchorClasses()) {
            return new ArrayList<String>();
        }
        HashSet<String> packageNamesInBundle = new HashSet<String>();
        for (PUnitInfo info : pUnits) {
            HashSet<String> packageNamesInUnit = new HashSet<String>();
            for (String classString : info.getClasses()) {
                int idx = classString.lastIndexOf(46);
                String packageName = classString.substring(0, idx);
                String formattedName = GeminiUtil.formattedPackageString(packageName, '.', '/');
                packageNamesInUnit.add(formattedName);
                packageNamesInBundle.add(formattedName);
            }
            ArrayList<String> namesInUnit = new ArrayList<String>();
            namesInUnit.addAll(packageNamesInUnit);
            info.setUniquePackageNames(namesInUnit);
        }
        ArrayList<String> namesInBundle = new ArrayList<String>();
        namesInBundle.addAll(packageNamesInBundle);
        GeminiUtil.debug("AnchorUtil - Unique managed class package names: ", namesInBundle);
        return namesInBundle;
    }

    public List<byte[]> generateAnchorInterfaces(List<String> packageNames) {
        ArrayList<byte[]> bytes = new ArrayList<byte[]>();
        if (!this.generateAnchorClasses()) {
            return bytes;
        }
        for (String packageName : packageNames) {
            ClassWriter writer = new ClassWriter(2);
            String fullClassName = String.valueOf(GeminiUtil.formattedPackageString(packageName, '.', '/')) + this.getAnchorClassName();
            GeminiUtil.debug("AnchorUtil generating anchor interface ", (Object)fullClassName);
            writer.visit(49, 1537, fullClassName, "java/lang/Object", null, null);
            writer.visitEnd();
            bytes.add(writer.toByteArray());
        }
        return bytes;
    }

    Map<String, Class<?>> loadAnchorClasses(PUnitInfo pUnitInfo) {
        HashMap result = new HashMap();
        if (!this.generateAnchorClasses()) {
            return result;
        }
        for (String packageName : pUnitInfo.getUniquePackageNames()) {
            String className = String.valueOf(GeminiUtil.formattedPackageString(packageName, '/', '.')) + this.getAnchorClassName();
            try {
                GeminiUtil.debug("AnchorUtil loading anchor class ", (Object)className);
                Class cls = pUnitInfo.getBundle().loadClass(className);
                GeminiUtil.debug("AnchorUtil loaded anchor class ", (Object)cls);
                result.put(className, cls);
            }
            catch (ClassNotFoundException cnfEx) {
                GeminiUtil.fatalError("Could not load anchor class " + className, cnfEx);
            }
        }
        return result;
    }
}

