/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.jpa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.gemini.jpa.AnchorClassUtil;
import org.eclipse.gemini.jpa.FragmentUtil;
import org.eclipse.gemini.jpa.GeminiSystemProperties;
import org.eclipse.gemini.jpa.GeminiUtil;
import org.eclipse.gemini.jpa.PUnitInfo;
import org.eclipse.gemini.jpa.PersistenceBundleExtender;
import org.eclipse.gemini.jpa.ProviderWrapper;
import org.eclipse.gemini.jpa.ServicesUtil;
import org.eclipse.gemini.jpa.classloader.CompositeClassLoader;
import org.eclipse.gemini.jpa.configadmin.ConfigAdminListener;
import org.eclipse.gemini.jpa.configadmin.PersistenceUnitConfiguration;
import org.eclipse.gemini.jpa.datasource.DataSourceUtil;
import org.eclipse.gemini.jpa.jndi.JndiUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class GeminiManager {
    public static final int MAX_EVENT_COLLISION_TRIES = 3;
    BundleContext ctx;
    Map<String, PUnitInfo> pUnitsByName;
    PersistenceBundleExtender extender;
    ServicesUtil servicesUtil;
    DataSourceUtil dataSourceUtil;
    JndiUtil jndiUtil;
    AnchorClassUtil anchorUtil;
    ConfigAdminListener configAdminListener;
    ProviderWrapper provider;

    public BundleContext getBundleContext() {
        return this.ctx;
    }

    public void setBundleContext(BundleContext ctx) {
        this.ctx = ctx;
    }

    public PersistenceBundleExtender getExtender() {
        return this.extender;
    }

    public void setExtender(PersistenceBundleExtender extender) {
        this.extender = extender;
    }

    public ServicesUtil getServicesUtil() {
        return this.servicesUtil;
    }

    public void setServicesUtil(ServicesUtil util) {
        this.servicesUtil = util;
    }

    public DataSourceUtil getDataSourceUtil() {
        return this.dataSourceUtil;
    }

    public void setDataSourceUtil(DataSourceUtil util) {
        this.dataSourceUtil = util;
    }

    public JndiUtil getJndiUtil() {
        return this.jndiUtil;
    }

    public void setJndiUtil(JndiUtil jndiUtil) {
        this.jndiUtil = jndiUtil;
    }

    public AnchorClassUtil getAnchorUtil() {
        return this.anchorUtil;
    }

    public void setAnchorUtil(AnchorClassUtil util) {
        this.anchorUtil = util;
    }

    public ConfigAdminListener getConfigAdminListener() {
        return this.configAdminListener;
    }

    public void setConfigAdminListener(ConfigAdminListener listener) {
        this.configAdminListener = listener;
    }

    public ProviderWrapper getProvider() {
        return this.provider;
    }

    public void setProvider(ProviderWrapper provider) {
        this.provider = provider;
    }

    public Map<String, PUnitInfo> getPUnitsByName() {
        return this.pUnitsByName;
    }

    public void setPUnitsByName(Map<String, PUnitInfo> pUnitsByName) {
        this.pUnitsByName = pUnitsByName;
    }

    public void startup(BundleContext context) throws Exception {
        this.ctx = context;
        this.pUnitsByName = Collections.synchronizedMap(new HashMap());
        this.provider = new ProviderWrapper();
        this.provider.initialize(this);
        this.extender = new PersistenceBundleExtender(this);
        this.dataSourceUtil = new DataSourceUtil(this);
        this.jndiUtil = new JndiUtil(this);
        this.anchorUtil = new AnchorClassUtil(GeminiSystemProperties.generateAnchorClasses());
        this.servicesUtil = new ServicesUtil(this);
        this.servicesUtil.registerProviderService();
        this.configAdminListener = new ConfigAdminListener(this);
        this.configAdminListener.startListening();
        this.extender.startListening();
        this.extender.lookForExistingBundles();
    }

    public void shutdown(BundleContext context) throws Exception {
        this.configAdminListener.stopListening();
        this.extender.stopListening();
        this.servicesUtil.unregisterProviderService();
        ArrayList<PUnitInfo> pUnits = new ArrayList<PUnitInfo>();
        pUnits.addAll(this.pUnitsByName.values());
        this.unregisterPersistenceUnits(pUnits);
        this.pUnitsByName = null;
        this.extender.clearAllPUnitInfos();
        this.provider.shutdown(context);
        this.provider = null;
        this.extender = null;
        this.configAdminListener = null;
        this.dataSourceUtil = null;
        this.anchorUtil = null;
        this.servicesUtil = null;
    }

    public void preResolve(Bundle b, Collection<PUnitInfo> pUnits) {
        GeminiUtil.debug("Manager.preResolve, bundle: ", (Object)b.getSymbolicName());
        if (GeminiSystemProperties.generateFragments()) {
            new FragmentUtil(this.getBundle()).generateAndInstallFragment(b, pUnits, this.getAnchorUtil());
        }
        CompositeClassLoader compositeLoader = CompositeClassLoader.createCompositeLoader(this.getBundleContext(), b);
        this.provider.initializeForWeaving(compositeLoader, pUnits);
    }

    public void registerPersistenceUnits(Collection<PUnitInfo> pUnits) {
        GeminiUtil.debug("Manager.registerPersistenceUnits: ", pUnits);
        if (pUnits == null) {
            return;
        }
        for (PUnitInfo info : pUnits) {
            PersistenceUnitConfiguration config;
            String unitName = info.getUnitName();
            if (this.pUnitsByName.containsKey(unitName)) {
                PUnitInfo existingInfo = this.pUnitsByName.get(unitName);
                if (existingInfo != null && existingInfo.getBundle() == info.getBundle()) continue;
                int attempts = 0;
                while (this.pUnitsByName.containsKey(unitName) && attempts < 3) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    ++attempts;
                }
                if (this.pUnitsByName.containsKey(unitName)) {
                    GeminiUtil.warning("Manager forcing unregister of persistence unit: " + info.getUnitName());
                    ArrayList<PUnitInfo> units = new ArrayList<PUnitInfo>();
                    units.add(info);
                    this.unregisterPersistenceUnits(units);
                }
            }
            if ((config = this.getConfigAdminListener().configForPersistenceUnitName(unitName)) != null) {
                GeminiUtil.debug("Manager.registerPersistenceUnits found incremental config for punit ", unitName, "\n", config);
                config.updatePUnitInfo(info);
            }
            this.pUnitsByName.put(unitName, info);
            this.servicesUtil.registerEMFServices(info);
        }
    }

    public void unregisterPersistenceUnits(Collection<PUnitInfo> pUnits) {
        GeminiUtil.debug("Manager.unregisterPersistenceUnits: ", pUnits);
        if (pUnits == null) {
            return;
        }
        for (PUnitInfo info : pUnits) {
            this.servicesUtil.unregisterWeavingHookService(info);
            this.servicesUtil.unregisterEMFServices(info);
            this.pUnitsByName.remove(info.getUnitName());
        }
    }

    public Bundle getBundle() {
        return this.ctx.getBundle();
    }
}

