/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.jpa;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.gemini.jpa.GeminiSystemProperties;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

public class GeminiUtil {
    public static String JPA_PROVIDER_PROPERTY = "javax.persistence.provider";
    public static String JPA_JDBC_DRIVER_PROPERTY = "javax.persistence.jdbc.driver";
    public static String JPA_JDBC_URL_PROPERTY = "javax.persistence.jdbc.url";
    public static String JPA_JDBC_USER_PROPERTY = "javax.persistence.jdbc.user";
    public static String JPA_JDBC_PASSWORD_PROPERTY = "javax.persistence.jdbc.password";
    public static String OSGI_JDBC_DRIVER_VERSION_PROPERTY = "osgi.jdbc.driver.version";
    public static String OSGI_JPA_PROVIDER_VERSION_PROPERTY = "osgi.jpa.provider.version";
    public static String PUNIT_INFO_PROPERTY = "gemini.jpa.punitInfo";

    public static String bundleVersion(Bundle b) {
        return b.getVersion().toString();
    }

    public static String formattedPackageString(String s, char beingReplaced, char replacer) {
        String formatted = s;
        if (formatted.indexOf(beingReplaced) >= 0) {
            formatted = formatted.replace(beingReplaced, replacer);
        }
        if (formatted.charAt(formatted.length() - 1) != replacer) {
            formatted = String.valueOf(formatted) + replacer;
        }
        return formatted;
    }

    public static void close(Closeable c) {
        try {
            c.close();
        }
        catch (Throwable throwable) {}
    }

    public static PackageAdmin getPackageAdmin(BundleContext ctx) {
        ServiceReference ref = ctx.getServiceReference(PackageAdmin.class.getName());
        return ref != null ? (PackageAdmin)ctx.getService(ref) : null;
    }

    public static String stripPrecedingSlash(String s) {
        if (s == null || s.length() == 0 || !s.startsWith("/")) {
            return s;
        }
        return s.length() == 1 ? "" : s.substring(1, s.length());
    }

    public static Class<?> loadClassFromBundle(String clsName, Bundle b) {
        GeminiUtil.debug("Loading class ", clsName, " from bundle ", b);
        try {
            return b.loadClass(clsName);
        }
        catch (ClassNotFoundException cnfEx) {
            GeminiUtil.fatalError("Could not load class " + clsName + " from bundle " + b, cnfEx);
            return null;
        }
    }

    public static Map<String, String> serviceProperties(ServiceReference ref) {
        HashMap<String, String> props = new HashMap<String, String>();
        String[] stringArray = ref.getPropertyKeys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            props.put(s, (String)ref.getProperty(s));
            ++n2;
        }
        return props;
    }

    public static void fatalError(String s, Throwable t) {
        if (t == null) {
            GeminiUtil.privateDebug("*** FATAL ERROR *** ", s);
        } else {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            t.printStackTrace(new PrintWriter(baos));
            GeminiUtil.privateDebug("*** FATAL ERROR *** ", s, baos.toString());
        }
        throw new RuntimeException(s, t);
    }

    public static void warning(String msg) {
        GeminiUtil.warning(msg, "");
    }

    public static void warning(String msg, Throwable t) {
        String msg2 = t != null ? " Exception: " + t : "";
        GeminiUtil.warning(msg, msg2);
    }

    public static void warning(String msg, String msg2) {
        GeminiUtil.privateDebug("WARNING: ", msg, msg2);
    }

    public static void debugXml(String ... msgs) {
        if (GeminiSystemProperties.debugXml()) {
            GeminiUtil.privateDebug(msgs);
        }
    }

    public static void debugClassLoader(String ... msgs) {
        if (GeminiSystemProperties.debugClassloader()) {
            GeminiUtil.privateDebug(msgs);
        }
    }

    public static void debugClassLoader(Object ... args) {
        if (GeminiSystemProperties.debugClassloader()) {
            GeminiUtil.privateDebug(args);
        }
    }

    public static void debugClassLoader(String s, ClassLoader cl) {
        if (GeminiSystemProperties.debugClassloader()) {
            GeminiUtil.privateDebug(s, String.valueOf(cl));
            ClassLoader p = cl;
            while (p.getParent() != null) {
                GeminiUtil.privateDebug("  Parent loader: ", p.getParent());
                p = p.getParent();
            }
        }
    }

    public static void debugWeaving(String ... msgs) {
        if (GeminiSystemProperties.debugWeaving()) {
            GeminiUtil.privateDebug(msgs);
        }
    }

    public static void debug(String ... msgs) {
        if (GeminiSystemProperties.debug()) {
            GeminiUtil.privateDebug(msgs);
        }
    }

    public static void debug(Object ... args) {
        if (GeminiSystemProperties.debug()) {
            GeminiUtil.privateDebug(args);
        }
    }

    public static void debug(String msg, Object obj) {
        if (GeminiSystemProperties.debug()) {
            if (obj == null) {
                GeminiUtil.privateDebug(msg, String.valueOf(obj));
            } else if (ClassLoader.class.isAssignableFrom(obj.getClass()) && GeminiSystemProperties.debugXml()) {
                GeminiUtil.debugClassLoader(msg, (ClassLoader)obj);
            } else if (Bundle.class.isAssignableFrom(obj.getClass())) {
                Bundle b = (Bundle)obj;
                GeminiUtil.privateDebug(msg, " bundle=", b.getSymbolicName(), " id=", b.getBundleId(), " state=", GeminiUtil.stringBundleStateFromInt(b.getState()));
            } else if (BundleEvent.class.isAssignableFrom(obj.getClass())) {
                BundleEvent event = (BundleEvent)obj;
                GeminiUtil.privateDebug(msg, GeminiUtil.stringBundleEventFromInt(event.getType()), "  bundle=", event.getBundle().getSymbolicName());
            } else if (obj.getClass().isArray()) {
                GeminiUtil.privateDebug(msg);
                int len = ((Object[])obj).length;
                int i = 0;
                while (i < len) {
                    GeminiUtil.privateDebug("  ", String.valueOf(Array.get(obj, i)));
                    ++i;
                }
            } else if (Dictionary.class.isAssignableFrom(obj.getClass())) {
                GeminiUtil.privateDebug(msg);
                Dictionary dict = (Dictionary)obj;
                Enumeration keysEnum = dict.keys();
                Enumeration valsEnum = dict.elements();
                while (keysEnum.hasMoreElements()) {
                    GeminiUtil.privateDebug("  key: ", keysEnum.nextElement(), " value: ", valsEnum.nextElement());
                }
            } else {
                GeminiUtil.privateDebug(msg, String.valueOf(obj));
            }
        }
    }

    public static String stringBundleStateFromInt(int bundleState) {
        switch (bundleState) {
            case 1: {
                return "UNINSTALLED";
            }
            case 2: {
                return "INSTALLED";
            }
            case 4: {
                return "RESOLVED";
            }
            case 8: {
                return "STARTING";
            }
            case 16: {
                return "STOPPING";
            }
            case 32: {
                return "ACTIVE";
            }
        }
        return "UNDEFINED_STATE: " + bundleState;
    }

    public static String stringBundleEventFromInt(int eventType) {
        switch (eventType) {
            case 1: {
                return "INSTALLED";
            }
            case 2: {
                return "STARTED";
            }
            case 4: {
                return "STOPPED";
            }
            case 8: {
                return "UPDATED";
            }
            case 16: {
                return "UNINSTALLED";
            }
            case 32: {
                return "RESOLVED";
            }
            case 64: {
                return "UNRESOLVED";
            }
            case 128: {
                return "STARTING";
            }
            case 256: {
                return "STOPPING";
            }
            case 512: {
                return "LAZY_ACTIVATION";
            }
        }
        return "UNDEFINED_EVENT: " + eventType;
    }

    public static void privateDebug(String ... msgs) {
        StringBuilder sb = new StringBuilder();
        String[] stringArray = msgs;
        int n = msgs.length;
        int n2 = 0;
        while (n2 < n) {
            String msg = stringArray[n2];
            sb.append(msg);
            ++n2;
        }
        System.out.println(sb.toString());
        System.out.flush();
    }

    public static void privateDebug(Object ... args) {
        String[] msgs = new String[args.length];
        int i = 0;
        while (i < args.length) {
            msgs[i] = String.valueOf(args[i]);
            ++i;
        }
        GeminiUtil.privateDebug(msgs);
    }
}

