/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.jpa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.gemini.jpa.GeminiManager;
import org.eclipse.gemini.jpa.GeminiSystemProperties;
import org.eclipse.gemini.jpa.GeminiUtil;
import org.eclipse.gemini.jpa.PUnitInfo;
import org.eclipse.gemini.jpa.PersistenceDescriptorInfo;
import org.eclipse.gemini.jpa.PersistenceUnitBundleUtil;
import org.eclipse.gemini.jpa.configadmin.InlinedDescriptorInfo;
import org.eclipse.gemini.jpa.configadmin.PersistenceUnitConfiguration;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.packageadmin.PackageAdmin;

public class PersistenceBundleExtender
implements SynchronousBundleListener {
    GeminiManager mgr;
    PersistenceUnitBundleUtil bundleUtil;
    Map<Bundle, List<PUnitInfo>> unitsByBundle = Collections.synchronizedMap(new HashMap());
    Map<String, Bundle> inLimbo = Collections.synchronizedMap(new HashMap());
    Set<Long> lazyBundles = new HashSet<Long>();
    Set<Long> refreshingBundles = new HashSet<Long>();

    public PersistenceBundleExtender() {
    }

    public PersistenceBundleExtender(GeminiManager mgr) {
        this.mgr = mgr;
        this.bundleUtil = new PersistenceUnitBundleUtil();
    }

    public void startListening() {
        GeminiUtil.debug("Extender.startListening");
        this.mgr.getBundleContext().addBundleListener((BundleListener)this);
    }

    public void stopListening() {
        GeminiUtil.debug("Extender.stopListening");
        this.mgr.getBundleContext().removeBundleListener((BundleListener)this);
    }

    public void lookForExistingBundles() {
        Bundle[] installedBundles = this.mgr.getBundleContext().getBundles();
        GeminiUtil.debug("Extender.lookForExistingBundles: ", (Object)installedBundles);
        Bundle[] bundleArray = installedBundles;
        int n = installedBundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle b = bundleArray[n2];
            if (this.isPersistenceUnitBundle(b)) {
                if (GeminiSystemProperties.refreshPersistenceBundles()) {
                    if (b.getState() == 32) {
                        if (this.isAssigned(b)) {
                            GeminiUtil.debug("Found existing installed bundle " + b.getSymbolicName(), (Object)" but it was already assigned");
                        } else {
                            GeminiUtil.debug("Found active bundle ", b, " - refreshing to push it back to resolve for processing");
                            this.refreshBundle(b);
                        }
                    }
                } else if (b.getState() != 1) {
                    GeminiUtil.warning("Extender - Refreshing disabled - entities in bundle " + b.getSymbolicName(), " may not be woven");
                    this.tryAssigningPersistenceUnitsInBundle(b);
                    if (b.getState() == 8 || b.getState() == 32) {
                        this.registerPersistenceUnitsInBundle(b);
                    }
                }
            }
            ++n2;
        }
    }

    public Map<Bundle, List<PUnitInfo>> clearAllPUnitInfos() {
        Map<Bundle, List<PUnitInfo>> pUnitInfos = this.unitsByBundle;
        this.unitsByBundle = null;
        this.lazyBundles = null;
        this.refreshingBundles = null;
        return pUnitInfos;
    }

    public void tryAssigningPersistenceUnitsInBundle(Bundle b) {
        GeminiUtil.debug("Extender.tryAssigningPersistenceUnitsInBundle: ", (Object)b);
        if (this.isAssigned(b)) {
            GeminiUtil.warning("Attempted to assign a bundle that was already assigned: ", b.toString());
            return;
        }
        List<PersistenceDescriptorInfo> descriptorInfos = this.bundleUtil.persistenceDescriptorInfos(b);
        if (descriptorInfos.isEmpty()) {
            PersistenceUnitConfiguration config = this.mgr.getConfigAdminListener().configForBundle(b.getSymbolicName());
            if (config != null) {
                GeminiUtil.debug("No persistence descriptors, but found a config for bundle ", (Object)b);
                descriptorInfos.add(new InlinedDescriptorInfo(config));
            } else {
                GeminiUtil.warning("No persistence descriptors found in persistence bundle ", b.getSymbolicName());
                GeminiUtil.debug("Putting bundle ", b, " in limbo");
                this.inLimbo.put(b.getSymbolicName(), b);
                return;
            }
        }
        Set<PUnitInfo> pUnitInfos = this.bundleUtil.persistenceUnitInfoFromXmlFiles(descriptorInfos);
        for (PUnitInfo info : pUnitInfos) {
            if (info.getProvider() != null && !"org.eclipse.persistence.jpa.PersistenceProvider".equals(info.getProvider())) continue;
            info.setBundle(b);
            info.setAssignedProvider(this.mgr.getProvider());
            GeminiUtil.debug("Assigning punit ", info.getUnitName(), " to this provider");
            this.addToBundleUnits(this.unitsByBundle, b, info);
        }
        List<PUnitInfo> unitsFound = this.unitsByBundle.get(b);
        if (unitsFound != null && unitsFound.size() != 0) {
            this.mgr.preResolve(b, (Collection<PUnitInfo>)this.unitsByBundle.get(b));
        }
    }

    public void unassignPersistenceUnitsInBundle(Bundle b) {
        GeminiUtil.debug("Extender.unassignPersistenceUnitsInBundle: ", (Object)b);
        List<PUnitInfo> infos = this.unitsByBundle.get(b);
        this.unitsByBundle.remove(b);
        this.removeFromLazyBundles(b);
        for (PUnitInfo info : infos) {
            info.setAssignedProvider(null);
            info.setBundle(null);
        }
    }

    public void registerPersistenceUnitsInBundle(Bundle b) {
        GeminiUtil.debug("Extender.registerPersistenceUnitsInBundle: ", (Object)b);
        if (!this.isAssigned(b)) {
            GeminiUtil.warning("Register called on bundle " + b.getSymbolicName(), " but bundle was not assigned");
            return;
        }
        if (this.areCompatibleBundles(b, this.mgr.getBundle())) {
            GeminiUtil.debug("Extender provider compatible with bundle: ", (Object)b);
            this.mgr.registerPersistenceUnits((Collection<PUnitInfo>)this.unitsByBundle.get(b));
        } else {
            GeminiUtil.warning("Cannot support bundle " + b.getSymbolicName() + " because it is not JPA-compatible with the EclipseLink bundles. " + "This is because there are multiple bundles exporting javax.persistence " + "and the persistence unit bundle has resolved to a different one than " + "the EclipseLink bundles. " + "\nTo fix this, uninstall one of the bundles containing javax.persistence " + "so that both the persistence unit bundle and the provider bundles resolve " + "to the same javax.persistence package.");
            this.unassignPersistenceUnitsInBundle(b);
        }
    }

    public void unregisterPersistenceUnitsInBundle(Bundle b) {
        GeminiUtil.debug("Extender.unregisterPersistenceUnitsInBundle: ", (Object)b);
        if (!this.isAssigned(b)) {
            GeminiUtil.warning("Unregister called on bundle " + b.getSymbolicName(), " but bundle was not assigned");
            return;
        }
        this.mgr.unregisterPersistenceUnits((Collection<PUnitInfo>)this.unitsByBundle.get(b));
    }

    public void refreshBundle(Bundle b) {
        GeminiUtil.debug("Extender.refreshBundle: ", (Object)b);
        this.addToRefreshingBundles(b);
        PackageAdmin admin = GeminiUtil.getPackageAdmin(this.mgr.getBundleContext());
        admin.refreshPackages(new Bundle[]{b});
    }

    public boolean isInLimbo(String bsn) {
        return this.inLimbo.containsKey(bsn);
    }

    public Bundle getBundleInLimbo(String bsn) {
        return this.inLimbo.remove(bsn);
    }

    public void bundleChanged(BundleEvent event) {
        Bundle b = event.getBundle();
        GeminiUtil.debug("Extender - bundle event: ", (Object)event);
        if (!this.isPersistenceUnitBundle(b)) {
            return;
        }
        int eventType = event.getType();
        if (eventType == 1) {
            this.tryAssigningPersistenceUnitsInBundle(b);
        } else if (eventType == 512) {
            if (this.isAssigned(b)) {
                this.lazyBundles.add(b.getBundleId());
                this.registerPersistenceUnitsInBundle(b);
            }
        } else if (eventType == 128) {
            if (!this.isAssigned(b) && !GeminiSystemProperties.refreshPersistenceBundles()) {
                GeminiUtil.warning("Refreshing disabled - Bundle " + b.getSymbolicName(), " starting - entities may not be woven");
                this.tryAssigningPersistenceUnitsInBundle(b);
            }
            if (this.isAssigned(b) && !this.isLazy(b)) {
                this.registerPersistenceUnitsInBundle(b);
            }
        } else if (eventType == 2) {
            if (!this.isAssigned(b) && !this.isInLimbo(b.getSymbolicName())) {
                if (GeminiSystemProperties.refreshPersistenceBundles()) {
                    this.refreshBundle(b);
                } else {
                    GeminiUtil.warning("Refreshing disabled - Bundle " + b.getSymbolicName(), " started - entities may not be woven");
                    this.tryAssigningPersistenceUnitsInBundle(b);
                    if (this.isAssigned(b) && !this.isLazy(b)) {
                        this.registerPersistenceUnitsInBundle(b);
                    }
                }
            }
        } else if (eventType == 256) {
            if (this.isAssigned(b)) {
                if (this.isLazy(b)) {
                    this.removeFromLazyBundles(b);
                }
                this.unregisterPersistenceUnitsInBundle(b);
            }
        } else if (eventType == 16) {
            if (this.isAssigned(b)) {
                this.unassignPersistenceUnitsInBundle(b);
            }
        } else if (eventType == 8) {
            if (this.isAssigned(b)) {
                this.unassignPersistenceUnitsInBundle(b);
            }
            this.tryAssigningPersistenceUnitsInBundle(b);
        } else if (eventType == 64 && this.isRefreshing(b)) {
            this.tryAssigningPersistenceUnitsInBundle(b);
            this.removeFromRefreshingBundles(b);
        }
    }

    public boolean isAssigned(Bundle b) {
        return this.unitsByBundle.containsKey(b);
    }

    public boolean isLazy(Bundle b) {
        return this.lazyBundles.contains(b.getBundleId());
    }

    protected boolean addToLazyBundles(Bundle b) {
        return this.lazyBundles.add(b.getBundleId());
    }

    protected boolean removeFromLazyBundles(Bundle b) {
        return this.lazyBundles.remove(b.getBundleId());
    }

    public boolean isRefreshing(Bundle b) {
        return this.refreshingBundles.contains(b.getBundleId());
    }

    protected void addToRefreshingBundles(Bundle b) {
        this.refreshingBundles.add(b.getBundleId());
    }

    protected void removeFromRefreshingBundles(Bundle b) {
        this.refreshingBundles.remove(b.getBundleId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToBundleUnits(Map<Bundle, List<PUnitInfo>> map, Bundle b, PUnitInfo info) {
        Map<Bundle, List<PUnitInfo>> map2 = map;
        synchronized (map2) {
            List<PUnitInfo> infos;
            if (!map.containsKey(b)) {
                map.put(b, new ArrayList());
            }
            if (!(infos = map.get(b)).contains(info)) {
                infos.add(info);
            }
        }
    }

    public boolean isPersistenceUnitBundle(Bundle b) {
        return b.getHeaders().get("Meta-Persistence") != null;
    }

    public boolean isLazyActivatedBundle(Bundle b) {
        String policy = (String)b.getHeaders().get("Bundle-ActivationPolicy");
        return policy != null && policy.equals("lazy");
    }

    public boolean areCompatibleBundles(Bundle pUnitBundle, Bundle providerBundle) {
        try {
            GeminiUtil.debug("Extender - checking bundle compatibility of: ", (Object)pUnitBundle);
            Class pUnitClass = pUnitBundle.loadClass("javax.persistence.Entity");
            Class providerClass = providerBundle.loadClass("javax.persistence.Entity");
            return pUnitClass.getClassLoader() == providerClass.getClassLoader();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return true;
        }
    }
}

