/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.jpa;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.gemini.jpa.GeminiUtil;
import org.eclipse.gemini.jpa.PUnitInfo;
import org.eclipse.gemini.jpa.PersistenceDescriptorInfo;
import org.eclipse.gemini.jpa.xml.PersistenceDescriptorHandler;
import org.osgi.framework.Bundle;
import org.xml.sax.helpers.DefaultHandler;

public class PersistenceUnitBundleUtil {
    public static final String JPA_MANIFEST_HEADER = "Meta-Persistence";
    public static final String EMBEDDED_JAR_SEPARATOR = "!/";
    public static final String DEFAULT_DESCRIPTOR_PATH = "META-INF/persistence.xml";

    public List<PersistenceDescriptorInfo> persistenceDescriptorInfos(Bundle pUnitBundle) {
        Object headerEntry;
        ArrayList<PersistenceDescriptorInfo> descInfos = new ArrayList<PersistenceDescriptorInfo>();
        GeminiUtil.debug("Looking for persistence descriptors in bundle ", (Object)pUnitBundle.getSymbolicName());
        URL defaultUrl = pUnitBundle.getEntry(DEFAULT_DESCRIPTOR_PATH);
        if (defaultUrl != null) {
            descInfos.add(new PersistenceDescriptorInfo(defaultUrl, DEFAULT_DESCRIPTOR_PATH));
        }
        if ((headerEntry = pUnitBundle.getHeaders().get(JPA_MANIFEST_HEADER)) != null) {
            String[] stringArray = headerEntry.toString().split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String paddedPath = stringArray[n2];
                String path = GeminiUtil.stripPrecedingSlash(paddedPath.trim());
                if (path.length() != 0 && !path.equals(DEFAULT_DESCRIPTOR_PATH)) {
                    int splitPosition = path.indexOf(EMBEDDED_JAR_SEPARATOR);
                    URL url = null;
                    if (splitPosition == -1) {
                        url = pUnitBundle.getEntry(path);
                        if (url != null) {
                            descInfos.add(new PersistenceDescriptorInfo(url, path));
                        } else {
                            GeminiUtil.warning("Could not find JPA descriptor: ", path);
                        }
                    } else {
                        String jarPrefixPath = path.substring(0, splitPosition);
                        String descPath = path.substring(splitPosition + 2);
                        descPath = GeminiUtil.stripPrecedingSlash(descPath);
                        GeminiUtil.debug("Descriptor JAR prefix: ", (Object)jarPrefixPath);
                        GeminiUtil.debug("Embedded descriptor suffix: ", (Object)descPath);
                        URL prefixUrl = pUnitBundle.getEntry(jarPrefixPath);
                        GeminiUtil.debug("Embedded JAR url: ", (Object)prefixUrl);
                        if (prefixUrl != null) {
                            descInfos.add(new PersistenceDescriptorInfo(prefixUrl, descPath, jarPrefixPath));
                        } else {
                            GeminiUtil.warning("Could not find nested JAR: ", jarPrefixPath);
                        }
                    }
                }
                ++n2;
            }
        }
        GeminiUtil.debug("Found persistence descriptors: ", descInfos);
        return descInfos;
    }

    public Set<PUnitInfo> persistenceUnitInfoFromXmlFiles(List<PersistenceDescriptorInfo> descriptorInfos) {
        HashSet<PUnitInfo> pUnits = new HashSet<PUnitInfo>();
        HashSet<String> pUnitNames = new HashSet<String>();
        InputStream in = null;
        PersistenceDescriptorHandler handler = null;
        for (PersistenceDescriptorInfo info : descriptorInfos) {
            block8: {
                try {
                    try {
                        GeminiUtil.debug("Parsing persistence descriptor ", (Object)info.getDescriptorPath());
                        in = info.getDescriptorStream();
                        SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
                        handler = new PersistenceDescriptorHandler();
                        parser.parse(in, (DefaultHandler)handler);
                        GeminiUtil.debug("Finished parsing persistence descriptor ", (Object)info.getUrl());
                    }
                    catch (Throwable ex) {
                        GeminiUtil.fatalError("Could not parse XML descriptor ", ex);
                        GeminiUtil.close(in);
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    GeminiUtil.close(in);
                    throw throwable;
                }
                GeminiUtil.close(in);
            }
            Set<PUnitInfo> newPUnits = handler.getPersistenceUnitInfo();
            GeminiUtil.debug("Found " + newPUnits.size() + " persistence units");
            for (PUnitInfo unitInfo : newPUnits) {
                String unitName = unitInfo.getUnitName();
                if (pUnitNames.contains(unitName)) {
                    GeminiUtil.fatalError("Persistence unit " + unitName + " already defined ", null);
                }
                pUnitNames.add(unitName);
                unitInfo.setDescriptorInfo(info);
            }
            pUnits.addAll(newPUnits);
        }
        GeminiUtil.debug("Parsed persistence descriptors: ", pUnits);
        return pUnits;
    }
}

