/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.jpa;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.ProviderUtil;
import javax.sql.DataSource;
import org.eclipse.gemini.jpa.GeminiManager;
import org.eclipse.gemini.jpa.GeminiUtil;
import org.eclipse.gemini.jpa.PUnitInfo;
import org.eclipse.gemini.jpa.classloader.CompositeClassLoader;
import org.eclipse.gemini.jpa.eclipselink.EclipseLinkProvider;
import org.osgi.framework.BundleContext;

public class ProviderWrapper
implements PersistenceProvider {
    EclipseLinkProvider nativeProvider;
    GeminiManager mgr;

    public void initialize(GeminiManager mgr) throws Exception {
        this.mgr = mgr;
        this.nativeProvider = new EclipseLinkProvider(mgr);
        this.nativeProvider.initialize();
    }

    public void shutdown(BundleContext context) throws Exception {
        this.nativeProvider.shutdown();
    }

    public EntityManagerFactory createEntityManagerFactory(String emName, Map properties) {
        GeminiUtil.debug("ProviderWrapper createEMF invoked for p-unit: ", emName, " props: ", properties);
        PUnitInfo unitInfo = this.mgr.getPUnitsByName().get(emName);
        if (unitInfo == null) {
            GeminiUtil.fatalError("createEntityManagerFactory() called on provider, but punit has not been registered: ", null);
        }
        HashMap<String, Object> props = new HashMap<String, Object>();
        if (unitInfo.getConfigProperties() != null) {
            props.putAll(unitInfo.getConfigProperties());
        }
        if (properties != null) {
            props.putAll(properties);
        }
        CompositeClassLoader compositeLoader = CompositeClassLoader.createCompositeLoader(this.mgr.getBundleContext(), unitInfo.getBundle());
        if (props.containsKey("eclipselink.classloader")) {
            ClassLoader userLoader = (ClassLoader)props.get("eclipselink.classloader");
            compositeLoader.getClassLoaders().add(0, userLoader);
        }
        props.put("eclipselink.classloader", compositeLoader);
        DataSource ds = this.mgr.getDataSourceUtil().acquireDataSource(unitInfo, properties);
        if (ds != null) {
            props.put("javax.persistence.nonJtaDataSource", ds);
        }
        props.put("eclipselink.persistencexml", this.fullDescriptorPath(unitInfo));
        props.put(GeminiUtil.PUNIT_INFO_PROPERTY, unitInfo);
        EntityManagerFactory emf = this.nativeProvider.createEntityManagerFactory(emName, props);
        return emf;
    }

    public ProviderUtil getProviderUtil() {
        GeminiUtil.debug("ProviderWrapper getProviderUtil invoked");
        return this.nativeProvider.getProviderUtil();
    }

    public boolean generateSchema(String unitName, Map properties) {
        GeminiUtil.debug("ProviderWrapper generateSchema invoked for p-unit: ", unitName, " props: ", properties);
        GeminiUtil.warning("The generateSchema() method is not currently supported by OSGi JPA");
        return false;
    }

    public EntityManagerFactory createContainerEntityManagerFactory(PersistenceUnitInfo info, Map properties) {
        GeminiUtil.fatalError("Container SPI not supported by OSGi JPA", null);
        return null;
    }

    public void generateSchema(PersistenceUnitInfo info, Map properties) {
        GeminiUtil.fatalError("Container SPI not supported by OSGi JPA", null);
    }

    protected void initializeForWeaving(ClassLoader cl, Collection<PUnitInfo> pUnits) {
        this.nativeProvider.initializeForWeaving(cl, pUnits);
    }

    protected String fullDescriptorPath(PUnitInfo pUnitInfo) {
        return pUnitInfo.getDescriptorInfo().fullDescriptorPath();
    }
}

