/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.jpa;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceProvider;
import javax.sql.DataSource;
import org.eclipse.gemini.jpa.GeminiManager;
import org.eclipse.gemini.jpa.GeminiUtil;
import org.eclipse.gemini.jpa.PUnitInfo;
import org.eclipse.gemini.jpa.ProviderWrapper;
import org.eclipse.gemini.jpa.classloader.BundleProxyClassLoader;
import org.eclipse.gemini.jpa.classloader.CompositeClassLoader;
import org.eclipse.gemini.jpa.proxy.EMFBuilderServiceProxyHandler;
import org.eclipse.gemini.jpa.proxy.EMFServiceProxyHandler;
import org.eclipse.gemini.jpa.weaving.WeavingHookTransformer;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.hooks.weaving.WeavingHook;
import org.osgi.framework.wiring.BundleWiring;

public class ServicesUtil {
    GeminiManager mgr;
    String providerClassName;
    ServiceRegistration providerService;

    public ServicesUtil(GeminiManager mgr) {
        this.mgr = mgr;
        this.providerClassName = "org.eclipse.persistence.jpa.PersistenceProvider";
    }

    public void registerProviderService() {
        GeminiUtil.debug("ServicesUtil.RegisterProviderService for ", (Object)this.providerClassName);
        String[] serviceNames = new String[]{PersistenceProvider.class.getName()};
        ProviderWrapper persistenceProvider = this.mgr.getProvider();
        String version = GeminiUtil.bundleVersion(this.mgr.getBundle());
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put(GeminiUtil.OSGI_JPA_PROVIDER_VERSION_PROPERTY, version);
        ((Dictionary)props).put(GeminiUtil.JPA_PROVIDER_PROPERTY, this.providerClassName);
        this.providerService = this.mgr.getBundleContext().registerService(serviceNames, (Object)persistenceProvider, props);
        GeminiUtil.debug("ServicesUtil successfully registered provider service for ", (Object)this.providerClassName);
    }

    public void unregisterProviderService() {
        GeminiUtil.debug("ServicesUtil.unregisterProviderService for ", (Object)this.providerClassName);
        this.providerService.unregister();
        this.providerService = null;
        GeminiUtil.debug("ServicesUtil successfully un-registered provider service for ", (Object)this.providerClassName);
    }

    public void registerWeavingHookService(WeavingHookTransformer weaver, PUnitInfo pUnitInfo) {
        GeminiUtil.debugWeaving("ServicesUtil.registerWeavingHookService for punit ", pUnitInfo.getUnitName());
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("osgi.unit.name", pUnitInfo.getUnitName());
        ServiceRegistration svcReg = this.mgr.getBundleContext().registerService(WeavingHook.class.getName(), (Object)weaver, props);
        pUnitInfo.setWeavingHookService(svcReg);
        GeminiUtil.debug("ServicesUtil successfully registered weaving hook for ", (Object)pUnitInfo.getUnitName());
    }

    public void unregisterWeavingHookService(PUnitInfo pUnitInfo) {
        GeminiUtil.debug("ServicesUtil.unregisterWeavingHookService for ", (Object)pUnitInfo.getUnitName());
        ServiceRegistration svcReg = pUnitInfo.getWeavingHookService();
        if (svcReg != null) {
            svcReg.unregister();
            pUnitInfo.setWeavingHookService(null);
            GeminiUtil.debug("ServicesUtil successfully un-registered weaving hook for ", (Object)pUnitInfo.getUnitName());
        }
    }

    public void registerEMFServices(PUnitInfo pUnitInfo) {
        GeminiUtil.debug("ServicesUtil.registerEMFServices for ", (Object)pUnitInfo.getUnitName());
        Map<String, Class<?>> anchorClasses = this.mgr.getAnchorUtil().loadAnchorClasses(pUnitInfo);
        Dictionary<String, String> props = this.buildServiceProperties(pUnitInfo);
        this.tryToRegisterEMFService(pUnitInfo, anchorClasses, props);
        this.registerEMFBuilderService(pUnitInfo, anchorClasses, props);
    }

    public void unregisterEMFServices(PUnitInfo pUnitInfo) {
        this.unregisterEMFService(pUnitInfo);
        this.unregisterEMFBuilderService(pUnitInfo);
    }

    public void tryToRegisterEMFService(PUnitInfo pUnitInfo, Map<String, Class<?>> anchorClasses, Dictionary<String, String> serviceProps) {
        GeminiUtil.debug("ServicesUtil.tryToRegisterEMF service for ", (Object)pUnitInfo.getUnitName());
        ArrayList proxiedClasses = new ArrayList();
        Class<?> emfClass = GeminiUtil.loadClassFromBundle("javax.persistence.EntityManagerFactory", this.mgr.getBundle());
        proxiedClasses.addAll(anchorClasses.values());
        proxiedClasses.add(emfClass);
        Class[] classArray = proxiedClasses.toArray(new Class[0]);
        GeminiUtil.debug("ServicesUtil EMF proxy class array: ", (Object)classArray);
        ClassLoader loader = this.proxyLoader(pUnitInfo, anchorClasses, emfClass);
        Object emfServiceProxy = this.createEMFProxy(pUnitInfo, loader, classArray);
        String driverClassName = pUnitInfo.getDriverClassName();
        String nonJtaDataSource = pUnitInfo.getNonJtaDataSource();
        if (driverClassName == null && nonJtaDataSource == null) {
            GeminiUtil.debug("ServicesUtil - No driver class or data source specified so no EMF service created");
            return;
        }
        if (nonJtaDataSource != null) {
            DataSource ds = this.mgr.getJndiUtil().lookupDataSource(nonJtaDataSource);
            if (ds == null) {
                GeminiUtil.warning("Non-JTA data source " + nonJtaDataSource + " was not found. EMF service not registered.");
                return;
            }
            pUnitInfo.setJndiDataSource(ds);
        } else if (!this.mgr.getDataSourceUtil().trackDataSourceFactory(pUnitInfo)) {
            GeminiUtil.debug("DataSourceFactory service for " + driverClassName + " not found.");
            try {
                pUnitInfo.getBundle().loadClass(driverClassName);
                GeminiUtil.debug("JDBC driver " + driverClassName + " found locally.");
                this.mgr.getDataSourceUtil().stopTrackingDataSourceFactory(pUnitInfo);
            }
            catch (ClassNotFoundException classNotFoundException) {
                GeminiUtil.debug("JDBC driver " + driverClassName + " was not found locally.");
                GeminiUtil.warning("DataSourceFactory service for " + driverClassName + " was not found. EMF service not registered.");
                return;
            }
        }
        String[] classNameArray = new String[classArray.length];
        int i = 0;
        while (i < classArray.length) {
            classNameArray[i] = classArray[i].getName();
            ++i;
        }
        ServiceRegistration emfService = null;
        try {
            emfService = pUnitInfo.getBundle().getBundleContext().registerService(classNameArray, emfServiceProxy, serviceProps);
            GeminiUtil.debug("ServicesUtil EMF service: ", (Object)emfService);
        }
        catch (Exception e) {
            GeminiUtil.fatalError("ServicesUtil could not register EMF service for " + pUnitInfo.getUnitName(), e);
        }
        pUnitInfo.setEmfService(emfService);
    }

    public void registerEMFBuilderService(PUnitInfo pUnitInfo, Map<String, Class<?>> anchorClasses, Dictionary<String, String> props) {
        GeminiUtil.debug("ServicesUtil.registerEMFBuilder service for ", (Object)pUnitInfo.getUnitName());
        ArrayList proxiedClasses = new ArrayList();
        Class<?> emfBuilderClass = GeminiUtil.loadClassFromBundle("org.osgi.service.jpa.EntityManagerFactoryBuilder", this.mgr.getBundle());
        proxiedClasses.addAll(anchorClasses.values());
        proxiedClasses.add(emfBuilderClass);
        GeminiUtil.debug("ServicesUtil EMFBuilder proxied classes: ", proxiedClasses);
        Class[] classArray = proxiedClasses.toArray(new Class[0]);
        ClassLoader loader = this.proxyLoader(pUnitInfo, anchorClasses, emfBuilderClass);
        Object emfBuilderServiceProxy = this.createEMFBuilderProxy(pUnitInfo, loader, classArray);
        String[] classNameArray = new String[classArray.length];
        int i = 0;
        while (i < classArray.length) {
            classNameArray[i] = classArray[i].getName();
            ++i;
        }
        ServiceRegistration emfBuilderService = null;
        try {
            emfBuilderService = this.mgr.getBundleContext().registerService(classNameArray, emfBuilderServiceProxy, props);
            GeminiUtil.debug("ServicesUtil EMFBuilder service: ", (Object)emfBuilderService);
        }
        catch (Exception e) {
            GeminiUtil.fatalError("ServicesUtil could not register EMFBuilder service for " + pUnitInfo.getUnitName(), e);
        }
        pUnitInfo.setEmfBuilderService(emfBuilderService);
    }

    public void unregisterEMFService(PUnitInfo pUnitInfo) {
        EntityManagerFactory emf;
        GeminiUtil.debug("ServicesUtil.unregisterEMFService for ", (Object)pUnitInfo.getUnitName());
        this.mgr.getDataSourceUtil().stopTrackingDataSourceFactory(pUnitInfo);
        ServiceRegistration emfService = pUnitInfo.getEmfService();
        if (emfService != null) {
            GeminiUtil.debug("ServicesUtil un-registering EMF service for ", (Object)pUnitInfo.getUnitName());
            try {
                emfService.unregister();
            }
            catch (Exception e) {
                GeminiUtil.warning("Error unregistering EMF service: ", e);
            }
            GeminiUtil.debug("ServicesUtil un-registered EMF service for ", (Object)pUnitInfo.getUnitName());
            pUnitInfo.setEmfService(null);
        }
        if ((emf = pUnitInfo.getEmf()) != null && !pUnitInfo.isEmfSetByBuilderService()) {
            if (emf.isOpen()) {
                emf.close();
            }
            pUnitInfo.getEmfHandler().syncUnsetEMF();
            GeminiUtil.debug("ServicesUtil EMF service removed EMF: ", (Object)emf);
        }
        pUnitInfo.setEmfHandler(null);
        pUnitInfo.setJndiDataSource(null);
    }

    public void unregisterEMFBuilderService(PUnitInfo pUnitInfo) {
        EntityManagerFactory emf;
        GeminiUtil.debug("ServicesUtil.unregisterEMFBuilderService for ", (Object)pUnitInfo.getUnitName());
        ServiceRegistration emfBuilderService = pUnitInfo.getEmfBuilderService();
        if (emfBuilderService != null) {
            GeminiUtil.debug("ServicesUtil un-registering EMFBuilder service for ", (Object)pUnitInfo.getUnitName());
            try {
                emfBuilderService.unregister();
            }
            catch (Exception e) {
                GeminiUtil.warning("Error un-registering EMFBuilder service: ", e);
            }
            GeminiUtil.debug("ServicesUtil un-registered EMFBuilder service for ", (Object)pUnitInfo.getUnitName());
            pUnitInfo.setEmfBuilderService(null);
        }
        if ((emf = pUnitInfo.getEmf()) != null) {
            if (emf.isOpen()) {
                emf.close();
            }
            pUnitInfo.getEmfBuilderHandler().syncUnsetEMF();
            GeminiUtil.debug("ServicesUtil EMFBuilder service removed emf: ", (Object)emf);
        }
        pUnitInfo.setEmfBuilderHandler(null);
    }

    ClassLoader extractPUnitLoader(PUnitInfo pUnitInfo, Map<String, Class<?>> anchorClasses) {
        ClassLoader pUnitLoader = null;
        if (!anchorClasses.isEmpty()) {
            pUnitLoader = anchorClasses.values().iterator().next().getClassLoader();
        } else if (!pUnitInfo.getClasses().isEmpty()) {
            try {
                pUnitLoader = pUnitInfo.getBundle().loadClass((String)pUnitInfo.getClasses().toArray()[0]).getClassLoader();
            }
            catch (ClassNotFoundException cnfEx) {
                GeminiUtil.fatalError("Could not load domain class in p-unit", cnfEx);
            }
        } else {
            pUnitLoader = new BundleProxyClassLoader(pUnitInfo.getBundle());
        }
        GeminiUtil.debug("ServicesUtil pUnit loader ", (Object)pUnitLoader);
        return pUnitLoader;
    }

    ClassLoader proxyLoader(PUnitInfo pUnitInfo, Map<String, Class<?>> anchorClasses, Class<?> jpaClass) {
        ClassLoader cl = null;
        if (pUnitInfo.getClasses().isEmpty()) {
            cl = jpaClass.getClassLoader();
        } else if (!anchorClasses.isEmpty()) {
            cl = anchorClasses.values().iterator().next().getClassLoader();
        } else {
            try {
                BundleWiring bw = (BundleWiring)pUnitInfo.getBundle().adapt(BundleWiring.class);
                ClassLoader pUnitLoader = bw != null ? bw.getClassLoader() : pUnitInfo.getBundle().loadClass((String)pUnitInfo.getClasses().toArray()[0]).getClassLoader();
                ClassLoader jpaClassLoader = jpaClass.getClassLoader();
                cl = pUnitLoader == jpaClassLoader ? jpaClassLoader : new CompositeClassLoader(pUnitLoader, jpaClassLoader);
            }
            catch (ClassNotFoundException cnfEx) {
                GeminiUtil.fatalError("Could not load domain class in p-unit", cnfEx);
            }
        }
        GeminiUtil.debugClassLoader("ServicesUtil proxy loader ", cl);
        return cl;
    }

    Object createEMFProxy(PUnitInfo pUnitInfo, ClassLoader loader, Class<?>[] clsArray) {
        EMFServiceProxyHandler emfProxyHandler = new EMFServiceProxyHandler(pUnitInfo);
        Object result = null;
        try {
            result = Proxy.newProxyInstance(loader, clsArray, (InvocationHandler)emfProxyHandler);
            GeminiUtil.debug("ServicesUtil created EMF proxy ");
        }
        catch (Exception e) {
            GeminiUtil.fatalError("ServicesUtil - Failed to create proxy for EMF service: ", e);
        }
        pUnitInfo.setEmfHandler(emfProxyHandler);
        return result;
    }

    Object createEMFBuilderProxy(PUnitInfo pUnitInfo, ClassLoader loader, Class<?>[] clsArray) {
        EMFBuilderServiceProxyHandler emfBuilderProxyHandler = new EMFBuilderServiceProxyHandler(pUnitInfo, pUnitInfo.getEmfHandler());
        Object result = null;
        try {
            result = Proxy.newProxyInstance(loader, clsArray, (InvocationHandler)emfBuilderProxyHandler);
            GeminiUtil.debug("ServicesUtil created EMFBuilder proxy ");
        }
        catch (Exception e) {
            GeminiUtil.fatalError("ServicesUtil - Failed to create proxy for EMFBuilder service: ", e);
        }
        pUnitInfo.setEmfBuilderHandler(emfBuilderProxyHandler);
        return result;
    }

    public Dictionary<String, String> buildServiceProperties(PUnitInfo pUnitInfo) {
        Bundle pUnitBundle = pUnitInfo.getBundle();
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("osgi.unit.name", pUnitInfo.getUnitName());
        ((Dictionary)props).put("osgi.unit.version", GeminiUtil.bundleVersion(pUnitInfo.getBundle()));
        ((Dictionary)props).put("osgi.unit.provider", this.providerClassName);
        String bundleId = String.valueOf(pUnitBundle.getSymbolicName()) + "_" + GeminiUtil.bundleVersion(pUnitBundle);
        ((Dictionary)props).put("osgi.managed.bundles", bundleId);
        GeminiUtil.debug("ServicesUtil.buildServiceProps: ", props);
        return props;
    }
}

