/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.jpa.classloader;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.eclipse.gemini.jpa.GeminiUtil;
import org.eclipse.gemini.jpa.classloader.EclipseDotClasspathHelper;
import org.osgi.framework.Bundle;

public class BundleProxyClassLoader
extends ClassLoader {
    private Bundle bundle;
    private EclipseDotClasspathHelper classpathHelper = new EclipseDotClasspathHelper();

    public BundleProxyClassLoader(Bundle bundle) {
        this.bundle = bundle;
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        try {
            ArrayList<URL> resourceURLs = new ArrayList<URL>(1);
            URL entry = this.getEntry(name);
            if (entry != null) {
                resourceURLs.add(entry);
            }
            return new ListEnumeration(resourceURLs);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    public URL findResource(String name) {
        return this.getEntry(name);
    }

    @Override
    public URL getResource(String name) {
        try {
            if (this.bundle.getState() == 2 || this.bundle.getState() == 1) {
                GeminiUtil.debugClassLoader("Bundle has no classloader so getResource(", name, ") calling findResource");
                return this.findResource(name);
            }
            return this.bundle.getResource(name);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        try {
            if (this.bundle.getState() == 2 || this.bundle.getState() == 1) {
                GeminiUtil.debugClassLoader("Bundle has no classloader so getResources(", name, ") calling findResources");
                return this.findResources(name);
            }
            return this.bundle.getResources(name);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        if (this.bundle.getState() == 2 || this.bundle.getState() == 1) {
            GeminiUtil.debugClassLoader("Bundle has no classloader so loadClass(", name, ") is throwing CNFE");
            throw new ClassNotFoundException(name);
        }
        return this.bundle.loadClass(name);
    }

    protected URL getEntry(String name) {
        URL entry = this.bundle.getEntry(name);
        if (entry == null) {
            entry = this.getEclipseProjectEntry(name, entry);
        }
        return entry;
    }

    protected URL getEclipseProjectEntry(String name, URL entry) {
        String binPath = this.classpathHelper.getBinPath(this.bundle);
        if (binPath != null) {
            entry = this.bundle.getEntry(String.valueOf(binPath) + File.separator + name);
        }
        return entry;
    }

    public String toString() {
        return String.valueOf(super.toString()) + "(" + this.bundle.getSymbolicName() + ")";
    }

    private final class ListEnumeration
    implements Enumeration {
        private Iterator iterator;

        public ListEnumeration(List<?> list) {
            this.iterator = list.iterator();
        }

        @Override
        public boolean hasMoreElements() {
            return this.iterator.hasNext();
        }

        public Object nextElement() {
            return this.iterator.next();
        }
    }
}

