/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.jpa.classloader;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.eclipse.gemini.jpa.GeminiUtil;
import org.eclipse.gemini.jpa.classloader.BundleProxyClassLoader;
import org.eclipse.gemini.jpa.classloader.CompositeEnumeration;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class CompositeClassLoader
extends ClassLoader {
    private static Map<String, String> privateResources = new HashMap<String, String>();
    private List<ClassLoader> classLoaders = new ArrayList<ClassLoader>();

    public static CompositeClassLoader createCompositeLoader(BundleContext providerCtx, Bundle pUnitBundle) {
        BundleProxyClassLoader pUnitLoader = new BundleProxyClassLoader(pUnitBundle);
        GeminiUtil.debugClassLoader("PUnit bundle proxy loader created: ", pUnitLoader);
        BundleProxyClassLoader providerLoader = new BundleProxyClassLoader(providerCtx.getBundle());
        GeminiUtil.debugClassLoader("Provider bundle proxy loader created: ", providerLoader);
        ArrayList<ClassLoader> loaders = new ArrayList<ClassLoader>();
        loaders.add(pUnitLoader);
        loaders.add(providerLoader);
        CompositeClassLoader compositeLoader = new CompositeClassLoader(loaders);
        GeminiUtil.debugClassLoader("Composite loader created: ", compositeLoader);
        return compositeLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addPrivateResource(String resourceName, String resource) {
        Map<String, String> map = privateResources;
        synchronized (map) {
            privateResources.put(resourceName, resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String removePrivateResource(String resourceName) {
        Map<String, String> map = privateResources;
        synchronized (map) {
            return privateResources.remove(resourceName);
        }
    }

    public CompositeClassLoader(ClassLoader loader1, ClassLoader loader2) {
        this.classLoaders.add(loader1);
        this.classLoaders.add(loader2);
    }

    public CompositeClassLoader(List<ClassLoader> loaders) {
        this.classLoaders.addAll(loaders);
    }

    public List<ClassLoader> getClassLoaders() {
        return this.classLoaders;
    }

    @Override
    public synchronized void clearAssertionStatus() {
        for (ClassLoader classLoader : this.getClassLoaders()) {
            classLoader.clearAssertionStatus();
        }
    }

    @Override
    public URL getResource(String name) {
        if (privateResources.containsKey(name)) {
            GeminiUtil.debugClassLoader("getResource()- Found resource ", name, " locally");
            return this.newPrivateResourceURL(name);
        }
        for (ClassLoader classLoader : this.getClassLoaders()) {
            GeminiUtil.debugClassLoader("Attempting getResource(", name, ") on ", classLoader.toString());
            URL resource = classLoader.getResource(name);
            if (resource == null) continue;
            GeminiUtil.debugClassLoader("Found resource(", name, ") from ", classLoader.toString());
            return resource;
        }
        return null;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        if (privateResources.containsKey(name)) {
            GeminiUtil.debugClassLoader("getResourceAsStream() - Found resource ", name, " locally");
            return new StringBufferInputStream(privateResources.get(name));
        }
        for (ClassLoader classLoader : this.getClassLoaders()) {
            GeminiUtil.debugClassLoader("Attempting getResourceAsStream(", name, ") on ", classLoader.toString());
            InputStream stream = classLoader.getResourceAsStream(name);
            if (stream == null) continue;
            GeminiUtil.debugClassLoader("Found resource(", name, ")");
            return stream;
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        if (privateResources.containsKey(name)) {
            GeminiUtil.debugClassLoader("getResources()- Found desc resource ", name, " locally");
            return this.newPrivateResourceURLEnum(name);
        }
        ArrayList enumerations = new ArrayList(this.getClassLoaders().size());
        for (ClassLoader classLoader : this.getClassLoaders()) {
            GeminiUtil.debugClassLoader("Attempting getResources(", name, ") on ", classLoader.toString());
            Enumeration<URL> resources = classLoader.getResources(name);
            if (resources == null) continue;
            GeminiUtil.debugClassLoader("Found resources(", name, ") from ", classLoader.toString());
            enumerations.add(resources);
        }
        return new CompositeEnumeration<URL>(enumerations);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        for (ClassLoader classLoader : this.getClassLoaders()) {
            GeminiUtil.debugClassLoader("Attempting loadClass(", name, ") on ", classLoader.toString());
            try {
                Class<?> aClass = classLoader.loadClass(name);
                return aClass;
            }
            catch (ClassNotFoundException classNotFoundException) {
                GeminiUtil.debugClassLoader("ClassNotFound '", name, "' by ", classLoader.toString());
            }
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    public synchronized void setClassAssertionStatus(String className, boolean enabled) {
        for (ClassLoader classLoader : this.getClassLoaders()) {
            classLoader.setClassAssertionStatus(className, enabled);
        }
    }

    @Override
    public synchronized void setDefaultAssertionStatus(boolean enabled) {
        for (ClassLoader classLoader : this.getClassLoaders()) {
            classLoader.setDefaultAssertionStatus(enabled);
        }
    }

    @Override
    public synchronized void setPackageAssertionStatus(String packageName, boolean enabled) {
        for (ClassLoader classLoader : this.getClassLoaders()) {
            classLoader.setPackageAssertionStatus(packageName, enabled);
        }
    }

    URL newPrivateResourceURL(String resourceName) {
        try {
            return new URL("privateresource", null, -1, resourceName, new PrivateResourceURLHandler(this));
        }
        catch (MalformedURLException muEx) {
            muEx.printStackTrace();
            throw new RuntimeException("MalformedURLException should not happen");
        }
    }

    Enumeration<URL> newPrivateResourceURLEnum(String resourceName) {
        URL url = this.newPrivateResourceURL(resourceName);
        return new UrlEnumeration<URL>(url);
    }

    public class PrivateResourceURLConnection
    extends URLConnection {
        CompositeClassLoader cl;

        public PrivateResourceURLConnection(URL u) {
            super(u);
        }

        public PrivateResourceURLConnection(URL u, CompositeClassLoader cl) {
            this(u);
            this.cl = cl;
        }

        @Override
        public void connect() {
            this.connected = true;
        }

        @Override
        public InputStream getInputStream() {
            return this.cl.getResourceAsStream(this.getURL().getFile());
        }
    }

    public class PrivateResourceURLHandler
    extends URLStreamHandler {
        CompositeClassLoader cl;

        PrivateResourceURLHandler(CompositeClassLoader cl) {
            this.cl = cl;
        }

        @Override
        public URLConnection openConnection(URL u) throws IOException {
            CompositeClassLoader compositeClassLoader = this.cl;
            compositeClassLoader.getClass();
            return compositeClassLoader.new PrivateResourceURLConnection(u, this.cl);
        }

        @Override
        public URLConnection openConnection(URL u, Proxy p) throws IOException {
            return this.openConnection(u);
        }
    }

    public class UrlEnumeration<URL>
    implements Enumeration<URL> {
        URL url;
        boolean atEnd = false;

        public UrlEnumeration(URL url) {
            this.url = url;
        }

        @Override
        public boolean hasMoreElements() {
            return !this.atEnd;
        }

        @Override
        public URL nextElement() {
            if (this.atEnd) {
                throw new NoSuchElementException();
            }
            this.atEnd = true;
            return this.url;
        }
    }
}

