/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.jpa.configadmin;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.eclipse.gemini.jpa.GeminiManager;
import org.eclipse.gemini.jpa.GeminiPersistenceUnitProperties;
import org.eclipse.gemini.jpa.GeminiSystemProperties;
import org.eclipse.gemini.jpa.GeminiUtil;
import org.eclipse.gemini.jpa.PUnitInfo;
import org.eclipse.gemini.jpa.PersistenceBundleExtender;
import org.eclipse.gemini.jpa.classloader.CompositeClassLoader;
import org.eclipse.gemini.jpa.configadmin.PersistenceUnitConfiguration;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;

public class ConfigAdminListener
implements ManagedServiceFactory {
    public static String PUNIT_FACTORY_PID = "gemini.jpa.punit";
    public static String SYNTHESIZED_DESC_NAME_PREFIX = "$$$_Synthesized_PUnit_Desc_";
    GeminiManager mgr;
    ServiceRegistration configListenerService;
    Map<String, PersistenceUnitConfiguration> configsByName;
    Map<String, PersistenceUnitConfiguration> configsByBsn;
    Map<String, PersistenceUnitConfiguration> configsByPid;
    Set<String> inLimbo;
    int descCount = 0;

    public ConfigAdminListener(GeminiManager mgr) {
        this.mgr = mgr;
    }

    public void startListening() {
        GeminiUtil.debug("ConfigAdminListener registering");
        this.configsByName = new HashMap<String, PersistenceUnitConfiguration>();
        this.configsByBsn = new HashMap<String, PersistenceUnitConfiguration>();
        this.configsByPid = new HashMap<String, PersistenceUnitConfiguration>();
        String[] serviceNames = new String[]{ManagedServiceFactory.class.getName()};
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.pid", PUNIT_FACTORY_PID);
        this.configListenerService = this.mgr.getBundleContext().registerService(serviceNames, (Object)this, props);
        GeminiUtil.debug("ConfigAdminListener registered");
    }

    public void stopListening() {
        GeminiUtil.debug("ConfigAdminListener unregistering");
        this.configListenerService.unregister();
        this.configsByName = null;
        this.configsByBsn = null;
        GeminiUtil.debug("ConfigAdminListener unregistered");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updated(String pid, Dictionary dict) throws ConfigurationException {
        GeminiUtil.debug("ConfigAdminListener.updated(), pid: ", (Object)pid);
        if (dict == null) {
            return;
        }
        PersistenceUnitConfiguration config = new PersistenceUnitConfiguration(dict);
        GeminiUtil.debug("ConfigAdminListener created Configuration object: ", (Object)config);
        if (config.getUnitName() == null) {
            GeminiUtil.warning("Configuration ignored because it did not contain persistence unit name property ", GeminiPersistenceUnitProperties.PUNIT_NAME);
            return;
        }
        Map<String, PersistenceUnitConfiguration> map = this.configsByPid;
        synchronized (map) {
            this.configsByPid.put(config.getServicePid(), config);
        }
        if (config.getBsn() != null) {
            map = this.configsByBsn;
            synchronized (map) {
                this.configsByBsn.put(config.getBsn(), config);
            }
            this.generateAndStashPersistenceDescriptor(config);
        } else {
            map = this.configsByName;
            synchronized (map) {
                this.configsByName.put(config.getUnitName(), config);
            }
        }
        this.refreshPersistenceUnitIfNecessary(config, false);
    }

    public void deleted(String pid) {
        GeminiUtil.debug("ConfigAdminListener.deleted()", " pid ", pid);
        PersistenceUnitConfiguration config = this.configsByPid.remove(pid);
        if (config != null) {
            GeminiUtil.debug("ConfigAdminListener.deleted(), ", "pid ", pid, " was found stored, being removed");
            this.configsByName.remove(config.getUnitName());
            this.configsByBsn.remove(config.getBsn());
            this.refreshPersistenceUnitIfNecessary(config, true);
        }
    }

    public String getName() {
        return "Gemini JPA Persistence Unit Configuration";
    }

    public PersistenceUnitConfiguration configForPersistenceUnitName(String unitName) {
        return this.configsByName.get(unitName);
    }

    public PersistenceUnitConfiguration configForBundle(String bsn) {
        return this.configsByBsn.get(bsn);
    }

    protected void generateAndStashPersistenceDescriptor(PersistenceUnitConfiguration config) {
        String descriptorName = String.valueOf(SYNTHESIZED_DESC_NAME_PREFIX) + this.descCount++;
        config.setDescriptorName(descriptorName);
        GeminiUtil.debug("ConfigAdminListener generating desc ", (Object)descriptorName);
        String descriptor = this.generateDescriptorFromConfig(config);
        config.setDescriptor(descriptor);
        CompositeClassLoader.addPrivateResource(descriptorName, descriptor);
    }

    protected String generateDescriptorFromConfig(PersistenceUnitConfiguration config) {
        Map<String, Object> props;
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n").append("<persistence version=\"1.0\" \n").append("  xmlns=\"http://java.sun.com/xml/ns/persistence\" \n").append("  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n").append("  xsi:schemaLocation=\"http://java.sun.com/xml/ns/persistence  ").append("http://java.sun.com/xml/ns/persistence/persistence_1_0.xsd\"> \n").append(" <persistence-unit").append(" name=\"").append(config.getUnitName()).append("\"").append(" transaction-type=\"RESOURCE_LOCAL\"> \n").append("   <provider>").append("org.eclipse.persistence.jpa.PersistenceProvider").append("</provider> \n");
        for (String clsName : config.getClasses()) {
            sb.append("   <class>" + clsName + "</class> \n");
        }
        String exclude = config.getExcludeUnlistedClasses();
        if (exclude != null) {
            sb.append("   <exclude-unlisted-classes>").append((Object)exclude).append("</exclude-unlisted-classes> \n");
        }
        if (!(props = config.getProperties()).isEmpty()) {
            sb.append("   <properties> \n");
            for (String key : props.keySet()) {
                Object value = props.get(key);
                if (value instanceof String) {
                    sb.append("     <property ").append("name=\"" + key + "\" ").append("value=\"" + (String)value + "\"").append("/> \n");
                    continue;
                }
                GeminiUtil.warning("Configuration descriptor generation skipping non-String property ", key);
            }
            sb.append("   </properties> \n");
        }
        sb.append(" </persistence-unit> \n").append("</persistence> \n");
        String result = sb.toString();
        GeminiUtil.debug("ConfigAdminListener finished generating desc: \n", (Object)result);
        return result;
    }

    protected void refreshPersistenceUnitIfNecessary(PersistenceUnitConfiguration config, boolean force) {
        Bundle b;
        boolean needsRefresh = false;
        String unitName = config.getUnitName();
        GeminiUtil.debug("ConfigAdminListener checking if necessary to refresh bundle for punit ", unitName, ", force=", force);
        PUnitInfo unitInfo = this.mgr.getPUnitsByName().get(unitName);
        if (unitInfo != null) {
            GeminiUtil.debug("ConfigAdminListener found punit bundle ", unitName, " in set of registered punits");
            b = unitInfo.getBundle();
            if (force || unitInfo.getEmfService() != null || config.getRefreshBundle()) {
                needsRefresh = true;
            }
            if (needsRefresh) {
                GeminiUtil.debug("ConfigAdminListener unregistering and unassigning bundle ", (Object)b);
                this.mgr.getExtender().unregisterPersistenceUnitsInBundle(b);
                this.mgr.getExtender().unassignPersistenceUnitsInBundle(b);
            } else {
                GeminiUtil.debug("ConfigAdminListener, no refresh needed, registering EMF service for bundle ", (Object)b);
                config.updatePUnitInfo(unitInfo);
                this.mgr.getServicesUtil().tryToRegisterEMFService(unitInfo, new HashMap(), this.mgr.getServicesUtil().buildServiceProperties(unitInfo));
            }
        } else {
            b = this.mgr.getExtender().getBundleInLimbo(config.getBsn());
            if (b != null) {
                GeminiUtil.debug("ConfigAdminListener found punit bundle ", unitName, " in limbo");
                if (GeminiSystemProperties.refreshPersistenceBundles()) {
                    needsRefresh = true;
                } else {
                    GeminiUtil.warning("Bundle " + b.getSymbolicName(), " not being refreshed because refresh is disabled");
                    PersistenceBundleExtender extender = this.mgr.getExtender();
                    extender.tryAssigningPersistenceUnitsInBundle(b);
                    if (b.getState() == 8 || b.getState() == 32) {
                        extender.registerPersistenceUnitsInBundle(b);
                    }
                }
            }
        }
        if (b == null) {
            GeminiUtil.debug("ConfigAdminListener did not find existing bundle to apply config to for punit ", (Object)unitName);
        } else if (needsRefresh) {
            GeminiUtil.debug("ConfigAdminListener refreshing punits in bundle ", (Object)b);
            this.mgr.getExtender().refreshBundle(b);
        }
    }
}

