/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.jpa.configadmin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.gemini.jpa.GeminiPersistenceUnitProperties;
import org.eclipse.gemini.jpa.GeminiUtil;
import org.eclipse.gemini.jpa.PUnitInfo;

public class PersistenceUnitConfiguration {
    String unitName;
    String bsn;
    Collection<String> classes;
    String excludeUnlistedClasses;
    Boolean refreshBundle;
    Map<String, Object> properties;
    String servicePid;
    String descriptorName;
    String descriptor;

    public String getUnitName() {
        return this.unitName;
    }

    protected void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public String getBsn() {
        return this.bsn;
    }

    protected void setBsn(String bsn) {
        this.bsn = bsn;
    }

    public Collection<String> getClasses() {
        return this.classes;
    }

    protected void setClasses(Collection<String> classes) {
        this.classes = classes;
    }

    public String getExcludeUnlistedClasses() {
        return this.excludeUnlistedClasses;
    }

    protected void setExcludeUnlistedClasses(String flag) {
        this.excludeUnlistedClasses = flag;
    }

    public boolean getRefreshBundle() {
        return this.refreshBundle == null ? false : this.refreshBundle;
    }

    protected void setRefreshBundle(boolean flag) {
        this.refreshBundle = flag;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    protected void setProperties(Map<String, Object> props) {
        this.properties = props;
    }

    public String getServicePid() {
        return this.servicePid;
    }

    protected void setServicePid(String servicePid) {
        this.servicePid = servicePid;
    }

    public String getDescriptorName() {
        return this.descriptorName;
    }

    protected void setDescriptorName(String descName) {
        this.descriptorName = descName;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    protected void setDescriptor(String desc) {
        this.descriptor = desc;
    }

    public PersistenceUnitConfiguration(Dictionary config) {
        Object refresh;
        Object exclude;
        this.unitName = (String)config.get(GeminiPersistenceUnitProperties.PUNIT_NAME);
        this.bsn = (String)config.get(GeminiPersistenceUnitProperties.PUNIT_BSN);
        this.servicePid = (String)config.get("service.pid");
        Object clsColl = config.get(GeminiPersistenceUnitProperties.PUNIT_CLASSES);
        if (clsColl != null) {
            if (clsColl instanceof Collection) {
                this.classes = (Collection)clsColl;
            } else if (clsColl instanceof String) {
                List<String> list = Arrays.asList(((String)clsColl).split(","));
                this.classes = new ArrayList<String>();
                for (String s : list) {
                    this.classes.add(s.trim());
                }
            } else {
                GeminiUtil.warning("Configuration property " + GeminiPersistenceUnitProperties.PUNIT_CLASSES, " must be of type Collection<String> or a comma-separated String of class names");
            }
        }
        if ((exclude = config.get(GeminiPersistenceUnitProperties.PUNIT_EXCLUDE_UNLISTED_CLASSES)) != null) {
            if (exclude instanceof Boolean) {
                this.excludeUnlistedClasses = exclude.toString();
            } else if (exclude instanceof String) {
                this.excludeUnlistedClasses = (String)exclude;
            } else {
                GeminiUtil.warning("Configuration property " + GeminiPersistenceUnitProperties.PUNIT_EXCLUDE_UNLISTED_CLASSES, " must be of type String or Boolean");
            }
        }
        if ((refresh = config.get(GeminiPersistenceUnitProperties.PUNIT_REFRESH)) != null) {
            if (refresh instanceof Boolean) {
                this.refreshBundle = (Boolean)refresh;
            } else if (refresh instanceof String) {
                this.refreshBundle = Boolean.parseBoolean((String)refresh);
            } else {
                GeminiUtil.warning("Configuration property " + GeminiPersistenceUnitProperties.PUNIT_REFRESH, " must be of type String or Boolean");
            }
        }
        this.properties = this.pUnitProperties(config);
    }

    public void updatePUnitInfo(PUnitInfo pUnitInfo) {
        String driverVersion;
        String driverPassword;
        String driverUser;
        String driverUrl;
        assert (this.getUnitName() == pUnitInfo.getUnitName());
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.putAll(this.getProperties());
        String driverClassName = (String)props.remove(GeminiUtil.JPA_JDBC_DRIVER_PROPERTY);
        if (driverClassName != null) {
            pUnitInfo.setDriverClassName(driverClassName);
        }
        if ((driverUrl = (String)props.remove(GeminiUtil.JPA_JDBC_URL_PROPERTY)) != null) {
            pUnitInfo.setDriverUrl(driverUrl);
        }
        if ((driverUser = (String)props.remove(GeminiUtil.JPA_JDBC_USER_PROPERTY)) != null) {
            pUnitInfo.setDriverUser(driverUser);
        }
        if ((driverPassword = (String)props.remove(GeminiUtil.JPA_JDBC_PASSWORD_PROPERTY)) != null) {
            pUnitInfo.setDriverPassword(driverPassword);
        }
        if ((driverVersion = (String)props.remove(GeminiUtil.OSGI_JDBC_DRIVER_VERSION_PROPERTY)) != null) {
            pUnitInfo.setDriverVersion(driverVersion);
        }
        if (!this.getProperties().isEmpty()) {
            pUnitInfo.setConfigProperties(props);
        }
    }

    public Map<String, Object> pUnitProperties(Dictionary dict) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        Enumeration keysEnum = dict.keys();
        while (keysEnum.hasMoreElements()) {
            String key = (String)keysEnum.nextElement();
            props.put(key, dict.get(key));
        }
        props.remove(GeminiPersistenceUnitProperties.PUNIT_NAME);
        props.remove(GeminiPersistenceUnitProperties.PUNIT_BSN);
        props.remove(GeminiPersistenceUnitProperties.PUNIT_CLASSES);
        props.remove(GeminiPersistenceUnitProperties.PUNIT_EXCLUDE_UNLISTED_CLASSES);
        props.remove(GeminiPersistenceUnitProperties.PUNIT_REFRESH);
        props.remove(GeminiUtil.JPA_PROVIDER_PROPERTY);
        props.remove("service.pid");
        props.remove("service.factoryPid");
        props.remove("service.bundleLocation");
        return props;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PUnitConfig[servicePid=").append(this.servicePid).append(", unitName=" + this.unitName).append(this.bsn != null ? ", bsn=" + this.bsn : "").append(this.excludeUnlistedClasses != null ? ", excludeUnlistedClasses=" + this.excludeUnlistedClasses : "").append(this.refreshBundle != null ? ", refresh=" + this.refreshBundle : "");
        if (this.classes != null) {
            sb.append(", classes={");
            for (String cls : this.classes) {
                sb.append(" ").append(cls);
            }
            sb.append(" }");
        }
        sb.append(", props=").append(this.properties).append("]");
        return sb.toString();
    }
}

