/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.jpa.datasource;

import java.sql.Driver;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.eclipse.gemini.jpa.GeminiManager;
import org.eclipse.gemini.jpa.GeminiPersistenceUnitProperties;
import org.eclipse.gemini.jpa.GeminiUtil;
import org.eclipse.gemini.jpa.PUnitInfo;
import org.eclipse.gemini.jpa.datasource.DSFOfflineTracker;
import org.eclipse.gemini.jpa.datasource.DSFOnlineTracker;
import org.eclipse.gemini.jpa.datasource.PlainDriverDataSource;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.jdbc.DataSourceFactory;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class DataSourceUtil {
    GeminiManager mgr;

    public DataSourceUtil(GeminiManager mgr) {
        this.mgr = mgr;
    }

    public DataSource acquireDataSource(PUnitInfo pUnitInfo, Map<?, ?> properties) {
        ServiceReference dsfRef;
        GeminiUtil.debug("DataSourceUtil.acquireDataSource - for punit ", (Object)pUnitInfo.getUnitName());
        DataSource ds = this.checkForNonJtaDataSource(pUnitInfo, properties);
        if (ds != null) {
            return ds;
        }
        if (properties.containsKey(GeminiPersistenceUnitProperties.PROVIDER_CONNECTED_DATA_SOURCE)) {
            return null;
        }
        Driver driver = null;
        String driverName = (String)properties.get(GeminiUtil.JPA_JDBC_DRIVER_PROPERTY);
        String driverVersion = (String)properties.get(GeminiUtil.OSGI_JDBC_DRIVER_VERSION_PROPERTY);
        if (driverName == null) {
            driverName = pUnitInfo.getDriverClassName();
            if (driverName == null) {
                GeminiUtil.fatalError("No driver was specified", null);
            } else if (driverVersion == null) {
                driverVersion = pUnitInfo.getDriverVersion();
            }
        }
        if ((dsfRef = pUnitInfo.getDsfService()) != null && this.specifiesSameDriver(driverName, driverVersion, pUnitInfo)) {
            GeminiUtil.debug("DataSourceUtil - Using existing DSF service ref from punit ", (Object)pUnitInfo.getUnitName());
            DataSourceFactory dsf = (DataSourceFactory)this.mgr.getBundleContext().getService(dsfRef);
            try {
                driver = dsf.createDriver(null);
            }
            catch (SQLException sqlEx) {
                GeminiUtil.fatalError("Could not create data source for " + driverName, sqlEx);
            }
        }
        if (driver == null) {
            GeminiUtil.debug("Trying dynamic lookup of DSF for ", driverName, " for p-unit ", pUnitInfo.getUnitName());
            String filter = this.filterForDSFLookup(driverName, driverVersion);
            ServiceReference[] dsfRefs = this.lookupDSF(pUnitInfo.getBundle().getBundleContext(), filter);
            if (dsfRefs != null) {
                GeminiUtil.debug("DataSourceUtil - Found DSF, props: ", GeminiUtil.serviceProperties(dsfRefs[0]));
                DataSourceFactory dsf = (DataSourceFactory)this.mgr.getBundleContext().getService(dsfRefs[0]);
                try {
                    driver = dsf.createDriver(null);
                }
                catch (SQLException sqlEx) {
                    GeminiUtil.fatalError("Could not create data source for " + driverName, sqlEx);
                }
            }
        }
        if (driver == null) {
            GeminiUtil.debug("DataSourceUtil - Trying to load driver ", driverName, " locally from p-unit bundle ", pUnitInfo.getUnitName());
            try {
                Class driverClass = pUnitInfo.getBundle().loadClass(driverName);
                driver = (Driver)driverClass.newInstance();
                GeminiUtil.debug("DataSourceUtil - JDBC driver ", driverName, " loaded locally from p-unit bundle ", pUnitInfo.getUnitName());
            }
            catch (Exception ex) {
                GeminiUtil.fatalError("Could not create data source for " + driverName, ex);
            }
        }
        Properties props = this.getJdbcProperties(pUnitInfo, properties);
        return new PlainDriverDataSource(driver, props);
    }

    protected DataSource checkForNonJtaDataSource(PUnitInfo pUnitInfo, Map<?, ?> props) {
        String nonJtaDS;
        Object dsValue = props.get("javax.persistence.nonJtaDataSource");
        if (dsValue instanceof DataSource) {
            GeminiUtil.debug("DataSourceUtil.checkForNonJtaDataSource - using data source passed in as property");
            return (DataSource)dsValue;
        }
        if (pUnitInfo.getJndiDataSource() != null) {
            GeminiUtil.debug("DataSourceUtil.checkForNonJtaDataSource - using pre-looked up JNDI data source");
            return pUnitInfo.getJndiDataSource();
        }
        String string = nonJtaDS = dsValue instanceof String ? (String)dsValue : pUnitInfo.getNonJtaDataSource();
        if (nonJtaDS != null) {
            GeminiUtil.debug("DataSourceUtil.checkForNonJtaDataSource - looking up data source ", nonJtaDS, " in JNDI");
            DataSource jndiDS = this.mgr.getJndiUtil().lookupDataSource(nonJtaDS);
            pUnitInfo.setJndiDataSource(jndiDS);
            return jndiDS;
        }
        GeminiUtil.debug("DataSourceUtil.checkForNonJtaDataSource - no data source");
        return null;
    }

    protected boolean specifiesSameDriver(String driverName, String driverVersion, PUnitInfo unitInfo) {
        String infoDriverName = unitInfo.getDriverClassName();
        String infoDriverVersion = unitInfo.getDriverVersion();
        return driverName.equals(infoDriverName) && (driverVersion == null || infoDriverVersion == null || driverVersion.equals(infoDriverVersion));
    }

    public Properties getJdbcProperties(PUnitInfo pUnitInfo, Map<?, ?> properties) {
        String pw;
        String user;
        Properties props = new Properties();
        GeminiUtil.debug("DataSourceUtil.getJDBCProperties");
        GeminiUtil.debug("  fromMap: ", properties);
        GeminiUtil.debug("  fromDescriptor: ", (Object)pUnitInfo);
        String url = (String)properties.get(GeminiUtil.JPA_JDBC_URL_PROPERTY);
        if (url == null) {
            url = pUnitInfo.getDriverUrl();
        }
        if (url != null) {
            props.put("url", url);
        }
        if ((user = (String)properties.get(GeminiUtil.JPA_JDBC_USER_PROPERTY)) == null) {
            user = pUnitInfo.getDriverUser();
        }
        if (user != null) {
            props.put("user", user);
        }
        if ((pw = (String)properties.get(GeminiUtil.JPA_JDBC_PASSWORD_PROPERTY)) == null) {
            pw = pUnitInfo.getDriverPassword();
        }
        if (pw != null) {
            props.put("password", pw);
        }
        GeminiUtil.debug("DataSourceUtil.getJDBCProperties - returning: ", (Object)props);
        return props;
    }

    public boolean trackDataSourceFactory(PUnitInfo pUnitInfo) {
        GeminiUtil.debug("ServicesUtil trackDataSourceFactory for p-unit ", (Object)pUnitInfo.getUnitName());
        ServiceReference[] dsfRefs = null;
        ServiceTracker tracker = null;
        try {
            String filter = this.filterForDSFLookup(pUnitInfo.getDriverClassName(), pUnitInfo.getDriverVersion());
            dsfRefs = this.lookupDSF(pUnitInfo.getBundle().getBundleContext(), filter);
            if (dsfRefs != null) {
                ServiceReference dsfRef = dsfRefs[0];
                GeminiUtil.debug("ServicesUtil starting tracker on existing DSF for ", (Object)pUnitInfo.getUnitName());
                tracker = new ServiceTracker(this.mgr.getBundleContext(), dsfRef, (ServiceTrackerCustomizer)new DSFOfflineTracker(pUnitInfo, this));
                pUnitInfo.setDsfService(dsfRef);
                GeminiUtil.debug("DSF service props: ", GeminiUtil.serviceProperties(dsfRef));
            } else {
                GeminiUtil.debug("ServicesUtil starting tracker to wait for DSF for ", (Object)pUnitInfo.getUnitName());
                tracker = new ServiceTracker(this.mgr.getBundleContext(), this.mgr.getBundleContext().createFilter(filter), (ServiceTrackerCustomizer)new DSFOnlineTracker(pUnitInfo, this));
            }
        }
        catch (Exception ex) {
            GeminiUtil.fatalError("Unexpected failure creating DSF service tracker", ex);
        }
        pUnitInfo.setDsfTracker(tracker);
        tracker.open();
        return dsfRefs != null;
    }

    public void stopTrackingDataSourceFactory(PUnitInfo pUnitInfo) {
        GeminiUtil.debug("ServicesUtil stopTrackingDataSourceFactory", " for p-unit ", pUnitInfo.getUnitName());
        if (pUnitInfo.getDsfTracker() != null) {
            GeminiUtil.debug("ServicesUtil stopping tracker for p-unit ", (Object)pUnitInfo.getUnitName());
            pUnitInfo.getDsfTracker().close();
            pUnitInfo.setDsfTracker(null);
        }
    }

    public void dataSourceFactoryOnline(PUnitInfo pUnitInfo, ServiceReference ref) {
        GeminiUtil.debug("dataSourceFactoryOnline, ref=", ref, " for p-unit ", pUnitInfo.getUnitName());
        if (pUnitInfo.getEmf() != null) {
            GeminiUtil.warning("DSF " + ref + " came online when EMF for p-unit " + pUnitInfo.getUnitName() + " already existed - ignoring DSF");
        } else if (pUnitInfo.getDsfService() != null) {
            GeminiUtil.warning("DSF service already exists for p-unit " + pUnitInfo.getUnitName() + " - ignoring new DSF service");
        } else {
            GeminiUtil.debug("dataSourceFactoryOnline, unregistering and reregistering EMF services for p-unit ", (Object)pUnitInfo.getUnitName());
            this.mgr.getServicesUtil().unregisterEMFServices(pUnitInfo);
            this.mgr.getServicesUtil().registerEMFServices(pUnitInfo);
        }
    }

    public void dataSourceFactoryOffline(PUnitInfo pUnitInfo, ServiceReference removedRef) {
        ServiceReference dsServiceRef = pUnitInfo.getDsfService();
        GeminiUtil.debug("dataSourceFactoryOffline, p-unit=", pUnitInfo.getUnitName(), "removedRef=", removedRef, "storedRef=", dsServiceRef);
        if (dsServiceRef == null) {
            GeminiUtil.warning("DataSourceFactory " + removedRef + " went offline but no record of it was stored in p-unit " + pUnitInfo.getUnitName());
        } else if (dsServiceRef.compareTo((Object)removedRef) != 0) {
            GeminiUtil.warning("DataSourceFactory " + removedRef + " went offline but a different DSF was stored in p-unit " + pUnitInfo.getUnitName());
        }
        GeminiUtil.debug("dataSourceFactoryOffline - unregistering EMF service ", "for p-unit ", pUnitInfo.getUnitName());
        pUnitInfo.setDsfService(null);
        this.mgr.getServicesUtil().unregisterEMFService(pUnitInfo);
    }

    public String filterForDSFLookup(String driverName, String driverVersion) {
        String driverNameFilter = "(osgi.jdbc.driver.class=" + driverName + ")";
        if (driverVersion == null) {
            return driverNameFilter;
        }
        String driverVersionFilter = "(osgi.jdbc.driver.version=" + driverVersion + ")";
        return "(&" + driverNameFilter + driverVersionFilter + ")";
    }

    public ServiceReference[] lookupDSF(BundleContext ctx, String filter) {
        try {
            return ctx.getServiceReferences(DataSourceFactory.class.getName(), filter);
        }
        catch (InvalidSyntaxException isEx) {
            GeminiUtil.fatalError("Bad filter syntax (likely because of missing driver class name)", isEx);
            return null;
        }
    }
}

