/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.jpa.datasource;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class PlainDriverDataSource
implements DataSource {
    Driver driver = null;
    Properties properties = null;
    String url = null;

    public PlainDriverDataSource(Driver driver, Properties properties) {
        this.driver = driver;
        this.properties = (Properties)properties.clone();
        this.url = properties.getProperty("url");
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.url == null) {
            this.missingUrlException();
        }
        return this.driver.connect(this.url, this.properties);
    }

    @Override
    public Connection getConnection(String user, String password) throws SQLException {
        if (this.url == null) {
            this.missingUrlException();
        }
        Properties localProps = (Properties)this.properties.clone();
        localProps.put("user", user);
        localProps.put("password", password);
        return this.driver.connect(this.url, localProps);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isWrapperFor(Class<?> cls) throws SQLException {
        try {
            Class<?>[] interfaces;
            if (this.driver.getClass().isAssignableFrom(cls)) {
                return true;
            }
            Class<?>[] classArray = interfaces = this.driver.getClass().getInterfaces();
            int n = interfaces.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                Class<?> i = classArray[n2];
                if (i == cls) {
                    return true;
                }
                ++n2;
            }
        }
        catch (Exception ex) {
            throw new SQLException("Error checking for wrapper", ex);
        }
    }

    @Override
    public <T> T unwrap(Class<T> cls) throws SQLException {
        try {
            return cls.cast(this.driver);
        }
        catch (ClassCastException ccEx) {
            throw new SQLException("Error casting driver class", ccEx);
        }
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return DriverManager.getLogWriter();
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return DriverManager.getLoginTimeout();
    }

    @Override
    public void setLogWriter(PrintWriter writer) throws SQLException {
        throw new SQLException("Can't set Log Writer on URL data source");
    }

    @Override
    public void setLoginTimeout(int timeout) throws SQLException {
        throw new SQLException("Can't set Login Timeout on URL data source");
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    void missingUrlException() throws SQLException {
        throw new SQLException("URL was not specified");
    }
}

