/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.jpa.eclipselink;

import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Map;
import org.eclipse.gemini.jpa.GeminiManager;
import org.eclipse.gemini.jpa.PUnitInfo;
import org.eclipse.gemini.jpa.eclipselink.GeminiOSGiInitializer;
import org.eclipse.gemini.jpa.eclipselink.OSGiArchiveFactoryImpl;
import org.eclipse.persistence.internal.jpa.deployment.JPAInitializer;
import org.eclipse.persistence.internal.jpa.deployment.PersistenceUnitProcessor;
import org.eclipse.persistence.jpa.ArchiveFactory;
import org.eclipse.persistence.jpa.PersistenceProvider;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.logging.DefaultSessionLog;
import org.eclipse.persistence.logging.SessionLog;

public class EclipseLinkProvider
extends PersistenceProvider {
    public static final String ECLIPSELINK_PROVIDER_CLASS_NAME = "org.eclipse.persistence.jpa.PersistenceProvider";
    GeminiManager mgr;
    private FileWriter eclipseLinkLog;

    public EclipseLinkProvider(GeminiManager mgr) {
        this.mgr = mgr;
    }

    public void initialize() {
        GeminiOSGiInitializer.setManager(this.mgr);
        PersistenceUnitProcessor.setArchiveFactory((ArchiveFactory)new OSGiArchiveFactoryImpl());
        this.openEclipseLinkLogFileIfSpecified();
    }

    public void shutdown() {
        this.closeEclipseLinkLogFileIfNecessary();
    }

    public void initializeForWeaving(ClassLoader cl, Collection<PUnitInfo> pUnits) {
        GeminiOSGiInitializer initializer = new GeminiOSGiInitializer();
        initializer.initializeFromBundle(cl, pUnits);
    }

    protected void openEclipseLinkLogFileIfSpecified() {
        String loggingFile = System.getProperty("eclipselink.logging.file");
        try {
            if (loggingFile != null) {
                this.eclipseLinkLog = new FileWriter(loggingFile);
                AbstractSessionLog.getLog().setWriter((Writer)this.eclipseLinkLog);
            }
        }
        catch (IOException e) {
            AbstractSessionLog.getLog().log(6, "cmp_init_default_logging_file_is_invalid", loggingFile, (Object)e);
        }
    }

    protected void closeEclipseLinkLogFileIfNecessary() {
        AbstractSessionLog.setLog((SessionLog)new DefaultSessionLog());
        try {
            if (this.eclipseLinkLog != null) {
                this.eclipseLinkLog.close();
            }
        }
        catch (IOException iOException) {}
    }

    public JPAInitializer getInitializer(String emName, Map m) {
        ClassLoader classLoader = this.getClassLoader(emName, m);
        return new GeminiOSGiInitializer(classLoader);
    }

    public static boolean containsSessionName(Map<?, ?> props) {
        return props.containsKey("eclipselink.session-name");
    }
}

