/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.jpa.jndi;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.sql.DataSource;
import org.eclipse.gemini.jpa.GeminiManager;
import org.eclipse.gemini.jpa.GeminiUtil;

public class JndiUtil {
    GeminiManager mgr;

    public JndiUtil(GeminiManager mgr) {
        this.mgr = mgr;
    }

    public DataSource lookupDataSource(String nameString) {
        Object result = null;
        try {
            GeminiUtil.debug("JndiUtil.lookupDataSource - looking up ", (Object)nameString);
            InitialContext ctx = new InitialContext();
            result = ctx.lookup(nameString);
            if (result instanceof DataSource) {
                GeminiUtil.debug("JndiUtil.lookupDataSource - Found data source ", result);
                return (DataSource)result;
            }
            if (result instanceof Context) {
                throw new RuntimeException("osgi:servicelist/ data source lookup format not supported");
            }
            throw new RuntimeException("Unexpected object binding in JNDI: " + result.toString());
        }
        catch (NameNotFoundException nameNotFoundException) {
            GeminiUtil.debug("JndiUtil.lookupDataSource - Name not found for ", (Object)nameString);
            return null;
        }
        catch (Throwable t) {
            GeminiUtil.fatalError("Lookup for " + nameString + " failed: ", t);
            return null;
        }
    }
}

