/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.jpa.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import org.eclipse.gemini.jpa.GeminiUtil;
import org.eclipse.gemini.jpa.PUnitInfo;
import org.eclipse.gemini.jpa.ProviderWrapper;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;

public class EMFServiceProxyHandler
implements InvocationHandler,
ServiceFactory {
    PUnitInfo pUnitInfo;

    public EMFServiceProxyHandler(PUnitInfo pUnitInfo) {
        this.pUnitInfo = pUnitInfo;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        HashMap<String, Map<String, Object>> result = null;
        try {
            GeminiUtil.debug("EMFProxy invocation on method ", (Object)method.getName());
            if (method.getName().equals("hashCode")) {
                return this.hashCode();
            }
            if (method.getName().equals("toString")) {
                return this.toString();
            }
            EntityManagerFactory emf = this.syncGetEMFAndSetIfAbsent(false, new HashMap<String, Object>());
            result = method.invoke((Object)emf, args);
            if (method.getName().equals("getProperties")) {
                HashMap<String, Map<String, Object>> resultMap = new HashMap<String, Map<String, Object>>();
                resultMap.putAll((Map)result);
                resultMap.put("PUnitInfo", this.pUnitInfo.toMap());
                result = resultMap;
            }
            if (!emf.isOpen()) {
                this.syncUnsetEMF();
            }
        }
        catch (InvocationTargetException itEx) {
            GeminiUtil.warning("EMFProxy invocation on target method " + method.getName() + " failed with cause: ", itEx.getCause());
            throw itEx.getCause();
        }
        catch (Throwable t) {
            GeminiUtil.warning("EMFProxy invocation on method " + method.getName() + " failed: ", t);
            throw t;
        }
        return result;
    }

    public Object getService(Bundle b, ServiceRegistration serviceReg) {
        return this;
    }

    public void ungetService(Bundle b, ServiceRegistration serviceReg, Object obj) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityManagerFactory syncGetEMFAndSetIfAbsent(boolean setByBuilderService, Map<String, Object> props) {
        GeminiUtil.debug("EMFProxy - getEMF for punit ", this.pUnitInfo.getUnitName(), " emf=", this.pUnitInfo.getEmf());
        if (this.pUnitInfo.getEmf() == null) {
            PUnitInfo pUnitInfo = this.pUnitInfo;
            synchronized (pUnitInfo) {
                if (this.pUnitInfo.getEmf() == null) {
                    this.pUnitInfo.setEmf(this.createEMF(props));
                    this.pUnitInfo.setEmfSetByBuilderService(setByBuilderService);
                }
            }
        }
        return this.pUnitInfo.getEmf();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityManagerFactory syncUnsetEMF() {
        GeminiUtil.debug("EMFProxy - unsetting EMF for punit ", this.pUnitInfo.getUnitName(), " emf=", this.pUnitInfo.getEmf());
        PUnitInfo pUnitInfo = this.pUnitInfo;
        synchronized (pUnitInfo) {
            EntityManagerFactory emf = this.pUnitInfo.getEmf();
            this.pUnitInfo.setEmf(null);
            return emf;
        }
    }

    public EntityManagerFactory createEMF(Map<String, Object> props) {
        String unitName = this.pUnitInfo.getUnitName();
        GeminiUtil.debug("EMFProxy creating new EMF for ", (Object)unitName);
        ProviderWrapper provider = this.pUnitInfo.getAssignedProvider();
        EntityManagerFactory result = provider.createEntityManagerFactory(unitName, props);
        if (result == null) {
            GeminiUtil.fatalError("Proxy could not create EMF " + unitName + " from provider " + provider, null);
        }
        return result;
    }
}

