/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.jpa.xml;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.gemini.jpa.GeminiUtil;
import org.eclipse.gemini.jpa.PUnitInfo;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PersistenceDescriptorHandler
extends DefaultHandler {
    String currentElement;
    PUnitInfo currentPUnit;
    Set<PUnitInfo> pUnits = new HashSet<PUnitInfo>();

    public Set<PUnitInfo> getPersistenceUnitInfo() {
        return this.pUnits;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        GeminiUtil.debugXml("<<< startElement localName: ", localName, " qName: ", qName);
        this.currentElement = localName;
        if (this.nullOrEmpty(this.currentElement)) {
            if (this.nullOrEmpty(qName)) {
                GeminiUtil.fatalError("No element returned", null);
            }
            String[] comps = qName.split(":");
            this.currentElement = comps[comps.length - 1];
        }
        GeminiUtil.debugXml("currentElement: ", this.currentElement);
        if (this.currentElement.equals("persistence-unit")) {
            String unitName = attributes.getValue("name");
            GeminiUtil.debugXml("unit name: ", unitName);
            if (this.nullOrEmpty(unitName)) {
                GeminiUtil.fatalError("No unit name found", null);
            }
            this.currentPUnit = new PUnitInfo();
            this.currentPUnit.setUnitName(unitName);
            this.pUnits.add(this.currentPUnit);
        } else if (this.currentElement.equals("property")) {
            String propName = attributes.getValue("name");
            GeminiUtil.debugXml("prop name: ", propName);
            if (this.nullOrEmpty(propName)) {
                GeminiUtil.fatalError("Invalid 'name' for persistence descriptor <property>", null);
            }
            String propValue = attributes.getValue("value");
            GeminiUtil.debugXml("prop value: ", propValue);
            if (propValue == null) {
                propValue = "";
            }
            if (propName.equals(GeminiUtil.JPA_JDBC_DRIVER_PROPERTY)) {
                this.currentPUnit.setDriverClassName(propValue);
            } else if (propName.equals(GeminiUtil.JPA_JDBC_URL_PROPERTY)) {
                this.currentPUnit.setDriverUrl(propValue);
            } else if (propName.equals(GeminiUtil.JPA_JDBC_USER_PROPERTY)) {
                this.currentPUnit.setDriverUser(propValue);
            } else if (propName.equals(GeminiUtil.JPA_JDBC_PASSWORD_PROPERTY)) {
                this.currentPUnit.setDriverPassword(propValue);
            } else if (propName.equals(GeminiUtil.OSGI_JDBC_DRIVER_VERSION_PROPERTY)) {
                this.currentPUnit.setDriverVersion(propValue);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.currentElement = null;
        GeminiUtil.debugXml(">>> EndElement,  localName: ", localName, "  qName: ", qName);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.currentElement == null) {
            return;
        }
        if (this.currentElement.equals("provider")) {
            this.currentPUnit.setProvider(this.contentFromChars(ch, start, length));
            GeminiUtil.debugXml("provider: ", this.currentPUnit.getProvider());
        } else if (this.currentElement.equals("non-jta-data-source")) {
            this.currentPUnit.setNonJtaDataSource(this.contentFromChars(ch, start, length));
            GeminiUtil.debugXml("nonJtaDataSource: ", this.currentPUnit.getNonJtaDataSource());
        } else if (this.currentElement.equals("jta-data-source")) {
            this.currentPUnit.setJtaDataSource(this.contentFromChars(ch, start, length));
            GeminiUtil.debugXml("jtaDataSource: ", this.currentPUnit.getJtaDataSource());
        } else if (this.currentElement.equals("class")) {
            String classString = this.contentFromChars(ch, start, length);
            this.currentPUnit.addClass(classString);
            GeminiUtil.debugXml("class: ", classString);
        }
    }

    protected boolean nullOrEmpty(String s) {
        return s == null || s.length() == 0;
    }

    protected String contentFromChars(char[] chars, int start, int length) {
        StringBuilder s = new StringBuilder(length);
        int idx = start;
        while (idx < start + length) {
            s.append(chars[idx]);
            ++idx;
        }
        return s.toString().trim();
    }
}

