/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.harmony.source.hg4j;

import fr.labri.harmony.core.config.model.SourceConfiguration;
import fr.labri.harmony.core.dao.Dao;
import fr.labri.harmony.core.log.HarmonyLogger;
import fr.labri.harmony.core.model.Action;
import fr.labri.harmony.core.model.ActionKind;
import fr.labri.harmony.core.model.Author;
import fr.labri.harmony.core.model.Event;
import fr.labri.harmony.core.model.Item;
import fr.labri.harmony.core.source.AbstractSourceExtractor;
import fr.labri.harmony.core.source.SourceExtractor;
import fr.labri.harmony.core.source.SourceExtractorException;
import fr.labri.harmony.source.hg4j.Hg4JWorkspace;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.tmatesoft.hg.core.HgChangeset;
import org.tmatesoft.hg.core.HgFileRevision;
import org.tmatesoft.hg.util.Path;

public class Hg4JSourceExtractor
extends AbstractSourceExtractor<Hg4JWorkspace> {
    private static final long MILLI_2_SECONDS = 1000L;
    private Map<String, HgChangeset> changeSets = new HashMap<String, HgChangeset>();

    public Hg4JSourceExtractor() {
    }

    public Hg4JSourceExtractor(SourceConfiguration config, Dao dao, Properties properties) {
        super(config, dao, properties);
    }

    public void initializeWorkspace() {
        this.workspace = new Hg4JWorkspace((SourceExtractor<?>)this);
        ((Hg4JWorkspace)this.workspace).init();
    }

    public void extractEvents() {
        try {
            List result = ((Hg4JWorkspace)this.workspace).getRepoFacade().createLogCommand().execute();
            for (HgChangeset chgSet : result) {
                Author author;
                String revId = chgSet.getNodeid().toString();
                this.changeSets.put(revId, chgSet);
                long time = chgSet.getDate().getRawTime() / 1000L;
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy");
                if (formatter.format(new Date(time)).equals("1970")) {
                    time *= 1000L;
                }
                HashSet<Event> parents = new HashSet<Event>();
                if (!chgSet.getFirstParentRevision().isNull()) {
                    parents.add(this.getEvent(chgSet.getFirstParentRevision().toString()));
                }
                if (!chgSet.getSecondParentRevision().isNull()) {
                    parents.add(this.getEvent(chgSet.getSecondParentRevision().toString()));
                }
                String user = chgSet.getUser();
                String mail = "";
                if (user.contains("<") && user.contains(">")) {
                    String base = user;
                    user = user.substring(0, user.indexOf("<")).trim();
                    mail = base.substring(base.indexOf("<") + 1, base.indexOf(">")).trim();
                }
                if ((author = this.getAuthor(user)) == null) {
                    author = new Author(this.source, user, user);
                    author.setEmail(mail);
                    this.saveAuthor(author);
                }
                ArrayList<Author> authors = new ArrayList<Author>(Arrays.asList(author));
                Event e = new Event(this.source, revId, time, parents, authors);
                HashMap<String, String> metadata = new HashMap<String, String>();
                metadata.put("commit_message", chgSet.getComment());
                metadata.put("branch", chgSet.getBranch());
                e.setMetadata(metadata);
                this.saveEvent(e);
            }
        }
        catch (Exception e) {
            throw new SourceExtractorException(e);
        }
    }

    public void extractActions(Event e) {
        try {
            Action a;
            Item i;
            Event parent = null;
            if (!e.getParents().isEmpty()) {
                parent = (Event)e.getParents().get(0);
            }
            HgChangeset currentChgSet = this.changeSets.get(e.getNativeId());
            for (HgFileRevision fileRev : currentChgSet.getAddedFiles()) {
                i = this.getItem(fileRev.getPath().toString());
                if (i == null) {
                    i = new Item(this.source, fileRev.getPath().toString());
                    this.saveItem(i);
                }
                a = new Action(i, ActionKind.Create, e, parent, this.source);
                this.saveAction(a);
            }
            for (HgFileRevision fileRev : currentChgSet.getModifiedFiles()) {
                i = this.getItem(fileRev.getPath().toString());
                if (i == null) {
                    i = new Item(this.source, fileRev.getPath().toString());
                    this.saveItem(i);
                }
                a = new Action(i, ActionKind.Edit, e, parent, this.source);
                this.saveAction(a);
            }
            for (Path path : currentChgSet.getRemovedFiles()) {
                i = this.getItem(path.toString());
                if (i == null) {
                    i = new Item(this.source, path.toString());
                    this.saveItem(i);
                }
                a = new Action(i, ActionKind.Delete, e, parent, this.source);
                this.saveAction(a);
            }
        }
        catch (Exception ex) {
            HarmonyLogger.error((String)ex.getMessage());
        }
    }
}

