/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.harmony.source.hg4j;

import fr.labri.harmony.core.model.Event;
import fr.labri.harmony.core.model.Item;
import fr.labri.harmony.core.source.AbstractLocalWorkspace;
import fr.labri.harmony.core.source.SourceExtractor;
import fr.labri.harmony.core.source.WorkspaceException;
import java.io.File;
import java.net.URL;
import org.tmatesoft.hg.core.HgCheckoutCommand;
import org.tmatesoft.hg.core.HgCloneCommand;
import org.tmatesoft.hg.core.HgException;
import org.tmatesoft.hg.core.HgRepoFacade;
import org.tmatesoft.hg.core.HgRepositoryNotFoundException;
import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.repo.HgLookup;
import org.tmatesoft.hg.repo.HgRemoteRepository;
import org.tmatesoft.hg.util.CancelledException;

public class Hg4JWorkspace
extends AbstractLocalWorkspace {
    private HgRepoFacade repoFacade = new HgRepoFacade();
    private Event lastEvent;

    public Hg4JWorkspace(SourceExtractor<?> sourceExtractor) {
        super(sourceExtractor);
    }

    public HgRepoFacade getRepoFacade() {
        return this.repoFacade;
    }

    public void update(Event e) throws WorkspaceException {
        try {
            Nodeid node = Nodeid.fromAscii((String)e.getNativeId());
            new HgCheckoutCommand(this.repoFacade.getRepository()).clean(true).changeset(node).execute();
            this.lastEvent = e;
        }
        catch (NumberFormatException | HgException | CancelledException e1) {
            e1.printStackTrace();
        }
    }

    public void update(Event e, Item i) throws WorkspaceException {
        if (this.lastEvent == null || this.lastEvent != e) {
            this.update(e);
        }
    }

    public boolean isInitialized() {
        HgRepoFacade hgTestRepo = new HgRepoFacade();
        try {
            hgTestRepo.initFrom(new File(this.getPath()));
        }
        catch (HgRepositoryNotFoundException hgRepositoryNotFoundException) {
            return false;
        }
        return true;
    }

    public void initNewWorkspace() {
        try {
            HgRemoteRepository hgRemote = new HgLookup().detect(new URL(this.getUrl()));
            HgCloneCommand cmd = new HgCloneCommand();
            cmd.source(hgRemote);
            cmd.destination(new File(this.getPath()));
            cmd.execute();
            this.repoFacade.initFrom(new File(this.getPath()));
        }
        catch (HgRepositoryNotFoundException hgRepositoryNotFoundException) {
            throw new WorkspaceException("Harmony was not able to connect to newly cloned mercurial repository named: " + this.getUrl());
        }
        catch (Exception e) {
            throw new WorkspaceException(e);
        }
    }

    public void initExistingWorkspace() {
        try {
            this.repoFacade.initFrom(new File(this.getPath()));
        }
        catch (HgRepositoryNotFoundException hgRepositoryNotFoundException) {
            throw new WorkspaceException("Harmony was not able to connect to the local copy of the mercurial repository named: " + this.getUrl());
        }
    }
}

