/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.harmony.analysis.cloc.chart;

import fr.labri.harmony.analysis.cloc.ClocEntries;
import fr.labri.harmony.analysis.cloc.ClocEntry;
import fr.labri.harmony.core.analysis.AbstractAnalysis;
import fr.labri.harmony.core.config.model.AnalysisConfiguration;
import fr.labri.harmony.core.dao.Dao;
import fr.labri.harmony.core.model.Event;
import fr.labri.harmony.core.model.HarmonyModelElement;
import fr.labri.harmony.core.model.Source;
import fr.labri.harmony.core.output.OutputUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ClocChartAnalysis
extends AbstractAnalysis {
    public ClocChartAnalysis() {
    }

    public ClocChartAnalysis(AnalysisConfiguration config, Dao dao, Properties properties) {
        super(config, dao, properties);
    }

    public void runOn(Source src) {
        List events = this.dao.getEvents(src);
        LinkedHashSet<String> availableLanguages = new LinkedHashSet<String>();
        LinkedHashMap clocData = new LinkedHashMap();
        for (Event event : events) {
            List list = this.dao.getData("cloc", ClocEntries.class, (HarmonyModelElement)event);
            HashMap<String, Integer> eventClocValues = new HashMap<String, Integer>();
            for (ClocEntries c : list) {
                for (ClocEntry clocEntry : c.getEntries()) {
                    availableLanguages.add(clocEntry.getLanguage());
                    eventClocValues.put(clocEntry.getLanguage(), clocEntry.getCode());
                }
            }
            clocData.put(event.getTimestamp(), eventClocValues);
        }
        try {
            Path filePath = OutputUtils.buildOutputPath((Source)src, (AbstractAnalysis)this, (String)"cloc.csv");
            BufferedWriter writer = Files.newBufferedWriter(filePath, Charset.forName("UTF-8"), new OpenOption[0]);
            writer.append("Timestamp");
            for (String string : availableLanguages) {
                writer.append("," + string);
            }
            writer.append("\n");
            for (Map.Entry entry : clocData.entrySet()) {
                writer.append("" + entry.getKey());
                for (String language : availableLanguages) {
                    Integer cloc = (Integer)((HashMap)entry.getValue()).get(language);
                    if (cloc == null) {
                        cloc = 0;
                    }
                    writer.append("," + cloc);
                }
                writer.append("\n");
            }
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

