/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.console;

import java.util.Arrays;
import java.util.TreeSet;
import org.tmatesoft.hg.console.Options;
import org.tmatesoft.hg.core.HgAnnotateCommand;
import org.tmatesoft.hg.core.HgRepoFacade;
import org.tmatesoft.hg.util.Path;

public class Annotate {
    public static void main(String[] args) throws Exception {
        HgRepoFacade repo = new HgRepoFacade();
        String[] boolOpts = new String[]{"-l", "--line-number"};
        Options cmdLineOpts = Options.parse(args, new TreeSet<String>(Arrays.asList(boolOpts)));
        if (!repo.init(cmdLineOpts.findRepository())) {
            System.err.printf("Can't find repository in: %s\n", repo.getRepository().getLocation());
            return;
        }
        int rev = cmdLineOpts.getSingleInt(-3, "-r", "--rev");
        HgAnnotateCommand cmd = repo.createAnnotateCommand();
        AnnotateDumpInspector insp = new AnnotateDumpInspector(cmdLineOpts.getBoolean(false, "-l", "--line-number"));
        cmd.changeset(rev);
        for (String fname : cmdLineOpts.getList("")) {
            cmd.file(Path.create(fname));
            cmd.execute(insp);
        }
    }

    private static class AnnotateDumpInspector
    implements HgAnnotateCommand.Inspector {
        private final boolean lineNumbers;

        public AnnotateDumpInspector(boolean printLineNumbers) {
            this.lineNumbers = printLineNumbers;
        }

        @Override
        public void next(HgAnnotateCommand.LineInfo lineInfo) {
            if (this.lineNumbers) {
                System.out.printf("%3d:%3d: %s", lineInfo.getChangesetIndex(), lineInfo.getOriginLineNumber(), new String(lineInfo.getContent()));
            } else {
                System.out.printf("%3d: %s", lineInfo.getChangesetIndex(), new String(lineInfo.getContent()));
            }
        }
    }
}

