/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.console;

import java.io.File;
import java.util.Collections;
import java.util.LinkedList;
import org.tmatesoft.hg.console.Options;
import org.tmatesoft.hg.core.HgException;
import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.repo.HgBundle;
import org.tmatesoft.hg.repo.HgChangelog;
import org.tmatesoft.hg.repo.HgLookup;
import org.tmatesoft.hg.repo.HgRepository;
import org.tmatesoft.hg.repo.HgRuntimeException;

public class Bundle {
    public static void main(String[] args) throws Exception {
        Options cmdLineOpts = Options.parse(args, Collections.emptySet());
        HgRepository hgRepo = cmdLineOpts.findRepository();
        if (hgRepo.isInvalid()) {
            System.err.printf("Can't find repository in: %s\n", hgRepo.getLocation());
            return;
        }
        File bundleFile = new File("/temp/hg/hg-bundle-cpython.tmp");
        HgBundle hgBundle = new HgLookup().loadBundle(bundleFile);
        hgBundle.inspectFiles(new Dump());
        if (Boolean.parseBoolean("true")) {
            return;
        }
        hgBundle.changes(hgRepo, new HgChangelog.Inspector(hgRepo){
            private final HgChangelog changelog;
            {
                this.changelog = hgRepository.getChangelog();
            }

            @Override
            public void next(int revisionNumber, Nodeid nodeid, HgChangelog.RawChangeset cset) throws HgRuntimeException {
                if (this.changelog.isKnown(nodeid)) {
                    System.out.print("+");
                } else {
                    System.out.print("-");
                }
                System.out.printf("%d:%s\n%s\n", revisionNumber, nodeid.shortNotation(), cset.toString());
            }
        });
    }

    public static void dump(HgBundle hgBundle) throws HgException, HgRuntimeException {
        Dump dump = new Dump();
        hgBundle.inspectAll(dump);
        System.out.println("Total files:" + dump.names.size());
        for (String s : dump.names) {
            System.out.println(s);
        }
    }

    public static class Dump
    implements HgBundle.Inspector {
        public final LinkedList<String> names = new LinkedList();

        @Override
        public void changelogStart() {
            System.out.println("Changelog group");
        }

        @Override
        public void changelogEnd() {
        }

        @Override
        public void manifestStart() {
            System.out.println("Manifest group");
        }

        @Override
        public void manifestEnd() {
        }

        @Override
        public void fileStart(String name) {
            this.names.add(name);
            System.out.println(name);
        }

        @Override
        public void fileEnd(String name) {
        }

        @Override
        public boolean element(HgBundle.GroupElement ge) {
            System.out.printf("  %s\n", ge.toString());
            return true;
        }
    }
}

