/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.console;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import org.tmatesoft.hg.console.Options;
import org.tmatesoft.hg.repo.HgDataFile;
import org.tmatesoft.hg.repo.HgRepository;
import org.tmatesoft.hg.util.ByteChannel;

public class Cat {
    public static void main(String[] args) throws Exception {
        Options cmdLineOpts = Options.parse(args, Collections.emptySet());
        HgRepository hgRepo = cmdLineOpts.findRepository();
        if (hgRepo.isInvalid()) {
            System.err.printf("Can't find repository in: %s\n", hgRepo.getLocation());
            return;
        }
        int rev = cmdLineOpts.getSingleInt(-3, "-r", "--rev");
        OutputStreamChannel out = new OutputStreamChannel(System.out);
        for (String fname : cmdLineOpts.getList("")) {
            System.out.println(fname);
            HgDataFile fn = hgRepo.getFileNode(fname);
            if (fn.exists()) {
                fn.contentWithFilters(rev, out);
                System.out.println();
                continue;
            }
            System.out.printf("%s not found!\n", fname);
        }
    }

    private static class OutputStreamChannel
    implements ByteChannel {
        private final OutputStream stream;

        public OutputStreamChannel(OutputStream out) {
            this.stream = out;
        }

        @Override
        public int write(ByteBuffer buffer) throws IOException {
            int count = buffer.remaining();
            while (buffer.hasRemaining()) {
                this.stream.write(buffer.get());
            }
            return count;
        }
    }
}

