/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.console;

import java.util.Formatter;
import java.util.LinkedList;
import java.util.List;
import org.tmatesoft.hg.core.HgChangeset;
import org.tmatesoft.hg.core.HgChangesetHandler;
import org.tmatesoft.hg.core.HgException;
import org.tmatesoft.hg.core.HgFileRevision;
import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.repo.HgRepository;
import org.tmatesoft.hg.repo.HgRuntimeException;
import org.tmatesoft.hg.util.Path;

public class ChangesetDumpHandler
implements HgChangesetHandler {
    private boolean complete = false;
    private boolean reverseOrder = false;
    private boolean verbose = false;
    private LinkedList<String> l = new LinkedList();
    private final HgRepository repo;
    private final int tip;

    public ChangesetDumpHandler(HgRepository hgRepo) throws HgRuntimeException {
        this.repo = hgRepo;
        this.tip = hgRepo.getChangelog().getLastRevision();
    }

    public ChangesetDumpHandler complete(boolean b) {
        this.complete = b;
        return this;
    }

    public ChangesetDumpHandler reversed(boolean b) {
        this.reverseOrder = b;
        return this;
    }

    public ChangesetDumpHandler verbose(boolean b) {
        this.verbose = b;
        return this;
    }

    @Override
    public void cset(HgChangeset changeset) throws HgRuntimeException {
        try {
            String s = this.print(changeset);
            if (this.reverseOrder) {
                this.l.addFirst(s);
            } else {
                System.out.print(s);
            }
        }
        catch (HgException ex) {
            ex.printStackTrace();
        }
    }

    public void done() {
        if (!this.reverseOrder) {
            return;
        }
        for (String s : this.l) {
            System.out.print(s);
        }
        this.l.clear();
    }

    private String print(HgChangeset cset) throws HgException, HgRuntimeException {
        StringBuilder sb = new StringBuilder();
        Formatter f = new Formatter(sb);
        Nodeid csetNodeid = cset.getNodeid();
        f.format("changeset:   %d:%s\n", cset.getRevisionIndex(), this.complete ? csetNodeid : csetNodeid.shortNotation());
        if (cset.getRevisionIndex() == this.tip || this.repo.getTags().isTagged(csetNodeid)) {
            sb.append("tag:         ");
            for (String string : this.repo.getTags().tags(csetNodeid)) {
                sb.append(string);
                sb.append(' ');
            }
            if (cset.getRevisionIndex() == this.tip) {
                sb.append("tip");
            }
            sb.append('\n');
        }
        if (this.complete) {
            f.format("phase:       %s\n", cset.getPhase().name());
            Nodeid nodeid = cset.getFirstParentRevision();
            Nodeid p2 = cset.getSecondParentRevision();
            Nodeid mr = cset.getManifestRevision();
            int p1x = nodeid.isNull() ? -1 : this.repo.getChangelog().getRevisionIndex(nodeid);
            int p2x = p2.isNull() ? -1 : this.repo.getChangelog().getRevisionIndex(p2);
            int mx = mr.isNull() ? -1 : this.repo.getManifest().getRevisionIndex(mr);
            f.format("parent:      %d:%s\nparent:      %d:%s\nmanifest:    %d:%s\n", p1x, nodeid, p2x, p2, mx, cset.getManifestRevision());
        }
        f.format("user:        %s\ndate:        %s\n", cset.getUser(), cset.getDate().toString());
        if (!this.complete && this.verbose) {
            List<Path> list = cset.getAffectedFiles();
            sb.append("files:      ");
            for (Path s : list) {
                sb.append(' ');
                sb.append(s);
            }
            sb.append('\n');
        }
        if (this.complete) {
            if (!cset.getModifiedFiles().isEmpty()) {
                sb.append("files:      ");
                for (HgFileRevision hgFileRevision : cset.getModifiedFiles()) {
                    sb.append(' ');
                    sb.append(hgFileRevision.getPath());
                }
                sb.append('\n');
            }
            if (!cset.getAddedFiles().isEmpty()) {
                sb.append("files+:     ");
                for (HgFileRevision hgFileRevision : cset.getAddedFiles()) {
                    sb.append(' ');
                    sb.append(hgFileRevision.getPath());
                }
                sb.append('\n');
            }
            if (!cset.getRemovedFiles().isEmpty()) {
                sb.append("files-:     ");
                for (Path path : cset.getRemovedFiles()) {
                    sb.append(' ');
                    sb.append(path);
                }
                sb.append('\n');
            }
        }
        if (this.complete || this.verbose) {
            f.format("description:\n%s\n\n", cset.getComment());
        } else {
            f.format("summary:     %s\n\n", cset.getComment());
        }
        return sb.toString();
    }
}

