/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.console;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.tmatesoft.hg.console.Options;
import org.tmatesoft.hg.core.HgCloneCommand;
import org.tmatesoft.hg.repo.HgLookup;
import org.tmatesoft.hg.repo.HgRemoteRepository;

public class Clone {
    public static void main(String[] args) throws Exception {
        Options cmdLineOpts = Options.parse(args, Collections.emptySet());
        List<String> noOptsArgs = cmdLineOpts.getList("");
        if (noOptsArgs.isEmpty()) {
            System.err.println("Need at least one argument pointing to remote server to pull changes from");
            return;
        }
        HgCloneCommand cmd = new HgCloneCommand();
        String remoteRepo = noOptsArgs.get(0);
        HgRemoteRepository hgRemote = new HgLookup().detectRemote(remoteRepo, null);
        if (hgRemote.isInvalid()) {
            System.err.printf("Remote repository %s is not valid", hgRemote.getLocation());
            return;
        }
        cmd.source(hgRemote);
        if (noOptsArgs.size() > 1) {
            cmd.destination(new File(noOptsArgs.get(1)));
        } else {
            cmd.destination(new File(System.getProperty("user.dir")));
        }
        cmd.execute();
    }
}

