/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.console;

import java.util.Collections;
import org.tmatesoft.hg.console.Options;
import org.tmatesoft.hg.core.HgCommitCommand;
import org.tmatesoft.hg.core.HgRepoFacade;
import org.tmatesoft.hg.util.Outcome;

public class Commit {
    public static void main(String[] args) throws Exception {
        HgRepoFacade repo = new HgRepoFacade();
        Options cmdLineOpts = Options.parse(args, Collections.emptySet());
        if (!repo.init(cmdLineOpts.findRepository())) {
            System.err.printf("Can't find repository in: %s\n", repo.getRepository().getLocation());
            return;
        }
        String message = cmdLineOpts.getSingle("-m", "--message");
        if (message == null) {
            System.err.println("Need a commit message");
            return;
        }
        HgCommitCommand cmd = repo.createCommitCommand();
        cmd.message(message);
        Outcome o = cmd.execute();
        if (!o.isOk()) {
            System.err.println(o.getMessage());
            return;
        }
        System.out.printf("New changeset: %s\n", cmd.getCommittedRevision().shortNotation());
    }
}

