/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.console;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.tmatesoft.hg.console.ChangesetDumpHandler;
import org.tmatesoft.hg.console.Options;
import org.tmatesoft.hg.console.Outgoing;
import org.tmatesoft.hg.core.HgIncomingCommand;
import org.tmatesoft.hg.core.HgRepoFacade;
import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.repo.HgLookup;
import org.tmatesoft.hg.repo.HgRemoteRepository;

public class Incoming {
    public static void main(String[] args) throws Exception {
        if (Boolean.FALSE.booleanValue()) {
            new SequenceConstructor().test();
            return;
        }
        HgRepoFacade hgRepo = new HgRepoFacade();
        Options cmdLineOpts = Options.parse(args, Collections.emptySet());
        if (!hgRepo.init(cmdLineOpts.findRepository())) {
            System.err.printf("Can't find repository in: %s\n", hgRepo.getRepository().getLocation());
            return;
        }
        HgRemoteRepository hgRemote = new HgLookup().detectRemote(cmdLineOpts.getSingle(""), hgRepo.getRepository());
        if (hgRemote.isInvalid()) {
            System.err.printf("Remote repository %s is not valid", hgRemote.getLocation());
            return;
        }
        HgIncomingCommand cmd = hgRepo.createIncomingCommand();
        cmd.against(hgRemote);
        List<Nodeid> missing = cmd.executeLite();
        Collections.reverse(missing);
        Outgoing.dump("Nodes to fetch:", missing);
        System.out.printf("Total: %d\n\n", missing.size());
        ChangesetDumpHandler h = new ChangesetDumpHandler(hgRepo.getRepository());
        h.complete(false);
        h.verbose(cmdLineOpts.getBoolean("-v", "--verbose"));
        cmd.executeFull(h);
    }

    private static class SequenceConstructor {
        private SequenceConstructor() {
        }

        private int[] between(int root, int head) {
            if (head <= root + 1) {
                return new int[0];
            }
            System.out.printf("[%d, %d]\t\t", root, head);
            int size = 1 + (int)Math.floor(Math.log(head - root - 1) / Math.log(2.0));
            int[] rv = new int[size];
            int v = 1;
            int i = 0;
            while (i < rv.length) {
                rv[i] = root + v;
                v <<= 1;
                ++i;
            }
            System.out.println(Arrays.toString(rv));
            return rv;
        }

        public void test() {
            int root = 0;
            int head = 126;
            int[] data = this.between(root, head);
            int[] finalSequence = new int[1 + (1 << data.length >>> 5)];
            int exactNumberOfElements = -1;
            LinkedHashMap<Integer, int[]> datas = new LinkedHashMap<Integer, int[]>();
            datas.put(root, data);
            int totalQueries = 1;
            HashSet<Integer> queried = new HashSet<Integer>();
            int[] checkSequence = null;
            while (!datas.isEmpty()) {
                int n;
                LinkedList<int[]> toQuery = new LinkedList<int[]>();
                do {
                    int i;
                    Iterator it = datas.entrySet().iterator();
                    Map.Entry next = it.next();
                    int r = (Integer)next.getKey();
                    data = (int[])next.getValue();
                    it.remove();
                    this.populate(r, head, data, finalSequence);
                    if (checkSequence != null) {
                        boolean match = true;
                        i = 0;
                        while (i < checkSequence.length) {
                            match = checkSequence[i] != finalSequence[i] ? false : (match &= true);
                            ++i;
                        }
                        System.out.println(match ? "Match, on query:" + totalQueries : "Didn't match");
                    }
                    if (data.length <= 1) continue;
                    int[] nArray = data;
                    n = data.length;
                    i = 0;
                    while (i < n) {
                        int x = nArray[i];
                        if (!queried.contains(x) && head - x > 1) {
                            toQuery.add(new int[]{x, head});
                        }
                        ++i;
                    }
                } while (!datas.isEmpty());
                if (!toQuery.isEmpty()) {
                    System.out.println();
                    ++totalQueries;
                }
                Collections.sort(toQuery, new Comparator<int[]>(){

                    @Override
                    public int compare(int[] o1, int[] o2) {
                        return o1[0] < o2[0] ? -1 : (o1[0] == o2[0] ? 0 : 1);
                    }
                });
                for (int[] x : toQuery) {
                    if (queried.contains(x[0])) continue;
                    queried.add(x[0]);
                    data = this.between(x[0], x[1]);
                    if (exactNumberOfElements == -1 && data.length == 1) {
                        exactNumberOfElements = x[0] + 1;
                        System.out.printf("On query %d found out exact number of missing elements: %d\n", totalQueries, exactNumberOfElements);
                        int totalInts = exactNumberOfElements + 2 >>> 5;
                        int trailingBits = exactNumberOfElements + 2 & 0x1F;
                        if (trailingBits != 0) {
                            ++totalInts;
                        }
                        checkSequence = new int[totalInts];
                        Arrays.fill(checkSequence, -1);
                        checkSequence[0] = checkSequence[0] & Integer.MAX_VALUE;
                        if (trailingBits == 0) {
                            int n2 = totalInts - 1;
                            checkSequence[n2] = checkSequence[n2] & 0xFFFFFFFE;
                        } else if (trailingBits == 1) {
                            checkSequence[totalInts - 1] = 0;
                        } else {
                            int mask = Integer.MIN_VALUE >> trailingBits - 2;
                            int n3 = totalInts - 1;
                            checkSequence[n3] = checkSequence[n3] & mask;
                        }
                        int[] nArray = checkSequence;
                        int n4 = checkSequence.length;
                        n = 0;
                        while (n < n4) {
                            int e = nArray[n];
                            System.out.print(SequenceConstructor.toBinaryString(e, ' '));
                            ++n;
                        }
                        System.out.println();
                    }
                    datas.put(x[0], data);
                }
            }
            System.out.println("Total queries:" + totalQueries);
            int[] nArray = finalSequence;
            int n = finalSequence.length;
            int n5 = 0;
            while (n5 < n) {
                int x = nArray[n5];
                System.out.print(SequenceConstructor.toBinaryString(x, ' '));
                ++n5;
            }
        }

        private void populate(int root, int head, int[] data, int[] finalSequence) {
            int i = 1;
            int x = 0;
            while (root + i < head) {
                int value = data[x];
                int value_check = root + i;
                if (value != value_check) {
                    throw new IllegalStateException();
                }
                int wordIx = root + i >>> 5;
                int bitIx = root + i & 0x1F;
                int n = wordIx;
                finalSequence[n] = finalSequence[n] | 1 << 31 - bitIx;
                i <<= 1;
                ++x;
            }
        }

        private static String toBinaryString(int x, char byteSeparator) {
            StringBuilder sb = new StringBuilder(36);
            sb.append(SequenceConstructor.toBinaryString((byte)(x >>> 24)));
            sb.append(byteSeparator);
            sb.append(SequenceConstructor.toBinaryString((byte)((x & 0xFF0000) >>> 16)));
            sb.append(byteSeparator);
            sb.append(SequenceConstructor.toBinaryString((byte)((x & 0xFF00) >>> 8)));
            sb.append(byteSeparator);
            sb.append(SequenceConstructor.toBinaryString((byte)(x & 0xFF)));
            sb.append(byteSeparator);
            return sb.toString();
        }

        private static String toBinaryString(byte b) {
            assert ("0000000100100011010001010110011110001001101010111100110111101111".length() == 64);
            int x1 = b >>> 4 & 0xF;
            int x2 = b & 0xF;
            return "0000000100100011010001010110011110001001101010111100110111101111".substring(x1 *= 4, x1 + 4).concat("0000000100100011010001010110011110001001101010111100110111101111".substring(x2 *= 4, x2 + 4));
        }
    }
}

