/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.console;

import java.util.List;
import org.tmatesoft.hg.console.ChangesetDumpHandler;
import org.tmatesoft.hg.console.Options;
import org.tmatesoft.hg.core.HgChangesetHandler;
import org.tmatesoft.hg.core.HgFileRenameHandlerMixin;
import org.tmatesoft.hg.core.HgFileRevision;
import org.tmatesoft.hg.core.HgLogCommand;
import org.tmatesoft.hg.repo.HgDataFile;
import org.tmatesoft.hg.repo.HgRepository;
import org.tmatesoft.hg.repo.HgRuntimeException;
import org.tmatesoft.hg.util.CancelSupport;
import org.tmatesoft.hg.util.ProgressSupport;

public class Log {
    public static void main(String[] args) throws Exception {
        Options cmdLineOpts = Options.parse(args, Options.asSet("--debug", "-v", "--verbose", "--hg4j-order-direct"));
        HgRepository hgRepo = cmdLineOpts.findRepository();
        if (hgRepo.isInvalid()) {
            System.err.printf("Can't find repository in: %s\n", hgRepo.getLocation());
            return;
        }
        CancelSupport noCancel = CancelSupport.Factory.get(null);
        ProgressSupport noProgress = ProgressSupport.Factory.get(null);
        Dump dump = new Dump(hgRepo);
        dump.complete(cmdLineOpts.getBoolean("--debug"));
        dump.verbose(cmdLineOpts.getBoolean("-v", "--verbose"));
        boolean reverseOrder = !cmdLineOpts.getBoolean("--hg4j-order-direct");
        dump.reversed(reverseOrder);
        HgLogCommand cmd = new HgLogCommand(hgRepo);
        for (String u : cmdLineOpts.getList("-u", "--user")) {
            cmd.user(u);
        }
        for (String b : cmdLineOpts.getList("-b", "--branches")) {
            cmd.branch(b);
        }
        int limit = cmdLineOpts.getSingleInt(-1, "-l", "--limit");
        if (limit != -1) {
            cmd.limit(limit);
        }
        ((HgLogCommand)cmd.set(noCancel)).set(noProgress);
        List<String> files = cmdLineOpts.getList("");
        long start = System.currentTimeMillis();
        if (files.isEmpty()) {
            if (limit == -1) {
                cmd.execute(dump);
            } else {
                int[] nArray = new int[2];
                nArray[1] = hgRepo.getChangelog().getRevisionCount();
                int[] r = nArray;
                if (Log.fixRange(r, reverseOrder, limit) == 0) {
                    System.out.println("No changes");
                    return;
                }
                cmd.range(r[0], r[1]).execute(dump);
            }
            dump.done();
        } else {
            for (String fname : files) {
                HgDataFile f1 = hgRepo.getFileNode(fname);
                System.out.println("History of the file: " + f1.getPath());
                if (limit == -1) {
                    cmd.file(f1.getPath(), true).execute(dump);
                } else {
                    int[] nArray = new int[2];
                    nArray[1] = f1.getRevisionCount();
                    int[] r = nArray;
                    if (Log.fixRange(r, reverseOrder, limit) == 0) {
                        System.out.println("No changes");
                        continue;
                    }
                    cmd.range(r[0], r[1]).file(f1.getPath(), true).execute(dump);
                }
                dump.done();
            }
        }
        System.out.println("Total time:" + (System.currentTimeMillis() - start));
    }

    private static int fixRange(int[] start_end, boolean reverse, int limit) {
        assert (start_end.length == 2);
        if (limit < start_end[1]) {
            if (reverse) {
                start_end[0] = start_end[1] - limit;
            } else {
                start_end[1] = limit;
            }
        }
        int rv = start_end[1] - start_end[0];
        start_end[1] = start_end[1] - 1;
        return rv;
    }

    private static final class Dump
    extends ChangesetDumpHandler
    implements HgChangesetHandler.WithCopyHistory {
        private final RenameDumpHandler renameHandlerDelegate = new RenameDumpHandler();

        public Dump(HgRepository hgRepo) throws HgRuntimeException {
            super(hgRepo);
        }

        @Override
        public void copy(HgFileRevision from, HgFileRevision to) {
            this.renameHandlerDelegate.copy(from, to);
        }
    }

    static class RenameDumpHandler
    implements HgFileRenameHandlerMixin {
        RenameDumpHandler() {
        }

        @Override
        public void copy(HgFileRevision from, HgFileRevision to) {
            System.out.printf("Got notified that %s(%s) was originally known as %s(%s)\n", to.getPath(), to.getRevision(), from.getPath(), from.getRevision());
        }
    }
}

