/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.console;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.tmatesoft.hg.console.ChangesetDumpHandler;
import org.tmatesoft.hg.console.Log;
import org.tmatesoft.hg.console.Options;
import org.tmatesoft.hg.core.HgChangeset;
import org.tmatesoft.hg.core.HgChangesetFileSneaker;
import org.tmatesoft.hg.core.HgChangesetTreeHandler;
import org.tmatesoft.hg.core.HgCheckoutCommand;
import org.tmatesoft.hg.core.HgException;
import org.tmatesoft.hg.core.HgFileRenameHandlerMixin;
import org.tmatesoft.hg.core.HgFileRevision;
import org.tmatesoft.hg.core.HgLogCommand;
import org.tmatesoft.hg.core.HgManifestCommand;
import org.tmatesoft.hg.core.HgManifestHandler;
import org.tmatesoft.hg.core.HgRevertCommand;
import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.internal.BasicSessionContext;
import org.tmatesoft.hg.internal.ByteArrayChannel;
import org.tmatesoft.hg.internal.DigestHelper;
import org.tmatesoft.hg.internal.ManifestRevision;
import org.tmatesoft.hg.internal.PathGlobMatcher;
import org.tmatesoft.hg.internal.RelativePathRewrite;
import org.tmatesoft.hg.internal.StreamLogFacility;
import org.tmatesoft.hg.repo.HgBookmarks;
import org.tmatesoft.hg.repo.HgBranches;
import org.tmatesoft.hg.repo.HgChangelog;
import org.tmatesoft.hg.repo.HgDataFile;
import org.tmatesoft.hg.repo.HgDirstate;
import org.tmatesoft.hg.repo.HgIgnore;
import org.tmatesoft.hg.repo.HgInternals;
import org.tmatesoft.hg.repo.HgInvalidControlFileException;
import org.tmatesoft.hg.repo.HgManifest;
import org.tmatesoft.hg.repo.HgMergeState;
import org.tmatesoft.hg.repo.HgRepository;
import org.tmatesoft.hg.repo.HgRevisionMap;
import org.tmatesoft.hg.repo.HgRuntimeException;
import org.tmatesoft.hg.repo.HgStatusCollector;
import org.tmatesoft.hg.repo.HgStatusInspector;
import org.tmatesoft.hg.repo.HgSubrepoLocation;
import org.tmatesoft.hg.repo.HgWorkingCopyStatusCollector;
import org.tmatesoft.hg.repo.ext.HgExtensionsManager;
import org.tmatesoft.hg.repo.ext.Rebase;
import org.tmatesoft.hg.util.Adaptable;
import org.tmatesoft.hg.util.FileWalker;
import org.tmatesoft.hg.util.LogFacility;
import org.tmatesoft.hg.util.Pair;
import org.tmatesoft.hg.util.Path;
import org.tmatesoft.hg.util.PathRewrite;

public class Main {
    private Options cmdLineOpts;
    private HgRepository hgRepo;

    public Main(String[] args) throws Exception {
        this.cmdLineOpts = Options.parse(args, Collections.emptySet());
        this.hgRepo = this.cmdLineOpts.findRepository();
        if (this.hgRepo.isInvalid()) {
            System.err.printf("Can't find repository in: %s\n", this.hgRepo.getLocation());
            return;
        }
        System.out.println("REPO:" + this.hgRepo.getLocation());
    }

    public static void main(String[] args) throws Exception {
        Main m = new Main(args);
        m.dumpBranches();
    }

    private void checkFileSneakerPerformance() throws Exception {
        HgChangesetFileSneaker fs1 = new HgChangesetFileSneaker(this.hgRepo);
        HgChangesetFileSneaker fs2 = new HgChangesetFileSneaker(this.hgRepo);
        fs1.followRenames(true);
        fs2.followRenames(true);
        Nodeid cset = this.hgRepo.getChangelog().getRevision(2);
        Path fname = Path.create("dir9/file9");
        fs1.changeset(cset);
        fs2.changeset(cset);
        long start1 = System.nanoTime();
        boolean e1 = fs1.checkExists(fname);
        long end1 = System.nanoTime();
        boolean e2 = fs2.checkExists(fname);
        long end2 = System.nanoTime();
        Nodeid fr = this.hgRepo.getManifest().getFileRevision(-3, fname);
        long end3 = System.nanoTime();
        System.out.printf("\t1st run: %d ms, %b\n\t2nd run: %d ms, %b\n\tfile only: %d ms", (end1 - start1) / 1000000L, e1, (end2 - end1) / 1000000L, e2, (end3 - end2) / 1000000L);
        if (!fr.equals(fs1.revision()) || !fr.equals(fs2.revision())) {
            throw new AssertionError();
        }
        ManifestRevision mr = new ManifestRevision(null, null);
        long _s1 = System.nanoTime();
        this.hgRepo.getManifest().walk(0, 0, mr);
        long _e1 = System.nanoTime();
        this.hgRepo.getManifest().getFileRevision(0, fname);
        long _e2 = System.nanoTime();
        System.out.printf("\n\tManifestRevision:%d ms, getFileRevision:%d ms\n", (_e1 - _s1) / 1000000L, (_e2 - _e1) / 1000000L);
    }

    private void checkFileSneakerPerformance2() throws Exception {
        Path fname = Path.create("dir9/file9");
        this.hgRepo.getManifest().getFileRevision(0, fname);
    }

    private void testRevert() throws Exception {
        HgRevertCommand cmd = new HgRevertCommand(this.hgRepo);
        cmd.file(Path.create("a.txt")).execute();
    }

    private void testCheckout() throws Exception {
        HgCheckoutCommand coCmd = new HgCheckoutCommand(this.hgRepo);
        coCmd.changeset(17).execute();
    }

    private void tryExtensions() throws Exception {
        HgExtensionsManager em = this.hgRepo.getExtensions();
        if (!em.isEnabled(HgExtensionsManager.HgExt.Rebase)) {
            System.out.println("Rebase is not enabled");
            return;
        }
        Rebase re = em.getRebaseExtension();
        if (!re.refresh().isRebaseInProgress()) {
            System.out.println("No rebase is in progress");
            return;
        }
        System.out.printf("%s %s %s\n", re.getWorkingDirParent().shortNotation(), re.getTarget().shortNotation(), re.getExternalParent().shortNotation());
        System.out.printf("collapse:%b, keep:%b, keepbranches:%b\n", re.isCollapse(), re.isKeepOriginalRevisions(), re.isKeepBranchNames());
    }

    private void dumpBookmarks() throws Exception {
        HgBookmarks bm = this.hgRepo.getBookmarks();
        String active = bm.getActiveBookmarkName();
        ArrayList<String> all = new ArrayList<String>(bm.getAllBookmarks());
        Collections.sort(all);
        for (String bmname : all) {
            if (bmname.equals(active)) {
                System.out.print(" * ");
            } else {
                System.out.print("   ");
            }
            System.out.printf("%-26s (%s)\n", bmname, bm.getRevision(bmname).shortNotation());
        }
    }

    private void dumpCommitLastMessage() throws Exception {
        System.out.println(this.hgRepo.getCommitLastMessage());
    }

    private void buildFileLog() throws Exception {
        long start = System.nanoTime();
        HgLogCommand cmd = new HgLogCommand(this.hgRepo);
        cmd.file("a2.txt", true, false);
        int[] count = new int[1];
        class MyHandler
        implements HgChangesetTreeHandler,
        Adaptable {
            private final /* synthetic */ int[] val$count;

            MyHandler(int[] nArray) {
                this.val$count = nArray;
            }

            @Override
            public void treeElement(HgChangesetTreeHandler.TreeElement entry) throws HgRuntimeException {
                HgChangeset p2;
                HgChangeset p1;
                StringBuilder sb = new StringBuilder();
                new HashSet<Nodeid>(entry.childRevisions());
                for (HgChangeset cc : entry.children()) {
                    sb.append(cc.getRevisionIndex());
                    sb.append(':');
                    sb.append(cc.getNodeid().shortNotation());
                    sb.append(", ");
                }
                Pair<Nodeid, Nodeid> parents = entry.parentRevisions();
                boolean isJoin = !parents.first().isNull() && !parents.second().isNull();
                boolean isFork = entry.children().size() > 1;
                HgChangeset cset = entry.changeset();
                System.out.printf("%d:%s - %s (%s)\n", new Object[]{cset.getRevisionIndex(), cset.getNodeid().shortNotation(), cset.getComment(), cset.getPhase()});
                System.out.printf("\tKnown as %s (file rev:%s)\n", entry.file().getPath(), entry.fileRevision().shortNotation());
                if (!(isJoin || isFork || entry.children().isEmpty())) {
                    p1 = entry.parents().first();
                    p2 = entry.parents().second();
                    System.out.printf("\tp1:%d, p2:%d\n", p1 == null ? -1 : p1.getRevisionIndex(), p2 == null ? -1 : p2.getRevisionIndex());
                    System.out.printf("\t=> %s\n", sb);
                }
                if (isJoin) {
                    p1 = entry.parents().first();
                    p2 = entry.parents().second();
                    System.out.printf("\tjoin <= (%d:%s, %d:%s)", p1.getRevisionIndex(), p1.getNodeid().shortNotation(), p2.getRevisionIndex(), p2.getNodeid().shortNotation());
                    if (isFork) {
                        System.out.print(", ");
                    }
                }
                if (isFork) {
                    if (!isJoin) {
                        System.out.print('\t');
                    }
                    System.out.printf("fork => [%s]", sb);
                }
                if (isJoin || isFork) {
                    System.out.println();
                }
                this.val$count[0] = this.val$count[0] + 1;
            }

            @Override
            public <T> T getAdapter(Class<T> adapterClass) {
                if (adapterClass == HgFileRenameHandlerMixin.class) {
                    return adapterClass.cast(new Log.RenameDumpHandler());
                }
                return null;
            }
        }
        cmd.execute(new MyHandler(count));
        System.out.println(count[0]);
        long end = System.nanoTime();
        System.out.printf("buildFileLog: %,d ms\n", (end - start) / 1000L);
    }

    private void buildFileLogOld() throws Exception {
        final HgDataFile fn = this.hgRepo.getFileNode("file1");
        final int[] fileChangesetRevisions = new int[fn.getRevisionCount()];
        fn.history(new HgChangelog.Inspector(){
            private int fileLocalRevisions = 0;
            private int[] parentRevisions = new int[2];

            @Override
            public void next(int revisionNumber, Nodeid nodeid, HgChangelog.RawChangeset cset) {
                try {
                    boolean join;
                    fileChangesetRevisions[this.fileLocalRevisions] = revisionNumber;
                    fn.parents(this.fileLocalRevisions, this.parentRevisions, null, null);
                    boolean bl = join = this.parentRevisions[0] != -1 && this.parentRevisions[1] != -1;
                    if (join) {
                        System.out.print("join[");
                    }
                    if (this.parentRevisions[0] != -1) {
                        System.out.printf("%2d->%2d, ", fileChangesetRevisions[this.parentRevisions[0]], revisionNumber);
                    }
                    if (this.parentRevisions[1] != -1) {
                        System.out.printf("%2d->%2d, ", fileChangesetRevisions[this.parentRevisions[1]], revisionNumber);
                    }
                    if (join) {
                        System.out.print("]");
                    }
                    ++this.fileLocalRevisions;
                }
                catch (HgRuntimeException ex) {
                    ex.printStackTrace();
                }
            }
        });
        System.out.println();
    }

    private void testConsoleLog() {
        StreamLogFacility fc = new StreamLogFacility(LogFacility.Severity.Debug, true, System.out);
        System.out.printf("isDebug: %s, isInfo:%s\n", fc.isDebug(), fc.getLevel() == LogFacility.Severity.Info);
        fc.dump(this.getClass(), LogFacility.Severity.Debug, "%d", 1);
        fc.dump(this.getClass(), LogFacility.Severity.Info, "%d\n", 2);
        fc.dump(this.getClass(), LogFacility.Severity.Warn, "%d\n", 3);
        fc.dump(this.getClass(), LogFacility.Severity.Error, "%d", 4);
        Exception ex = new Exception();
        fc.dump(this.getClass(), LogFacility.Severity.Debug, ex, "message");
        fc.dump(this.getClass(), LogFacility.Severity.Info, ex, null);
        fc.dump(this.getClass(), LogFacility.Severity.Warn, ex, null);
        fc.dump(this.getClass(), LogFacility.Severity.Error, ex, "message");
    }

    private void testTreeTraversal() throws Exception {
        File repoRoot = this.hgRepo.getWorkingDir();
        Path.SimpleSource pathSrc = new Path.SimpleSource(new PathRewrite.Composite(new RelativePathRewrite(repoRoot), this.hgRepo.getToRepoPathHelper()));
        FileWalker w = new FileWalker(new BasicSessionContext(null), repoRoot, pathSrc);
        int count = 0;
        long start = System.currentTimeMillis();
        while (w.hasNext()) {
            ++count;
            w.next();
        }
        System.out.printf("Traversal of %d files took %d ms", count, System.currentTimeMillis() - start);
    }

    private void testRevisionMap() throws Exception {
        HgChangelog changelog = this.hgRepo.getChangelog();
        HgRevisionMap<HgChangelog> rmap = new HgRevisionMap<HgChangelog>(changelog).init();
        int tip = changelog.getLastRevision();
        Nodeid[] revs = new Nodeid[5];
        revs[4] = changelog.getRevision(0);
        revs[3] = changelog.getRevision(tip / 4);
        revs[2] = changelog.getRevision(tip / 2);
        revs[1] = changelog.getRevision(tip / 4 + tip / 2);
        revs[0] = changelog.getRevision(tip);
        long start = System.currentTimeMillis();
        int i = 0;
        while (i < revs.length) {
            int localRev = changelog.getRevisionIndex(revs[i]);
            System.out.printf("%d:%s\n", localRev, revs[i]);
            ++i;
        }
        System.out.println(System.currentTimeMillis() - start);
        System.out.println();
        start = System.currentTimeMillis();
        rmap = new HgRevisionMap<HgChangelog>(changelog).init();
        long s2 = System.currentTimeMillis();
        int i2 = 0;
        while (i2 < revs.length) {
            int localRev = rmap.revisionIndex(revs[i2]);
            System.out.printf("%d:%s\n", localRev, revs[i2]);
            ++i2;
        }
        System.out.println(System.currentTimeMillis() - start);
        System.out.printf("\t from that, init took %d ms\n", s2 - start);
    }

    private void testSubrepos() throws Exception {
        for (HgSubrepoLocation l : this.hgRepo.getSubrepositories()) {
            System.out.println(l.getLocation());
            System.out.println(l.getSource());
            System.out.println((Object)l.getType());
            System.out.println(l.isCommitted() ? l.getRevision() : "not yet committed");
            if (l.getType() != HgSubrepoLocation.Kind.Hg) continue;
            HgRepository r = l.getRepo();
            System.out.printf("%s (%s) has %d revisions\n", l.getLocation(), r.getLocation(), r.getChangelog().getLastRevision() + 1);
            if (r.getChangelog().getLastRevision() < 0) continue;
            HgChangelog.RawChangeset c = r.getChangelog().range(-3, -3).get(0);
            System.out.printf("TIP: %s %s '%s'\n", c.user(), c.dateString(), c.comment());
        }
    }

    private void testReadWorkingCopy() throws Exception {
        for (String fname : this.cmdLineOpts.getList("")) {
            HgDataFile fn = this.hgRepo.getFileNode(fname);
            ByteArrayChannel sink = new ByteArrayChannel();
            fn.workingCopy(sink);
            System.out.printf("%s: read %d bytes of working copy", fname, sink.toArray().length);
        }
    }

    private void testParents() throws Exception {
        Pair<Nodeid, Nodeid> wcParents = this.hgRepo.getWorkingCopyParents();
        ChangesetDumpHandler dump = new ChangesetDumpHandler(this.hgRepo);
        HgLogCommand cmd = new HgLogCommand(this.hgRepo);
        if (wcParents.hasFirst()) {
            cmd.changeset(wcParents.first()).execute(dump);
        }
        if (wcParents.hasSecond()) {
            cmd.changeset(wcParents.second()).execute(dump);
        }
        System.out.println("Branch:" + this.hgRepo.getWorkingCopyBranchName());
    }

    private void testEffectiveFileLog() throws Exception {
        for (String fname : this.cmdLineOpts.getList("")) {
            System.out.println(fname);
            long start = System.currentTimeMillis();
            HgDataFile fn = this.hgRepo.getFileNode(fname);
            if (fn.exists()) {
                fn.history(new HgChangelog.Inspector(){

                    @Override
                    public void next(int revisionNumber, Nodeid nodeid, HgChangelog.RawChangeset cset) {
                        System.out.printf("%d:%s\n", revisionNumber, nodeid);
                    }
                });
            }
            System.out.printf("Done: %d\n", System.currentTimeMillis() - start);
        }
    }

    private void testMergeState() throws Exception {
        HgMergeState mergeState = this.hgRepo.getMergeState();
        mergeState.refresh();
        System.out.printf("isMerging: %s, isStale: %s.\n", mergeState.isMerging(), mergeState.isStale());
        System.out.printf("P1:%s\nP2:%s\nState parent:%s\n", mergeState.getFirstParent().shortNotation(), mergeState.getSecondParent().shortNotation(), mergeState.getStateParent().shortNotation());
        for (HgMergeState.Entry e : mergeState.getConflicts()) {
            System.out.println((Object)((Object)e.getState()) + " " + e.getActualFile());
            System.out.println("p1:       " + Main.formatFileRevision(e.getFirstParent()));
            System.out.println("p2:       " + Main.formatFileRevision(e.getSecondParent()));
            System.out.println("ancestor: " + Main.formatFileRevision(e.getCommonAncestor()));
            System.out.println();
        }
    }

    private static String formatFileRevision(HgFileRevision r) throws Exception {
        ByteArrayChannel sink = new ByteArrayChannel();
        r.putContentTo(sink);
        return String.format("%s %s (%d bytes)", r.getPath(), r.getRevision(), sink.toArray().length);
    }

    private void testFileStatus() throws Exception {
        HgWorkingCopyStatusCollector wcsc = HgWorkingCopyStatusCollector.create(this.hgRepo, new PathGlobMatcher("mi**"));
        wcsc.walk(-2, new StatusDump());
    }

    private void dumpBranches() throws Exception {
        long start0 = System.currentTimeMillis();
        HgBranches b = this.hgRepo.getBranches();
        System.out.println("1:" + (System.currentTimeMillis() - start0));
        for (HgBranches.BranchInfo bi : b.getAllBranches()) {
            System.out.print(bi.getName());
            System.out.print(" ");
            System.out.print(bi.getHeads());
            if (bi.isClosed()) {
                System.out.print(" x ");
            }
            System.out.println();
        }
    }

    private void inflaterLengthException() throws Exception {
        HgDataFile f1 = this.hgRepo.getFileNode("src/com/tmate/hgkit/console/Bundle.java");
        HgDataFile f2 = this.hgRepo.getFileNode("test-repos.jar");
        System.out.println(f1.isCopy());
        System.out.println(f2.isCopy());
        ByteArrayChannel bac = new ByteArrayChannel();
        f1.content(1, bac);
        System.out.println(bac.toArray().length);
        bac = new ByteArrayChannel();
        f2.content(0, bac);
        System.out.println(bac.toArray().length);
    }

    private void dumpIgnored() throws HgInvalidControlFileException {
        String[] toCheck = new String[]{"design.txt", "src/com/tmate/hgkit/ll/Changelog.java", "src/Extras.java", "bin/com/tmate/hgkit/ll/Changelog.class"};
        HgIgnore ignore = this.hgRepo.getIgnore();
        int i = 0;
        while (i < toCheck.length) {
            System.out.println("Ignored " + toCheck[i] + ": " + ignore.isIgnored(Path.create(toCheck[i])));
            ++i;
        }
    }

    private void dumpDirstate() throws Exception {
        new HgInternals(this.hgRepo).getDirstate().walk(new DirstateDump());
        HgWorkingCopyStatusCollector wcc = HgWorkingCopyStatusCollector.create(this.hgRepo, new Path.Matcher.Any());
        wcc.getDirstate().walk(new HgDirstate.Inspector(){

            @Override
            public boolean next(HgDirstate.EntryKind kind, HgDirstate.Record entry) {
                System.out.printf("%s %s\n", new Object[]{kind, entry.name()});
                return true;
            }
        });
    }

    private void catCompleteHistory() throws Exception {
        DigestHelper dh = new DigestHelper();
        for (String fname : this.cmdLineOpts.getList("")) {
            System.out.println(fname);
            HgDataFile fn = this.hgRepo.getFileNode(fname);
            if (fn.exists()) {
                int total = fn.getRevisionCount();
                System.out.printf("Total revisions: %d\n", total);
                int i = 0;
                while (i < total) {
                    ByteArrayChannel sink = new ByteArrayChannel();
                    fn.content(i, sink);
                    System.out.println("==========>");
                    byte[] content = sink.toArray();
                    System.out.println(new String(content));
                    int[] parentRevisions = new int[2];
                    byte[] parent1 = new byte[20];
                    byte[] parent2 = new byte[20];
                    fn.parents(i, parentRevisions, parent1, parent2);
                    System.out.println(dh.sha1(parent1, parent2, content).asHexString());
                    ++i;
                }
                continue;
            }
            System.out.println(">>>Not found!");
        }
    }

    private void dumpCompleteManifestLow() throws Exception {
        this.hgRepo.getManifest().walk(0, -3, new ManifestDump());
    }

    private void dumpCompleteManifestHigh() throws Exception {
        new HgManifestCommand(this.hgRepo).dirs(true).execute(new HgManifestHandler(){

            @Override
            public void begin(Nodeid manifestRevision) {
                System.out.println(">> " + manifestRevision);
            }

            @Override
            public void dir(Path p) {
                System.out.println(p);
            }

            @Override
            public void file(HgFileRevision fileRevision) throws HgRuntimeException {
                System.out.print(fileRevision.getRevision());
                System.out.print("   ");
                System.out.printf("%s %s", fileRevision.getParents().first().shortNotation(), fileRevision.getParents().second().shortNotation());
                System.out.print("   ");
                System.out.println(fileRevision.getPath());
            }

            @Override
            public void end(Nodeid manifestRevision) {
                System.out.println();
            }
        });
    }

    private void bunchOfTests() throws Exception {
        StatusDump dump = new StatusDump();
        dump.showIgnored = false;
        dump.showClean = false;
        HgStatusCollector sc = new HgStatusCollector(this.hgRepo);
        System.out.printf("Status for changes between revision %d and %d:\n", 0, 3);
        sc.walk(0, 3, dump);
        System.out.println("\n\nSame, but sorted in the way hg status does:");
        HgStatusCollector.Record r = sc.status(0, 3);
        this.sortAndPrint('M', r.getModified(), null);
        this.sortAndPrint('A', r.getAdded(), null);
        this.sortAndPrint('R', r.getRemoved(), null);
        System.out.println("\n\nTry hg status --change <rev>:");
        sc.change(0, dump);
        System.out.println("\nStatus against working dir:");
        HgWorkingCopyStatusCollector wcc = new HgWorkingCopyStatusCollector(this.hgRepo);
        wcc.walk(-2, dump);
        System.out.println();
        System.out.printf("Manifest of the revision %d:\n", 3);
        this.hgRepo.getManifest().walk(3, 3, new ManifestDump());
        System.out.println();
        System.out.printf("\nStatus of working dir against %d:\n", 3);
        r = wcc.status(3);
        this.sortAndPrint('M', r.getModified(), null);
        this.sortAndPrint('A', r.getAdded(), r.getCopied());
        this.sortAndPrint('R', r.getRemoved(), null);
        this.sortAndPrint('?', r.getUnknown(), null);
        this.sortAndPrint('I', r.getIgnored(), null);
        this.sortAndPrint('C', r.getClean(), null);
        this.sortAndPrint('!', r.getMissing(), null);
    }

    private void sortAndPrint(char prefix, List<Path> ul, Map<Path, Path> copies) {
        ArrayList<Path> sortList = new ArrayList<Path>(ul);
        Collections.sort(sortList);
        for (Path s : sortList) {
            System.out.print(prefix);
            System.out.print(' ');
            System.out.println(s);
            if (copies == null || !copies.containsKey(s)) continue;
            System.out.println("  " + copies.get(s));
        }
    }

    private void testStatusInternals() throws HgException, HgRuntimeException {
        HgDataFile n = this.hgRepo.getFileNode(Path.create("design.txt"));
        String[] stringArray = new String[]{"011dfd44417c72bd9e54cf89b82828f661b700ed", "e5529faa06d53e06a816e56d218115b42782f1ba", "c18e7111f1fc89a80a00f6a39d51288289a382fc"};
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String s = stringArray[n3];
            byte[] b = s.getBytes();
            Nodeid nid = Nodeid.fromAscii(b, 0, b.length);
            System.out.println(String.valueOf(s) + " : " + n.getLength(nid));
            ++n3;
        }
    }

    static void force_gc() {
        Runtime.getRuntime().runFinalization();
        Runtime.getRuntime().gc();
        Thread.yield();
        Runtime.getRuntime().runFinalization();
        Runtime.getRuntime().gc();
        Thread.yield();
    }

    static class DirstateDump
    implements HgDirstate.Inspector {
        private final char[] x = new char[]{'n', 'a', 'r', 'm'};

        DirstateDump() {
        }

        @Override
        public boolean next(HgDirstate.EntryKind kind, HgDirstate.Record entry) {
            System.out.printf("%c %3o%6d %30tc\t\t%s", Character.valueOf(this.x[kind.ordinal()]), entry.mode(), entry.size(), (long)entry.modificationTime() * 1000L, entry.name());
            if (entry.copySource() != null) {
                System.out.printf(" --> %s", entry.copySource());
            }
            System.out.println();
            return true;
        }
    }

    public static final class ManifestDump
    implements HgManifest.Inspector {
        @Override
        public boolean begin(int manifestRevision, Nodeid nid, int changelogRevision) {
            System.out.printf("%d : %s\n", manifestRevision, nid);
            return true;
        }

        @Override
        public boolean next(Nodeid nid, Path fname, HgManifest.Flags flags) {
            System.out.println(nid + "\t" + fname + "\t\t" + (Object)((Object)flags));
            return true;
        }

        @Override
        public boolean end(int revision) {
            System.out.println();
            return true;
        }
    }

    private static class StatusDump
    implements HgStatusInspector {
        public boolean hideStatusPrefix = false;
        public boolean showCopied = true;
        public boolean showIgnored = true;
        public boolean showClean = true;

        private StatusDump() {
        }

        @Override
        public void modified(Path fname) {
            this.print('M', fname);
        }

        @Override
        public void added(Path fname) {
            this.print('A', fname);
        }

        @Override
        public void copied(Path fnameOrigin, Path fnameAdded) {
            this.added(fnameAdded);
            if (this.showCopied) {
                this.print(' ', fnameOrigin);
            }
        }

        @Override
        public void removed(Path fname) {
            this.print('R', fname);
        }

        @Override
        public void clean(Path fname) {
            if (this.showClean) {
                this.print('C', fname);
            }
        }

        @Override
        public void missing(Path fname) {
            this.print('!', fname);
        }

        @Override
        public void unknown(Path fname) {
            this.print('?', fname);
        }

        @Override
        public void ignored(Path fname) {
            if (this.showIgnored) {
                this.print('I', fname);
            }
        }

        @Override
        public void invalid(Path fname, Exception ex) {
            System.out.printf("FAILURE: %s\n", fname);
            ex.printStackTrace(System.out);
        }

        private void print(char status, Path fname) {
            if (!this.hideStatusPrefix) {
                System.out.print(status);
                System.out.print(' ');
            }
            System.out.println(fname);
        }
    }
}

