/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.console;

import org.tmatesoft.hg.console.Options;
import org.tmatesoft.hg.core.HgFileRevision;
import org.tmatesoft.hg.core.HgManifestCommand;
import org.tmatesoft.hg.core.HgManifestHandler;
import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.repo.HgInvalidControlFileException;
import org.tmatesoft.hg.repo.HgInvalidRevisionException;
import org.tmatesoft.hg.repo.HgManifest;
import org.tmatesoft.hg.repo.HgRepository;
import org.tmatesoft.hg.repo.HgRuntimeException;
import org.tmatesoft.hg.util.Path;

public class Manifest {
    public static void main(String[] args) throws Exception {
        Options cmdLineOpts = Options.parse(args, Options.asSet("--debug", "-v", "--verbose"));
        HgRepository hgRepo = cmdLineOpts.findRepository();
        if (hgRepo.isInvalid()) {
            System.err.printf("Can't find repository in: %s\n", hgRepo.getLocation());
            return;
        }
        final boolean debug = cmdLineOpts.getBoolean("--debug");
        final boolean verbose = cmdLineOpts.getBoolean("-v", "--verbose");
        HgManifestHandler h = new HgManifestHandler(){

            @Override
            public void begin(Nodeid manifestRevision) {
            }

            @Override
            public void dir(Path p) {
            }

            @Override
            public void file(HgFileRevision fileRevision) throws HgRuntimeException {
                try {
                    if (debug) {
                        System.out.print(fileRevision.getRevision());
                    }
                    if (debug || verbose) {
                        HgManifest.Flags flags = fileRevision.getFileFlags();
                        String s = flags == HgManifest.Flags.RegularFile ? Integer.toOctalString(420) : (flags == HgManifest.Flags.Exec ? Integer.toOctalString(493) : (flags == HgManifest.Flags.Link ? "lnk" : String.valueOf((Object)flags)));
                        System.out.printf(" %s   ", s);
                    }
                    System.out.println(fileRevision.getPath());
                }
                catch (HgInvalidControlFileException e) {
                    e.printStackTrace();
                }
                catch (HgInvalidRevisionException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void end(Nodeid manifestRevision) {
            }
        };
        int rev = cmdLineOpts.getSingleInt(-3, "-r", "--rev");
        new HgManifestCommand(hgRepo).dirs(false).changeset(rev).execute(h);
    }
}

