/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.console;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.tmatesoft.hg.repo.HgLookup;
import org.tmatesoft.hg.repo.HgRepository;

class Options {
    public final Map<String, List<String>> opt2values = new HashMap<String, List<String>>();

    Options() {
    }

    public boolean getBoolean(String ... aliases) {
        return this.getBoolean(false, aliases);
    }

    public boolean getBoolean(boolean def, String ... aliases) {
        String[] stringArray = aliases;
        int n = aliases.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (this.opt2values.containsKey(s)) {
                return true;
            }
            ++n2;
        }
        return def;
    }

    public String getSingle(String ... aliases) {
        String rv = null;
        String[] stringArray = aliases;
        int n = aliases.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            List<String> values = this.opt2values.get(s);
            if (values != null && values.size() > 0) {
                rv = values.get(values.size() - 1);
            }
            ++n2;
        }
        return rv;
    }

    public int getSingleInt(int def, String ... aliases) {
        String r = this.getSingle(aliases);
        if (r == null) {
            return def;
        }
        return Integer.parseInt(r);
    }

    public List<String> getList(String ... aliases) {
        LinkedList<String> rv = new LinkedList<String>();
        String[] stringArray = aliases;
        int n = aliases.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            List<String> values = this.opt2values.get(s);
            if (values != null) {
                rv.addAll(values);
            }
            ++n2;
        }
        return rv;
    }

    public HgRepository findRepository() throws Exception {
        String repoLocation = this.getSingle("-R", "--repository");
        if (repoLocation != null) {
            return new HgLookup().detect(repoLocation);
        }
        return new HgLookup().detectFromWorkingDir();
    }

    public static Options parse(String[] commandLineArgs, Set<String> flagOptions) {
        Options rv = new Options();
        List<String> values = new LinkedList<String>();
        rv.opt2values.put("", values);
        String[] stringArray = commandLineArgs;
        int n = commandLineArgs.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (arg.charAt(0) == '-') {
                if (arg.length() == 1) {
                    throw new IllegalArgumentException("Bad option: -");
                }
                if (flagOptions.contains(arg)) {
                    rv.opt2values.put(arg, Collections.emptyList());
                    values = rv.opt2values.get("");
                } else {
                    values = rv.opt2values.get(arg);
                    if (values == null) {
                        values = new LinkedList();
                        rv.opt2values.put(arg, values);
                    }
                }
            } else {
                values.add(arg);
                values = rv.opt2values.get("");
            }
            ++n2;
        }
        return rv;
    }

    public static Set<String> asSet(String ... ss) {
        TreeSet<String> rv = new TreeSet<String>();
        String[] stringArray = ss;
        int n = ss.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            rv.add(s);
            ++n2;
        }
        return rv;
    }
}

