/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.console;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.tmatesoft.hg.console.ChangesetDumpHandler;
import org.tmatesoft.hg.console.Options;
import org.tmatesoft.hg.core.HgOutgoingCommand;
import org.tmatesoft.hg.core.HgRepoFacade;
import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.repo.HgLookup;
import org.tmatesoft.hg.repo.HgRemoteRepository;

public class Outgoing {
    public static void main(String[] args) throws Exception {
        HgRepoFacade hgRepo = new HgRepoFacade();
        Options cmdLineOpts = Options.parse(args, Collections.emptySet());
        if (!hgRepo.init(cmdLineOpts.findRepository())) {
            System.err.printf("Can't find repository in: %s\n", hgRepo.getRepository().getLocation());
            return;
        }
        HgRemoteRepository hgRemote = new HgLookup().detectRemote(cmdLineOpts.getSingle(""), hgRepo.getRepository());
        if (hgRemote.isInvalid()) {
            System.err.printf("Remote repository %s is not valid", hgRemote.getLocation());
            return;
        }
        HgOutgoingCommand cmd = hgRepo.createOutgoingCommand();
        cmd.against(hgRemote);
        List<Nodeid> result = cmd.executeLite();
        Outgoing.dump("Lite", result);
        System.out.println("Full");
        ChangesetDumpHandler h = new ChangesetDumpHandler(hgRepo.getRepository());
        h.complete(cmdLineOpts.getBoolean("--debug")).verbose(cmdLineOpts.getBoolean("-v", "--verbose"));
        cmd.executeFull(h);
        h.done();
    }

    static void dump(String s, Collection<Nodeid> c) {
        System.out.println(s);
        for (Nodeid n : c) {
            System.out.println(n);
        }
    }
}

