/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.console;

import java.util.Collections;
import org.tmatesoft.hg.console.Options;
import org.tmatesoft.hg.core.HgPushCommand;
import org.tmatesoft.hg.core.HgRepoFacade;
import org.tmatesoft.hg.repo.HgLookup;
import org.tmatesoft.hg.repo.HgRemoteRepository;

public class Push {
    public static void main(String[] args) throws Exception {
        HgRepoFacade hgRepo = new HgRepoFacade();
        Options cmdLineOpts = Options.parse(args, Collections.emptySet());
        if (!hgRepo.init(cmdLineOpts.findRepository())) {
            System.err.printf("Can't find repository in: %s\n", hgRepo.getRepository().getLocation());
            return;
        }
        HgRemoteRepository hgRemote = new HgLookup().detectRemote(cmdLineOpts.getSingle(""), hgRepo.getRepository());
        if (hgRemote.isInvalid()) {
            System.err.printf("Remote repository %s is not valid", hgRemote.getLocation());
            return;
        }
        HgPushCommand cmd = hgRepo.createPushCommand();
        cmd.destination(hgRemote);
        cmd.execute();
        System.out.printf("Added %d changesets\n", cmd.getPushedRevisions().size());
    }
}

