/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.console;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import java.util.zip.InflaterInputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.tmatesoft.hg.internal.BasicSessionContext;
import org.tmatesoft.hg.internal.ConfigFile;

public class Remote {
    public static void main(String[] args) throws Exception {
        ConfigFile cfg = new ConfigFile(new BasicSessionContext(null));
        cfg.addLocation(new File(System.getProperty("user.home"), ".hgrc"));
        String svnkitServer = cfg.getSection("paths").get("svnkit");
        URL url = new URL(String.valueOf(svnkitServer) + "?cmd=changegroup&roots=71ddbf8603e8e09d54ac9c5fe4bb5ae824589f1d");
        SSLContext sslContext = SSLContext.getInstance("SSL");
        Preferences tempNode = Preferences.userRoot().node("xxx");
        tempNode.putByteArray("xxx", url.getUserInfo().getBytes());
        String authInfo = tempNode.get("xxx", null);
        tempNode.removeNode();
        class TrustEveryone
        implements X509TrustManager {
            TrustEveryone() {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                System.out.println("checkClientTrusted " + authType);
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                System.out.println("checkServerTrusted" + authType);
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }
        sslContext.init(null, new TrustManager[]{new TrustEveryone()}, null);
        HttpsURLConnection urlConnection = (HttpsURLConnection)url.openConnection();
        urlConnection.setRequestProperty("User-Agent", "jhg/0.1.0");
        urlConnection.setRequestProperty("Accept", "application/mercurial-0.1");
        urlConnection.setRequestProperty("Authorization", "Basic " + authInfo);
        urlConnection.setSSLSocketFactory(sslContext.getSocketFactory());
        urlConnection.connect();
        System.out.println("Query:" + url.getQuery());
        System.out.println("Response headers:");
        Map<String, List<String>> headerFields = urlConnection.getHeaderFields();
        for (String s : headerFields.keySet()) {
            System.out.printf("%s: %s\n", s, urlConnection.getHeaderField(s));
        }
        System.out.printf("Content type is %s and its length is %d\n", urlConnection.getContentType(), urlConnection.getContentLength());
        InputStream is = urlConnection.getInputStream();
        Remote.writeBundle(is, false, "HG10GZ");
        urlConnection.disconnect();
    }

    private static void dump(InputStream is, int limit) throws IOException {
        int b;
        while ((b = is.read()) != -1) {
            System.out.print((char)b);
            if (limit != -1 && --limit < 0) break;
        }
        System.out.println();
    }

    private static void writeBundle(InputStream is, boolean decompress, String header) throws IOException {
        int r;
        InputStream zipStream = decompress ? new InflaterInputStream(is) : is;
        File tf = File.createTempFile("hg-bundle-", null);
        FileOutputStream fos = new FileOutputStream(tf);
        fos.write(header.getBytes());
        byte[] buf = new byte[8192];
        while ((r = zipStream.read(buf)) != -1) {
            fos.write(buf, 0, r);
        }
        fos.close();
        zipStream.close();
        System.out.println(tf);
    }
}

