/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.console;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.tmatesoft.hg.console.Options;
import org.tmatesoft.hg.core.HgRepoFacade;
import org.tmatesoft.hg.core.HgStatus;
import org.tmatesoft.hg.core.HgStatusCommand;
import org.tmatesoft.hg.core.HgStatusHandler;
import org.tmatesoft.hg.util.Outcome;
import org.tmatesoft.hg.util.Path;

public class Status {
    public static void main(String[] args) throws Exception {
        HgRepoFacade hgRepo = new HgRepoFacade();
        Set<String> flagOpts = Options.asSet("-A", "--all", "-m", "--modified", "-a", "--added", "-r", "--removed", "--d", "--deleted", "-u", "--unknown", "-c", "--clean", "-i", "--ignored", "-n", "--no-status", "-C", "--copies");
        Options cmdLineOpts = Options.parse(args, flagOpts);
        if (!hgRepo.init(cmdLineOpts.findRepository())) {
            System.err.printf("Can't find repository in: %s\n", hgRepo.getRepository().getLocation());
            return;
        }
        HgStatusCommand cmd = hgRepo.createStatusCommand();
        if (cmdLineOpts.getBoolean("-A", "--all")) {
            cmd.all();
        } else {
            cmd.modified(cmdLineOpts.getBoolean(true, "-m", "--modified"));
            cmd.added(cmdLineOpts.getBoolean(true, "-a", "--added"));
            cmd.removed(cmdLineOpts.getBoolean(true, "-r", "--removed"));
            cmd.deleted(cmdLineOpts.getBoolean(true, "-d", "--deleted"));
            cmd.unknown(cmdLineOpts.getBoolean(true, "-u", "--unknonwn"));
            cmd.clean(cmdLineOpts.getBoolean("-c", "--clean"));
            cmd.ignored(cmdLineOpts.getBoolean("-i", "--ignored"));
        }
        boolean noStatusPrefix = cmdLineOpts.getBoolean("-n", "--no-status");
        boolean showCopies = cmdLineOpts.getBoolean("-C", "--copies");
        class StatusHandler
        implements HgStatusHandler {
            final EnumMap<HgStatus.Kind, List<Path>> data = new EnumMap(HgStatus.Kind.class);
            final Map<Path, Path> copies;
            private final /* synthetic */ boolean val$showCopies;
            private final /* synthetic */ boolean val$noStatusPrefix;

            StatusHandler(boolean bl, boolean bl2) {
                this.val$showCopies = bl;
                this.val$noStatusPrefix = bl2;
                this.copies = bl ? new HashMap() : null;
            }

            @Override
            public void status(HgStatus s) {
                List<Path> l = this.data.get((Object)s.getKind());
                if (l == null) {
                    l = new LinkedList<Path>();
                    this.data.put(s.getKind(), l);
                }
                l.add(s.getPath());
                if (s.isCopy() && this.val$showCopies) {
                    this.copies.put(s.getPath(), s.getOriginalPath());
                }
            }

            @Override
            public void error(Path file, Outcome s) {
                System.out.printf("FAILURE: %s %s\n", s.getMessage(), file);
                s.getException().printStackTrace(System.out);
            }

            public void dump() {
                this.sortAndPrint('M', this.data.get((Object)HgStatus.Kind.Modified), null);
                this.sortAndPrint('A', this.data.get((Object)HgStatus.Kind.Added), this.copies);
                this.sortAndPrint('R', this.data.get((Object)HgStatus.Kind.Removed), null);
                this.sortAndPrint('?', this.data.get((Object)HgStatus.Kind.Unknown), null);
                this.sortAndPrint('I', this.data.get((Object)HgStatus.Kind.Ignored), null);
                this.sortAndPrint('C', this.data.get((Object)HgStatus.Kind.Clean), null);
                this.sortAndPrint('!', this.data.get((Object)HgStatus.Kind.Missing), null);
            }

            private void sortAndPrint(char prefix, List<Path> ul, Map<Path, Path> copies) {
                if (ul == null) {
                    return;
                }
                ArrayList<Path> sortList = new ArrayList<Path>(ul);
                Collections.sort(sortList);
                for (Path s : sortList) {
                    if (!this.val$noStatusPrefix) {
                        System.out.print(prefix);
                        System.out.print(' ');
                    }
                    System.out.println(s);
                    if (copies == null || !copies.containsKey(s)) continue;
                    System.out.println("  " + copies.get(s));
                }
            }
        }
        StatusHandler statusHandler = new StatusHandler(showCopies, noStatusPrefix);
        int changeRev = cmdLineOpts.getSingleInt(Integer.MIN_VALUE, "--change");
        if (changeRev != Integer.MIN_VALUE) {
            cmd.change(changeRev);
        } else {
            List<String> revisions = cmdLineOpts.getList("--rev");
            int size = revisions.size();
            if (size > 1) {
                cmd.base(Integer.parseInt(revisions.get(size - 2))).revision(Integer.parseInt(revisions.get(size - 1)));
            } else if (size > 0) {
                cmd.base(Integer.parseInt(revisions.get(0)));
            }
        }
        cmd.execute(statusHandler);
        statusHandler.dump();
    }
}

