/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.console;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.TreeSet;
import org.tmatesoft.hg.console.Options;
import org.tmatesoft.hg.repo.HgChangelog;
import org.tmatesoft.hg.repo.HgRepository;
import org.tmatesoft.hg.repo.HgTags;

public class Tags {
    public static void main(String[] args) throws Exception {
        int x;
        Options cmdLineOpts = Options.parse(args, Collections.emptySet());
        HgRepository hgRepo = cmdLineOpts.findRepository();
        if (hgRepo.isInvalid()) {
            System.err.printf("Can't find repository in: %s\n", hgRepo.getLocation());
            return;
        }
        HgTags tags = hgRepo.getTags();
        HgChangelog clog = hgRepo.getChangelog();
        final HashMap<HgTags.TagInfo, Integer> ti2index = new HashMap<HgTags.TagInfo, Integer>();
        TreeSet<HgTags.TagInfo> sorted = new TreeSet<HgTags.TagInfo>(new Comparator<HgTags.TagInfo>(){

            @Override
            public int compare(HgTags.TagInfo o1, HgTags.TagInfo o2) {
                int x2;
                int x1 = (Integer)ti2index.get(o1);
                return x1 < (x2 = ((Integer)ti2index.get(o2)).intValue()) ? 1 : -1;
            }
        });
        for (HgTags.TagInfo ti : tags.getAllTags().values()) {
            x = clog.getRevisionIndex(ti.revision());
            ti2index.put(ti, x);
            sorted.add(ti);
        }
        for (HgTags.TagInfo ti : sorted) {
            x = (Integer)ti2index.get(ti);
            System.out.printf("%-30s%8d:%s\n", ti.name(), x, ti.revision().shortNotation());
        }
    }
}

