/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.core;

import java.util.Set;
import org.tmatesoft.hg.core.HgCallbackTargetException;
import org.tmatesoft.hg.core.HgChangeset;
import org.tmatesoft.hg.core.HgChangesetHandler;
import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.internal.Lifecycle;
import org.tmatesoft.hg.internal.LifecycleBridge;
import org.tmatesoft.hg.internal.PathPool;
import org.tmatesoft.hg.repo.HgChangelog;
import org.tmatesoft.hg.repo.HgParentChildMap;
import org.tmatesoft.hg.repo.HgRepository;
import org.tmatesoft.hg.repo.HgRuntimeException;
import org.tmatesoft.hg.repo.HgStatusCollector;
import org.tmatesoft.hg.util.Adaptable;
import org.tmatesoft.hg.util.CancelSupport;
import org.tmatesoft.hg.util.CancelledException;
import org.tmatesoft.hg.util.PathRewrite;
import org.tmatesoft.hg.util.ProgressSupport;

class ChangesetTransformer
implements HgChangelog.Inspector,
Adaptable {
    private final HgChangesetHandler handler;
    private final LifecycleBridge lifecycleBridge;
    private final Transformation t;
    private Set<String> branches;
    private HgCallbackTargetException failure;

    public ChangesetTransformer(HgRepository hgRepo, HgChangesetHandler delegate, HgParentChildMap<HgChangelog> pw, ProgressSupport ps, CancelSupport cs) {
        if (hgRepo == null || delegate == null) {
            throw new IllegalArgumentException();
        }
        if (ps == null || cs == null) {
            throw new IllegalArgumentException();
        }
        HgStatusCollector statusCollector = new HgStatusCollector(hgRepo);
        this.t = new Transformation(statusCollector, pw);
        this.handler = delegate;
        this.lifecycleBridge = new LifecycleBridge(ps, cs);
    }

    @Override
    public void next(int revisionNumber, Nodeid nodeid, HgChangelog.RawChangeset cset) throws HgRuntimeException {
        if (this.branches != null && !this.branches.contains(cset.branch())) {
            return;
        }
        HgChangeset changeset = this.t.handle(revisionNumber, nodeid, cset);
        try {
            this.handler.cset(changeset);
            this.lifecycleBridge.nextStep();
        }
        catch (HgCallbackTargetException ex) {
            this.failure = ex.setRevision(nodeid).setRevisionIndex(revisionNumber);
            this.lifecycleBridge.stop();
        }
    }

    public void checkFailure() throws HgCallbackTargetException, CancelledException {
        if (this.failure != null) {
            HgCallbackTargetException toThrow = this.failure;
            throw toThrow;
        }
        if (this.lifecycleBridge.isCancelled()) {
            CancelledException toThrow = this.lifecycleBridge.getCancelOrigin();
            assert (toThrow != null);
            throw toThrow;
        }
    }

    public void limitBranches(Set<String> branches) {
        this.branches = branches;
    }

    @Override
    public <T> T getAdapter(Class<T> adapterClass) {
        if (adapterClass == Lifecycle.class) {
            return adapterClass.cast(this.lifecycleBridge);
        }
        return Adaptable.Factory.getAdapter(this.handler, adapterClass, null);
    }

    static class Transformation {
        private final HgChangeset changeset;

        public Transformation(HgStatusCollector statusCollector, HgParentChildMap<HgChangelog> pw) {
            PathPool pp = new PathPool(new PathRewrite.Empty());
            statusCollector.setPathPool(pp);
            this.changeset = new HgChangeset(statusCollector, pp);
            this.changeset.setParentHelper(pw);
        }

        HgChangeset handle(int revisionNumber, Nodeid nodeid, HgChangelog.RawChangeset cset) {
            this.changeset.init(revisionNumber, nodeid, cset);
            return this.changeset;
        }
    }
}

