/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.core;

import java.util.LinkedHashSet;
import org.tmatesoft.hg.core.HgAbstractCommand;
import org.tmatesoft.hg.core.HgException;
import org.tmatesoft.hg.core.HgLibraryFailureException;
import org.tmatesoft.hg.core.HgRepositoryLockException;
import org.tmatesoft.hg.internal.COWTransaction;
import org.tmatesoft.hg.internal.DirstateBuilder;
import org.tmatesoft.hg.internal.DirstateReader;
import org.tmatesoft.hg.internal.Internals;
import org.tmatesoft.hg.internal.Transaction;
import org.tmatesoft.hg.repo.HgManifest;
import org.tmatesoft.hg.repo.HgRepository;
import org.tmatesoft.hg.repo.HgRepositoryLock;
import org.tmatesoft.hg.repo.HgRuntimeException;
import org.tmatesoft.hg.util.CancelSupport;
import org.tmatesoft.hg.util.CancelledException;
import org.tmatesoft.hg.util.Path;
import org.tmatesoft.hg.util.ProgressSupport;

public class HgAddRemoveCommand
extends HgAbstractCommand<HgAddRemoveCommand> {
    private final HgRepository repo;
    private final LinkedHashSet<Path> toAdd;
    private final LinkedHashSet<Path> toRemove;

    public HgAddRemoveCommand(HgRepository hgRepo) {
        this.repo = hgRepo;
        this.toAdd = new LinkedHashSet();
        this.toRemove = new LinkedHashSet();
    }

    public HgAddRemoveCommand add(Path ... paths) {
        if (paths == null) {
            throw new IllegalArgumentException();
        }
        Path[] pathArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            Path p = pathArray[n2];
            this.toRemove.remove(p);
            this.toAdd.add(p);
            ++n2;
        }
        return this;
    }

    public HgAddRemoveCommand remove(Path ... paths) {
        if (paths == null) {
            throw new IllegalArgumentException();
        }
        Path[] pathArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            Path p = pathArray[n2];
            this.toAdd.remove(p);
            this.toRemove.add(p);
            ++n2;
        }
        return this;
    }

    public HgAddRemoveCommand addAll() {
        throw Internals.notImplemented();
    }

    public HgAddRemoveCommand forget(Path path) {
        throw Internals.notImplemented();
    }

    public void execute() throws HgException, HgRepositoryLockException, CancelledException {
        HgRepositoryLock wdLock = this.repo.getWorkingDirLock();
        wdLock.acquire();
        try {
            try {
                ProgressSupport progress = this.getProgressSupport(null);
                CancelSupport cancellation = this.getCancelSupport(null, true);
                cancellation.checkCancelled();
                progress.start(2 + this.toAdd.size() + this.toRemove.size());
                Internals implRepo = Internals.getInstance(this.repo);
                DirstateBuilder dirstateBuilder = new DirstateBuilder(implRepo);
                dirstateBuilder.fillFrom(new DirstateReader(implRepo, new Path.SimpleSource()));
                progress.worked(1);
                cancellation.checkCancelled();
                for (Path p : this.toAdd) {
                    dirstateBuilder.recordAdded(p, HgManifest.Flags.RegularFile, -1);
                    progress.worked(1);
                    cancellation.checkCancelled();
                }
                for (Path p : this.toRemove) {
                    dirstateBuilder.recordRemoved(p);
                    progress.worked(1);
                    cancellation.checkCancelled();
                }
                COWTransaction.Factory trFactory = new COWTransaction.Factory();
                Transaction tr = trFactory.create(this.repo);
                try {
                    dirstateBuilder.serialize(tr);
                    tr.commit();
                }
                catch (RuntimeException ex) {
                    tr.rollback();
                    throw ex;
                }
                catch (HgException ex) {
                    tr.rollback();
                    throw ex;
                }
                progress.worked(1);
                progress.done();
            }
            catch (HgRuntimeException ex) {
                throw new HgLibraryFailureException(ex);
            }
        }
        finally {
            wdLock.release();
        }
    }
}

