/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.core;

import org.tmatesoft.hg.core.HgAbstractCommand;
import org.tmatesoft.hg.core.HgBadArgumentException;
import org.tmatesoft.hg.core.HgCallbackTargetException;
import org.tmatesoft.hg.core.HgDiffCommand;
import org.tmatesoft.hg.core.HgException;
import org.tmatesoft.hg.core.HgLibraryFailureException;
import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.internal.CsetParamKeeper;
import org.tmatesoft.hg.internal.ForwardAnnotateInspector;
import org.tmatesoft.hg.repo.HgDataFile;
import org.tmatesoft.hg.repo.HgRepository;
import org.tmatesoft.hg.repo.HgRuntimeException;
import org.tmatesoft.hg.util.CancelSupport;
import org.tmatesoft.hg.util.CancelledException;
import org.tmatesoft.hg.util.Path;
import org.tmatesoft.hg.util.ProgressSupport;

public class HgAnnotateCommand
extends HgAbstractCommand<HgAnnotateCommand> {
    private final HgRepository repo;
    private final CsetParamKeeper annotateRevision;
    private Path file;
    private boolean followRename;

    public HgAnnotateCommand(HgRepository hgRepo) {
        this.repo = hgRepo;
        this.annotateRevision = new CsetParamKeeper(this.repo);
        this.annotateRevision.doSet(-3);
    }

    public HgAnnotateCommand changeset(Nodeid nodeid) throws HgBadArgumentException {
        this.annotateRevision.set(nodeid);
        return this;
    }

    public HgAnnotateCommand changeset(int changelogRevIndex) throws HgBadArgumentException {
        this.annotateRevision.set(changelogRevIndex);
        return this;
    }

    public HgAnnotateCommand file(Path filePath) {
        return this.file(filePath, true);
    }

    public HgAnnotateCommand file(Path filePath, boolean followCopyRename) {
        this.file = filePath;
        this.followRename = followCopyRename;
        return this;
    }

    public HgAnnotateCommand file(HgDataFile fileNode, boolean followCopyRename) {
        return this.file(fileNode.getPath(), followCopyRename);
    }

    public void execute(Inspector inspector) throws HgException, HgCallbackTargetException, CancelledException {
        if (inspector == null) {
            throw new IllegalArgumentException();
        }
        if (this.file == null) {
            throw new HgBadArgumentException("Command needs file argument", null);
        }
        ProgressSupport progress = this.getProgressSupport(inspector);
        CancelSupport cancellation = this.getCancelSupport(inspector, true);
        cancellation.checkCancelled();
        progress.start(200);
        try {
            HgDataFile df = this.repo.getFileNode(this.file);
            if (!df.exists()) {
                return;
            }
            int changesetStart = this.followRename ? 0 : df.getChangesetRevisionIndex(0);
            int annotateRevIndex = this.annotateRevision.get(-3);
            HgDiffCommand cmd = new HgDiffCommand(this.repo).file(df);
            cmd.range(changesetStart, annotateRevIndex);
            cmd.set(cancellation);
            cmd.set(new ProgressSupport.Sub(progress, 100));
            ForwardAnnotateInspector ai = new ForwardAnnotateInspector();
            cmd.order(ai.iterateDirection());
            cmd.executeAnnotate(ai);
            cancellation.checkCancelled();
            Nodeid fileRev = this.repo.getManifest().getFileRevision(annotateRevIndex, df.getPath());
            int lastCsetWithFileChange = fileRev != null ? df.getChangesetRevisionIndex(df.getRevisionIndex(fileRev)) : annotateRevIndex;
            ai.report(lastCsetWithFileChange, inspector, new ProgressSupport.Sub(progress, 100), cancellation);
        }
        catch (HgRuntimeException ex) {
            throw new HgLibraryFailureException(ex);
        }
        progress.done();
    }

    public static interface Inspector {
        public void next(LineInfo var1) throws HgCallbackTargetException;
    }

    public static interface LineInfo {
        public int getLineNumber();

        public int getOriginLineNumber();

        public int getChangesetIndex();

        public byte[] getContent();
    }
}

