/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.core;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.tmatesoft.hg.core.HgAbstractCommand;
import org.tmatesoft.hg.core.HgBadArgumentException;
import org.tmatesoft.hg.core.HgChangesetFileSneaker;
import org.tmatesoft.hg.core.HgException;
import org.tmatesoft.hg.core.HgFileRevision;
import org.tmatesoft.hg.core.HgLibraryFailureException;
import org.tmatesoft.hg.core.HgPathNotFoundException;
import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.internal.CsetParamKeeper;
import org.tmatesoft.hg.repo.HgDataFile;
import org.tmatesoft.hg.repo.HgInternals;
import org.tmatesoft.hg.repo.HgRepository;
import org.tmatesoft.hg.repo.HgRuntimeException;
import org.tmatesoft.hg.util.Adaptable;
import org.tmatesoft.hg.util.ByteChannel;
import org.tmatesoft.hg.util.CancelSupport;
import org.tmatesoft.hg.util.CancelledException;
import org.tmatesoft.hg.util.Outcome;
import org.tmatesoft.hg.util.Path;

public class HgCatCommand
extends HgAbstractCommand<HgCatCommand> {
    private final HgRepository repo;
    private Path file;
    private int revisionIndex = -3;
    private Nodeid revision;
    private Nodeid cset;

    public HgCatCommand(HgRepository hgRepo) {
        this.repo = hgRepo;
    }

    public HgCatCommand file(Path fname) {
        if (fname == null || fname.isDirectory()) {
            throw new IllegalArgumentException(String.valueOf(fname));
        }
        this.file = fname;
        return this;
    }

    public HgCatCommand revision(int fileRevisionIndex) {
        if (HgInternals.wrongRevisionIndex(fileRevisionIndex)) {
            throw new IllegalArgumentException(String.valueOf(fileRevisionIndex));
        }
        this.revisionIndex = fileRevisionIndex;
        this.revision = null;
        this.cset = null;
        return this;
    }

    public HgCatCommand revision(Nodeid nodeid) {
        if (nodeid != null && nodeid.isNull()) {
            nodeid = null;
        }
        this.revision = nodeid;
        this.revisionIndex = Integer.MIN_VALUE;
        this.cset = null;
        return this;
    }

    public HgCatCommand revision(HgFileRevision fileRev) {
        return this.file(fileRev.getPath()).revision(fileRev.getRevision());
    }

    public HgCatCommand changeset(Nodeid nodeid) {
        this.revisionIndex = Integer.MIN_VALUE;
        this.revision = null;
        this.cset = nodeid;
        return this;
    }

    public HgCatCommand changeset(int revisionIndex) throws HgBadArgumentException {
        int ri = new CsetParamKeeper(this.repo).set(revisionIndex).get();
        return this.changeset(this.repo.getChangelog().getRevision(ri));
    }

    public void execute(ByteChannel sink) throws HgException, CancelledException {
        if (this.revisionIndex == Integer.MIN_VALUE && this.revision == null && this.cset == null) {
            throw new IllegalArgumentException("File revision, corresponing local number, or a changset nodeid shall be specified");
        }
        if (this.file == null) {
            throw new IllegalArgumentException("Name of the file is missing");
        }
        if (sink == null) {
            throw new IllegalArgumentException("Need an output channel");
        }
        try {
            ByteChannel sinkWrap;
            int revToExtract;
            HgDataFile dataFile = this.repo.getFileNode(this.file);
            if (!dataFile.exists()) {
                throw new HgPathNotFoundException(String.format("File %s not found in the repository", this.file), this.file);
            }
            if (this.cset != null) {
                HgChangesetFileSneaker fsneaker = new HgChangesetFileSneaker(this.repo);
                fsneaker.changeset(this.cset).followRenames(true);
                Outcome o = fsneaker.check(this.file);
                if (!o.isOk()) {
                    if (o.getException() instanceof HgRuntimeException) {
                        throw new HgLibraryFailureException(o.getMessage(), (HgRuntimeException)o.getException());
                    }
                    throw new HgBadArgumentException(o.getMessage(), o.getException()).setFileName(this.file).setRevision(this.cset);
                }
                if (!fsneaker.exists()) {
                    throw new HgPathNotFoundException(o.getMessage(), this.file).setRevision(this.cset);
                }
                Nodeid toExtract = fsneaker.revision();
                if (fsneaker.hasAnotherName()) {
                    dataFile = this.repo.getFileNode(fsneaker.filename());
                }
                revToExtract = dataFile.getRevisionIndex(toExtract);
            } else {
                revToExtract = this.revision != null ? dataFile.getRevisionIndex(this.revision) : this.revisionIndex;
            }
            if (this.getCancelSupport(null, false) == null) {
                sinkWrap = sink;
            } else {
                CancelSupport cancelHelper = this.getCancelSupport(sink, true);
                cancelHelper.checkCancelled();
                sinkWrap = new ByteChannelProxy(sink, cancelHelper);
            }
            dataFile.contentWithFilters(revToExtract, sinkWrap);
        }
        catch (HgRuntimeException ex) {
            throw new HgLibraryFailureException(ex);
        }
    }

    private static class ByteChannelProxy
    implements ByteChannel,
    Adaptable {
        private final ByteChannel delegate;
        private final CancelSupport cancelHelper;

        public ByteChannelProxy(ByteChannel _delegate, CancelSupport cs) {
            assert (_delegate != null);
            this.delegate = _delegate;
            this.cancelHelper = cs;
        }

        @Override
        public int write(ByteBuffer buffer) throws IOException, CancelledException {
            return this.delegate.write(buffer);
        }

        @Override
        public <T> T getAdapter(Class<T> adapterClass) {
            if (CancelSupport.class == adapterClass) {
                return adapterClass.cast(this.cancelHelper);
            }
            return Adaptable.Factory.getAdapter(this.delegate, adapterClass, null);
        }
    }
}

