/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.tmatesoft.hg.core.HgDate;
import org.tmatesoft.hg.core.HgFileRevision;
import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.internal.PhasesHelper;
import org.tmatesoft.hg.repo.HgChangelog;
import org.tmatesoft.hg.repo.HgInternals;
import org.tmatesoft.hg.repo.HgInvalidStateException;
import org.tmatesoft.hg.repo.HgParentChildMap;
import org.tmatesoft.hg.repo.HgPhase;
import org.tmatesoft.hg.repo.HgRepository;
import org.tmatesoft.hg.repo.HgRuntimeException;
import org.tmatesoft.hg.repo.HgStatusCollector;
import org.tmatesoft.hg.util.CancelledException;
import org.tmatesoft.hg.util.Path;

public class HgChangeset
implements Cloneable {
    private HgChangelog.RawChangeset changeset;
    private int revNumber;
    private Nodeid nodeid;
    private final ShareDataStruct shared;
    private List<HgFileRevision> modifiedFiles;
    private List<HgFileRevision> addedFiles;
    private List<Path> deletedFiles;
    private byte[] parent1;
    private byte[] parent2;

    HgChangeset(HgStatusCollector statusCollector, Path.Source pathFactory) {
        this.shared = new ShareDataStruct(statusCollector, pathFactory);
    }

    void init(int localRevNumber, Nodeid nid, HgChangelog.RawChangeset rawChangeset) {
        this.revNumber = localRevNumber;
        this.nodeid = nid;
        this.changeset = rawChangeset.clone();
        this.addedFiles = null;
        this.modifiedFiles = null;
        this.deletedFiles = null;
        this.parent2 = null;
        this.parent1 = null;
    }

    void setParentHelper(HgParentChildMap<HgChangelog> pw) {
        if (pw != null && pw.getRepo() != this.shared.statusHelper.getRepo()) {
            throw new IllegalArgumentException();
        }
        this.shared.parentHelper = pw;
    }

    public int getRevisionIndex() {
        return this.revNumber;
    }

    public Nodeid getNodeid() {
        return this.nodeid;
    }

    public String getUser() {
        return this.changeset.user();
    }

    public String getComment() {
        return this.changeset.comment();
    }

    public String getBranch() {
        return this.changeset.branch();
    }

    public HgDate getDate() {
        return new HgDate(this.changeset.date().getTime(), this.changeset.timezone());
    }

    public Nodeid getManifestRevision() {
        return this.changeset.manifest();
    }

    public List<Path> getAffectedFiles() {
        ArrayList<Path> rv = new ArrayList<Path>(this.changeset.files().size());
        for (String name : this.changeset.files()) {
            rv.add(this.shared.pathHelper.path(name));
        }
        return rv;
    }

    public List<HgFileRevision> getModifiedFiles() throws HgRuntimeException {
        if (this.modifiedFiles == null) {
            this.initFileChanges();
        }
        return this.modifiedFiles;
    }

    public List<HgFileRevision> getAddedFiles() throws HgRuntimeException {
        if (this.addedFiles == null) {
            this.initFileChanges();
        }
        return this.addedFiles;
    }

    public List<Path> getRemovedFiles() throws HgRuntimeException {
        if (this.deletedFiles == null) {
            this.initFileChanges();
        }
        return this.deletedFiles;
    }

    public boolean isMerge() throws HgRuntimeException {
        return !this.getFirstParentRevision().isNull() && !this.getSecondParentRevision().isNull();
    }

    public Nodeid getFirstParentRevision() throws HgRuntimeException {
        if (this.shared.parentHelper != null) {
            return this.shared.parentHelper.safeFirstParent(this.nodeid);
        }
        if (this.parent1 == null) {
            this.parent1 = new byte[20];
            this.parent2 = new byte[20];
            this.getRepo().getChangelog().parents(this.revNumber, new int[2], this.parent1, this.parent2);
        }
        return Nodeid.fromBinary(this.parent1, 0);
    }

    public Nodeid getSecondParentRevision() throws HgRuntimeException {
        if (this.shared.parentHelper != null) {
            return this.shared.parentHelper.safeSecondParent(this.nodeid);
        }
        if (this.parent2 == null) {
            this.parent1 = new byte[20];
            this.parent2 = new byte[20];
            this.getRepo().getChangelog().parents(this.revNumber, new int[2], this.parent1, this.parent2);
        }
        return Nodeid.fromBinary(this.parent2, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HgPhase getPhase() throws HgRuntimeException {
        if (this.shared.phaseHelper == null) {
            ShareDataStruct shareDataStruct = this.shared;
            synchronized (shareDataStruct) {
                if (this.shared.phaseHelper == null) {
                    this.shared.phaseHelper = new PhasesHelper(HgInternals.getImplementationRepo(this.getRepo()), this.shared.parentHelper);
                }
            }
        }
        return this.shared.phaseHelper.getPhase(this);
    }

    public HgChangeset clone() {
        try {
            HgChangeset copy = (HgChangeset)super.clone();
            return copy;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError(ex.toString());
        }
    }

    public String toString() {
        return String.format("HgChangeset(%d:%s)", this.revNumber, this.nodeid.shortNotation());
    }

    private HgRepository getRepo() {
        return this.shared.statusHelper.getRepo();
    }

    private void initFileChanges() throws HgRuntimeException {
        ArrayList<Path> deleted = new ArrayList<Path>();
        ArrayList<HgFileRevision> modified = new ArrayList<HgFileRevision>();
        ArrayList<HgFileRevision> added = new ArrayList<HgFileRevision>();
        HgStatusCollector.Record r = new HgStatusCollector.Record();
        try {
            this.shared.statusHelper.change(this.revNumber, r);
        }
        catch (CancelledException cancelledException) {
            throw new HgInvalidStateException("Internal error");
        }
        HgRepository repo = this.getRepo();
        for (Path s : r.getModified()) {
            Nodeid nid = r.nodeidAfterChange(s);
            if (nid == null) {
                throw new HgInvalidStateException(String.format("For the file %s recorded as modified in changeset %d couldn't find revision after change", s, this.revNumber));
            }
            modified.add(new HgFileRevision(repo, nid, null, s, null));
        }
        Map<Path, Path> copied = r.getCopied();
        for (Path s : r.getAdded()) {
            Nodeid nid = r.nodeidAfterChange(s);
            if (nid == null) {
                throw new HgInvalidStateException(String.format("For the file %s recorded as added in changeset %d couldn't find revision after change", s, this.revNumber));
            }
            added.add(new HgFileRevision(repo, nid, null, s, copied.get(s)));
        }
        for (Path s : r.getRemoved()) {
            deleted.add(s);
        }
        modified.trimToSize();
        added.trimToSize();
        deleted.trimToSize();
        this.modifiedFiles = Collections.unmodifiableList(modified);
        this.addedFiles = Collections.unmodifiableList(added);
        this.deletedFiles = Collections.unmodifiableList(deleted);
    }

    class ShareDataStruct {
        public final HgStatusCollector statusHelper;
        public final Path.Source pathHelper;
        public HgParentChildMap<HgChangelog> parentHelper;
        public PhasesHelper phaseHelper;

        ShareDataStruct(HgStatusCollector statusCollector, Path.Source pathFactory) {
            this.statusHelper = statusCollector;
            this.pathHelper = pathFactory;
        }
    }
}

