/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.core;

import java.util.ArrayDeque;
import org.tmatesoft.hg.core.HgException;
import org.tmatesoft.hg.core.HgFileRevision;
import org.tmatesoft.hg.core.HgLibraryFailureException;
import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.internal.ManifestRevision;
import org.tmatesoft.hg.repo.HgDataFile;
import org.tmatesoft.hg.repo.HgInvalidStateException;
import org.tmatesoft.hg.repo.HgManifest;
import org.tmatesoft.hg.repo.HgRepository;
import org.tmatesoft.hg.repo.HgRuntimeException;
import org.tmatesoft.hg.util.Outcome;
import org.tmatesoft.hg.util.Pair;
import org.tmatesoft.hg.util.Path;

public final class HgChangesetFileSneaker {
    private final HgRepository repo;
    private boolean followRenames;
    private Nodeid cset;
    private ManifestRevision cachedManifest;
    private HgFileRevision fileRevision;
    private boolean renamed;
    private Outcome checkResult;

    public HgChangesetFileSneaker(HgRepository hgRepo) {
        this.repo = hgRepo;
    }

    public HgChangesetFileSneaker changeset(Nodeid nid) {
        if (nid == null || nid.isNull()) {
            throw new IllegalArgumentException();
        }
        this.cset = nid;
        this.cachedManifest = null;
        this.fileRevision = null;
        return this;
    }

    public HgChangesetFileSneaker followRenames(boolean follow) {
        this.followRenames = follow;
        this.fileRevision = null;
        return this;
    }

    public boolean checkExists(Path file) throws HgException {
        this.check(file);
        if (!this.checkResult.isOk() && this.checkResult.getException() instanceof HgRuntimeException) {
            throw new HgLibraryFailureException((HgRuntimeException)this.checkResult.getException());
        }
        return this.checkResult.isOk() && this.exists();
    }

    public Outcome check(Path file) {
        Nodeid toExtract;
        HgDataFile dataFile;
        block12: {
            this.fileRevision = null;
            this.checkResult = null;
            this.renamed = false;
            if (this.cset == null || file == null || file.isDirectory()) {
                throw new IllegalArgumentException();
            }
            dataFile = this.repo.getFileNode(file);
            if (!dataFile.exists()) {
                this.checkResult = new Outcome(Outcome.Kind.Success, String.format("File named %s is not known in the repository", file));
                return this.checkResult;
            }
            toExtract = null;
            String phaseMsg = "Extract manifest revision failed";
            try {
                int ccFileRevIndex;
                int csetFileEnds;
                if (this.cachedManifest == null) {
                    int csetRev = this.repo.getChangelog().getRevisionIndex(this.cset);
                    this.cachedManifest = new ManifestRevision(null, null);
                    this.repo.getManifest().walk(csetRev, csetRev, this.cachedManifest);
                }
                toExtract = this.cachedManifest.nodeid(file);
                phaseMsg = "Follow copy/rename failed";
                if (toExtract != null || !this.followRenames) break block12;
                int csetIndex = this.repo.getChangelog().getRevisionIndex(this.cset);
                if (csetIndex > (csetFileEnds = dataFile.getChangesetRevisionIndex(ccFileRevIndex = dataFile.getLastRevision()))) {
                    return new Outcome(Outcome.Kind.Success, String.format("%s: last known changeset for the file %s is %d. Follow renames is possible towards older changesets only", phaseMsg, file, csetFileEnds));
                }
                ArrayDeque<Pair<HgDataFile, Integer>> traceback = new ArrayDeque<Pair<HgDataFile, Integer>>();
                do {
                    int ccCsetIndex;
                    if ((ccCsetIndex = dataFile.getChangesetRevisionIndex(ccFileRevIndex)) <= csetIndex) {
                        toExtract = dataFile.getRevision(ccFileRevIndex);
                        this.renamed = true;
                        break;
                    }
                    if (!dataFile.isCopy(ccFileRevIndex)) {
                        while (ccFileRevIndex == 0 && !traceback.isEmpty()) {
                            Pair lastTurnPoint = (Pair)traceback.pop();
                            dataFile = (HgDataFile)lastTurnPoint.first();
                            ccFileRevIndex = (Integer)lastTurnPoint.second();
                        }
                        --ccFileRevIndex;
                        continue;
                    }
                    if (ccFileRevIndex > 0) {
                        traceback.push(new Pair<HgDataFile, Integer>(dataFile, ccFileRevIndex));
                    }
                    HgFileRevision origin = dataFile.getCopySource(ccFileRevIndex);
                    dataFile = this.repo.getFileNode(origin.getPath());
                    ccFileRevIndex = dataFile.getRevisionIndex(origin.getRevision());
                } while (ccFileRevIndex >= 0);
            }
            catch (HgRuntimeException ex) {
                this.checkResult = new Outcome(Outcome.Kind.Failure, phaseMsg, ex);
                return this.checkResult;
            }
        }
        if (toExtract != null) {
            HgManifest.Flags extractRevFlags = this.cachedManifest.flags(dataFile.getPath());
            this.fileRevision = new HgFileRevision(this.repo, toExtract, extractRevFlags, dataFile.getPath());
            this.checkResult = new Outcome(Outcome.Kind.Success, String.format("File %s, revision %s found at changeset %s", dataFile.getPath(), toExtract.shortNotation(), this.cset.shortNotation()));
            return this.checkResult;
        }
        this.checkResult = new Outcome(Outcome.Kind.Success, String.format("File %s nor its origins were known at revision %s", file, this.cset.shortNotation()));
        return this.checkResult;
    }

    public Outcome getCheckResult() {
        this.assertCheckRan();
        return this.checkResult;
    }

    public boolean exists() {
        this.assertCheckRan();
        return this.fileRevision != null;
    }

    public boolean hasAnotherName() {
        this.assertCheckRan();
        return this.renamed;
    }

    public HgFileRevision getFileRevision() {
        this.assertCheckRan();
        return this.fileRevision;
    }

    public Path filename() {
        this.assertCheckRan();
        return this.fileRevision.getPath();
    }

    public Nodeid revision() {
        this.assertCheckRan();
        return this.fileRevision.getRevision();
    }

    private void assertCheckRan() {
        if (this.checkResult == null) {
            throw new HgInvalidStateException("Shall invoke #check(Path) first");
        }
    }
}

