/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.core;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.channels.FileChannel;
import org.tmatesoft.hg.core.HgAbstractCommand;
import org.tmatesoft.hg.core.HgBadArgumentException;
import org.tmatesoft.hg.core.HgException;
import org.tmatesoft.hg.core.HgIOException;
import org.tmatesoft.hg.core.HgLibraryFailureException;
import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.internal.CsetParamKeeper;
import org.tmatesoft.hg.internal.DirstateBuilder;
import org.tmatesoft.hg.internal.EncodingHelper;
import org.tmatesoft.hg.internal.Internals;
import org.tmatesoft.hg.internal.WorkingDirFileWriter;
import org.tmatesoft.hg.repo.HgDataFile;
import org.tmatesoft.hg.repo.HgDirstate;
import org.tmatesoft.hg.repo.HgInternals;
import org.tmatesoft.hg.repo.HgManifest;
import org.tmatesoft.hg.repo.HgRepository;
import org.tmatesoft.hg.repo.HgRepositoryFiles;
import org.tmatesoft.hg.repo.HgRuntimeException;
import org.tmatesoft.hg.util.CancelSupport;
import org.tmatesoft.hg.util.CancelledException;
import org.tmatesoft.hg.util.Path;
import org.tmatesoft.hg.util.ProgressSupport;

public class HgCheckoutCommand
extends HgAbstractCommand<HgCheckoutCommand> {
    private final HgRepository repo;
    private final CsetParamKeeper revisionToCheckout;
    private boolean cleanCheckout;

    public HgCheckoutCommand(HgRepository hgRepo) {
        this.repo = hgRepo;
        this.revisionToCheckout = new CsetParamKeeper(this.repo);
    }

    public HgCheckoutCommand clean(boolean clean) {
        this.cleanCheckout = clean;
        return this;
    }

    public HgCheckoutCommand changeset(Nodeid nodeid) throws HgBadArgumentException {
        this.revisionToCheckout.set(nodeid);
        return this;
    }

    public HgCheckoutCommand changeset(int changesetIndex) throws HgBadArgumentException {
        this.revisionToCheckout.set(changesetIndex);
        return this;
    }

    public void execute() throws HgException, CancelledException {
        try {
            ProgressSupport progress = this.getProgressSupport(null);
            CancelSupport cancellation = this.getCancelSupport(null, true);
            cancellation.checkCancelled();
            progress.start(6);
            Internals internalRepo = Internals.getInstance(this.repo);
            if (!this.cleanCheckout) {
                throw new HgBadArgumentException("Sorry, only clean checkout is supported now, use #clean(true)", null);
            }
            HgDirstate dirstate = new HgInternals(this.repo).getDirstate();
            dirstate.walk(new HgDirstate.Inspector(){

                @Override
                public boolean next(HgDirstate.EntryKind kind, HgDirstate.Record entry) {
                    File f = new File(HgCheckoutCommand.this.repo.getWorkingDir(), entry.name().toString());
                    if (f.exists()) {
                        f.delete();
                    }
                    return true;
                }
            });
            progress.worked(1);
            cancellation.checkCancelled();
            final DirstateBuilder dirstateBuilder = new DirstateBuilder(internalRepo);
            final CheckoutWorker worker = new CheckoutWorker(internalRepo);
            HgManifest.Inspector insp = new HgManifest.Inspector(){

                @Override
                public boolean next(Nodeid nid, Path fname, HgManifest.Flags flags) {
                    if (worker.next(nid, fname, flags)) {
                        int mtime = worker.getLastFileModificationTime();
                        int fmode = worker.getLastFileMode();
                        dirstateBuilder.recordNormal(fname, fmode, mtime, worker.getLastFileSize());
                        return true;
                    }
                    return false;
                }

                @Override
                public boolean end(int manifestRevision) {
                    return false;
                }

                @Override
                public boolean begin(int mainfestRevision, Nodeid nid, int changelogRevision) {
                    return true;
                }
            };
            int coRevision = this.revisionToCheckout.get(-3);
            dirstateBuilder.parents(this.repo.getChangelog().getRevision(coRevision), null);
            this.repo.getManifest().walk(coRevision, coRevision, insp);
            worker.checkFailed();
            progress.worked(3);
            cancellation.checkCancelled();
            File dirstateFile = internalRepo.getRepositoryFile(HgRepositoryFiles.Dirstate);
            try {
                FileChannel dirstateFileChannel = new FileOutputStream(dirstateFile).getChannel();
                dirstateBuilder.serialize(dirstateFileChannel);
                dirstateFileChannel.close();
            }
            catch (IOException ex) {
                throw new HgIOException("Can't write down new directory state", ex, dirstateFile);
            }
            progress.worked(1);
            cancellation.checkCancelled();
            String branchName = this.repo.getChangelog().range(coRevision, coRevision).get(0).branch();
            assert (branchName != null);
            File branchFile = internalRepo.getRepositoryFile(HgRepositoryFiles.Branch);
            if ("default".equals(branchName)) {
                if (branchFile.isFile()) {
                    branchFile.delete();
                }
            } else {
                try {
                    OutputStreamWriter ow = new OutputStreamWriter((OutputStream)new FileOutputStream(branchFile), EncodingHelper.getUTF8());
                    ow.write(branchName);
                    ow.close();
                }
                catch (IOException ex) {
                    throw new HgIOException("Can't write down branch information", ex, branchFile);
                }
            }
            progress.worked(1);
            progress.done();
        }
        catch (HgRuntimeException ex) {
            throw new HgLibraryFailureException(ex);
        }
    }

    static class CheckoutWorker {
        private final Internals hgRepo;
        private HgException failure;
        private int lastWrittenFileSize;
        private int lastFileMode;
        private int lastFileModificationTime;

        CheckoutWorker(Internals implRepo) {
            this.hgRepo = implRepo;
        }

        public boolean next(Nodeid nid, Path fname, HgManifest.Flags flags) {
            WorkingDirFileWriter workingDirWriter = null;
            try {
                HgDataFile df = this.hgRepo.getRepo().getFileNode(fname);
                int fileRevIndex = df.getRevisionIndex(nid);
                workingDirWriter = new WorkingDirFileWriter(this.hgRepo);
                workingDirWriter.processFile(df, fileRevIndex, flags);
                this.lastWrittenFileSize = workingDirWriter.bytesWritten();
                this.lastFileMode = workingDirWriter.fmode();
                this.lastFileModificationTime = workingDirWriter.mtime();
                return true;
            }
            catch (IOException ex) {
                this.failure = new HgIOException("Failed to write down file revision", ex, workingDirWriter.getDestinationFile());
            }
            catch (HgRuntimeException ex) {
                this.failure = new HgLibraryFailureException(ex);
            }
            return false;
        }

        public int getLastFileMode() {
            return this.lastFileMode;
        }

        public int getLastFileModificationTime() {
            return this.lastFileModificationTime;
        }

        public int getLastFileSize() {
            return this.lastWrittenFileSize;
        }

        public void checkFailed() throws HgException {
            if (this.failure != null) {
                throw this.failure;
            }
        }
    }
}

