/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.core;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.TreeMap;
import org.tmatesoft.hg.core.HgAbstractCommand;
import org.tmatesoft.hg.core.HgBadArgumentException;
import org.tmatesoft.hg.core.HgException;
import org.tmatesoft.hg.core.HgIOException;
import org.tmatesoft.hg.core.HgLibraryFailureException;
import org.tmatesoft.hg.core.HgRepositoryNotFoundException;
import org.tmatesoft.hg.core.HgRevisionIntegrityException;
import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.core.SessionContext;
import org.tmatesoft.hg.internal.ByteArrayDataAccess;
import org.tmatesoft.hg.internal.DataAccess;
import org.tmatesoft.hg.internal.DataSerializer;
import org.tmatesoft.hg.internal.DigestHelper;
import org.tmatesoft.hg.internal.FNCacheFile;
import org.tmatesoft.hg.internal.Internals;
import org.tmatesoft.hg.internal.Lifecycle;
import org.tmatesoft.hg.internal.Patch;
import org.tmatesoft.hg.internal.RepoInitializer;
import org.tmatesoft.hg.internal.RevlogCompressor;
import org.tmatesoft.hg.internal.RevlogStreamWriter;
import org.tmatesoft.hg.internal.Transaction;
import org.tmatesoft.hg.repo.HgBundle;
import org.tmatesoft.hg.repo.HgInternals;
import org.tmatesoft.hg.repo.HgInvalidControlFileException;
import org.tmatesoft.hg.repo.HgInvalidStateException;
import org.tmatesoft.hg.repo.HgLookup;
import org.tmatesoft.hg.repo.HgRemoteRepository;
import org.tmatesoft.hg.repo.HgRepository;
import org.tmatesoft.hg.repo.HgRuntimeException;
import org.tmatesoft.hg.util.CancelSupport;
import org.tmatesoft.hg.util.CancelledException;
import org.tmatesoft.hg.util.Path;
import org.tmatesoft.hg.util.PathRewrite;
import org.tmatesoft.hg.util.ProgressSupport;

public class HgCloneCommand
extends HgAbstractCommand<HgCloneCommand> {
    private File destination;
    private HgRemoteRepository srcRepo;

    public HgCloneCommand destination(File folder) {
        this.destination = folder;
        return this;
    }

    public HgCloneCommand source(HgRemoteRepository hgRemote) {
        this.srcRepo = hgRemote;
        return this;
    }

    public HgRepository execute() throws HgException, CancelledException {
        if (this.destination == null) {
            throw new IllegalArgumentException("Destination not set", null);
        }
        if (this.srcRepo == null || this.srcRepo.isInvalid()) {
            throw new HgBadArgumentException("Bad source repository", null);
        }
        if (this.destination.exists()) {
            if (!this.destination.isDirectory()) {
                throw new HgBadArgumentException(String.format("%s is not a directory", this.destination), null);
            }
            if (this.destination.list().length > 0) {
                throw new HgBadArgumentException(String.format("%s shall be empty", this.destination), null);
            }
        } else {
            this.destination.mkdirs();
        }
        ProgressSupport progress = this.getProgressSupport(null);
        CancelSupport cancel = this.getCancelSupport(null, true);
        cancel.checkCancelled();
        try {
            HgBundle completeChanges = this.srcRepo.getChanges(Collections.singletonList(Nodeid.NULL));
            cancel.checkCancelled();
            WriteDownMate mate = new WriteDownMate(this.srcRepo.getSessionContext(), this.destination, progress, cancel);
            try {
                mate.initEmptyRepository();
                completeChanges.inspectAll(mate);
                mate.checkFailure();
                mate.complete();
            }
            finally {
                completeChanges.unlink();
                progress.done();
            }
        }
        catch (HgRuntimeException ex) {
            throw new HgLibraryFailureException(ex);
        }
        return new HgLookup().detect(this.destination);
    }

    private static class WriteDownMate
    implements HgBundle.Inspector,
    Lifecycle {
        private final File hgDir;
        private final PathRewrite storagePathHelper;
        private final ProgressSupport progressSupport;
        private final CancelSupport cancelSupport;
        private final SessionContext ctx;
        private final Path.Source pathFactory;
        private FileOutputStream indexFile;
        private File currentFile;
        private String filename;
        private final TreeMap<Nodeid, Integer> changelogIndexes = new TreeMap();
        private boolean collectChangelogIndexes = false;
        private DataAccess prevRevContent;
        private final DigestHelper dh = new DigestHelper();
        private final ArrayList<Nodeid> revisionSequence = new ArrayList();
        private FNCacheFile fncacheFile;
        private RepoInitializer repoInit;
        private Lifecycle.Callback lifecycleCallback;
        private CancelledException cancelException;
        private RevlogStreamWriter.HeaderWriter revlogHeader = new RevlogStreamWriter.HeaderWriter(true);
        private RevlogCompressor revlogDataZip;

        public WriteDownMate(SessionContext sessionCtx, File destDir, ProgressSupport progress, CancelSupport cancel) {
            this.ctx = sessionCtx;
            this.hgDir = new File(destDir, ".hg");
            this.repoInit = new RepoInitializer();
            this.repoInit.setRequires(0x40000007);
            this.storagePathHelper = this.repoInit.buildDataFilesHelper(sessionCtx);
            this.progressSupport = progress;
            this.cancelSupport = cancel;
            this.revlogDataZip = new RevlogCompressor(sessionCtx);
            this.pathFactory = this.ctx.getPathFactory();
        }

        public void initEmptyRepository() throws HgIOException, HgRepositoryNotFoundException {
            this.repoInit.initEmptyRepository(this.hgDir);
            assert ((this.repoInit.getRequires() & 2) != 0);
            this.fncacheFile = new FNCacheFile(Internals.getInstance(new HgLookup(this.ctx).detect(this.hgDir)));
        }

        public void complete() throws HgIOException {
            this.fncacheFile.write(new Transaction.NoRollback());
        }

        @Override
        public void changelogStart() throws HgInvalidControlFileException {
            try {
                this.revlogHeader.offset(0L).baseRevision(-1);
                this.revisionSequence.clear();
                this.filename = "store/00changelog.i";
                this.currentFile = new File(this.hgDir, "store/00changelog.i");
                this.indexFile = new FileOutputStream(this.currentFile);
                this.collectChangelogIndexes = true;
            }
            catch (IOException ex) {
                throw new HgInvalidControlFileException("Failed to write changelog", ex, new File(this.hgDir, this.filename));
            }
            this.stopIfCancelled();
        }

        @Override
        public void changelogEnd() throws HgInvalidControlFileException {
            try {
                this.clearPreviousContent();
                this.collectChangelogIndexes = false;
                this.closeIndexFile();
            }
            catch (IOException ex) {
                throw new HgInvalidControlFileException("Failed to write changelog", ex, new File(this.hgDir, this.filename));
            }
            this.progressSupport.worked(1);
            this.stopIfCancelled();
        }

        @Override
        public void manifestStart() throws HgInvalidControlFileException {
            try {
                this.revlogHeader.offset(0L).baseRevision(-1);
                this.revisionSequence.clear();
                this.filename = "store/00manifest.i";
                this.currentFile = new File(this.hgDir, "store/00manifest.i");
                this.indexFile = new FileOutputStream(this.currentFile);
            }
            catch (IOException ex) {
                throw new HgInvalidControlFileException("Failed to write manifest", ex, new File(this.hgDir, this.filename));
            }
            this.stopIfCancelled();
        }

        @Override
        public void manifestEnd() throws HgInvalidControlFileException {
            try {
                this.clearPreviousContent();
                this.closeIndexFile();
            }
            catch (IOException ex) {
                throw new HgInvalidControlFileException("Failed to write manifest", ex, new File(this.hgDir, this.filename));
            }
            this.progressSupport.worked(1);
            this.stopIfCancelled();
        }

        @Override
        public void fileStart(String name) throws HgInvalidControlFileException {
            try {
                this.revlogHeader.offset(0L).baseRevision(-1);
                this.revisionSequence.clear();
                this.filename = this.storagePathHelper.rewrite(name).toString();
                File file = new File(this.hgDir, this.filename);
                file.getParentFile().mkdirs();
                this.currentFile = file;
                this.indexFile = new FileOutputStream(this.currentFile);
            }
            catch (IOException ex) {
                String m = String.format("Failed to write file %s", this.filename);
                throw new HgInvalidControlFileException(m, ex, new File(this.filename));
            }
            this.stopIfCancelled();
        }

        @Override
        public void fileEnd(String name) throws HgInvalidControlFileException {
            try {
                this.fncacheFile.addIndex(this.pathFactory.path(name));
                this.clearPreviousContent();
                this.closeIndexFile();
            }
            catch (IOException ex) {
                String m = String.format("Failed to write file %s", this.filename);
                throw new HgInvalidControlFileException(m, ex, new File(this.filename));
            }
            this.progressSupport.worked(1);
            this.stopIfCancelled();
        }

        private void clearPreviousContent() {
            if (this.prevRevContent != null) {
                this.prevRevContent.done();
                this.prevRevContent = null;
            }
        }

        private void closeIndexFile() throws IOException {
            this.indexFile.close();
            this.indexFile = null;
            this.filename = null;
            this.currentFile = null;
        }

        private int knownRevision(Nodeid p) throws HgInvalidControlFileException {
            if (p.isNull()) {
                return -1;
            }
            int i = this.revisionSequence.size() - 1;
            while (i >= 0) {
                if (this.revisionSequence.get(i).equals(p)) {
                    return i;
                }
                --i;
            }
            String m = String.format("Can't find index of %s for file %s", p.shortNotation(), this.filename);
            throw new HgInvalidControlFileException(m, null, new File(this.hgDir, this.filename)).setRevision(p);
        }

        @Override
        public boolean element(HgBundle.GroupElement ge) throws HgRuntimeException {
            try {
                assert (this.indexFile != null);
                boolean writeComplete = false;
                Nodeid deltaBase = ge.patchBase();
                if (deltaBase.isNull()) {
                    this.prevRevContent = new DataAccess();
                    writeComplete = true;
                } else {
                    Nodeid prevRevision;
                    Nodeid nodeid = prevRevision = this.revisionSequence.size() > 0 ? this.revisionSequence.get(this.revisionSequence.size() - 1) : Nodeid.NULL;
                    if (!prevRevision.equals(deltaBase)) {
                        String m = String.format("Revision %s import failed: delta base %s is not the last node we've handled (and know content for) %s", ge.node(), deltaBase, prevRevision);
                        throw new HgInvalidStateException(m);
                    }
                }
                Patch patch = HgInternals.patchFromData(ge);
                byte[] content = patch.apply(this.prevRevContent, -1);
                Nodeid p1 = ge.firstParent();
                Nodeid p2 = ge.secondParent();
                byte[] calculated = this.dh.sha1(p1, p2, content).asBinary();
                Nodeid node = ge.node();
                if (!node.equalsTo(calculated)) {
                    String m = String.format("Checksum failed: expected %s, calculated %s. File %s", node, calculated, this.filename);
                    throw new HgRevisionIntegrityException(m, null, new File(this.hgDir, this.filename));
                }
                this.revlogHeader.nodeid(node);
                if (this.collectChangelogIndexes) {
                    this.changelogIndexes.put(node, this.revisionSequence.size());
                    this.revlogHeader.linkRevision(this.revisionSequence.size());
                } else {
                    Integer csRev = this.changelogIndexes.get(ge.cset());
                    if (csRev == null) {
                        throw new HgInvalidStateException(String.format("Changelog doesn't contain revision %s of %s", ge.cset().shortNotation(), this.filename));
                    }
                    this.revlogHeader.linkRevision(csRev);
                }
                this.revlogHeader.parents(this.knownRevision(p1), this.knownRevision(p2));
                int patchSerializedLength = patch.serializedLength();
                boolean bl = writeComplete = writeComplete || RevlogStreamWriter.preferCompleteOverPatch(patchSerializedLength, content.length);
                if (writeComplete) {
                    this.revlogHeader.baseRevision(this.revisionSequence.size());
                }
                assert (this.revlogHeader.baseRevision() >= 0);
                DataSerializer.DataSource dataSource = writeComplete ? new DataSerializer.ByteArrayDataSource(content) : new Patch.PatchDataSource(patch);
                this.revlogDataZip.reset(dataSource);
                boolean useUncompressedData = RevlogStreamWriter.preferCompressedOverComplete(this.revlogDataZip.getCompressedLength(), dataSource.serializeLength());
                int compressedLen = useUncompressedData ? dataSource.serializeLength() + 1 : this.revlogDataZip.getCompressedLength();
                this.revlogHeader.length(content.length, compressedLen);
                DataSerializer sds = new DataSerializer(){

                    @Override
                    public void write(byte[] data, int offset, int length) throws HgIOException {
                        try {
                            WriteDownMate.this.indexFile.write(data, offset, length);
                        }
                        catch (IOException ex) {
                            throw new HgIOException("Write failure", ex, WriteDownMate.this.currentFile);
                        }
                    }
                };
                this.revlogHeader.serialize(sds);
                if (useUncompressedData) {
                    sds.writeByte(117);
                    dataSource.serialize(sds);
                } else {
                    int actualCompressedLenWritten = this.revlogDataZip.writeCompressedData(sds);
                    if (actualCompressedLenWritten != compressedLen) {
                        throw new HgInvalidStateException(String.format("Expected %d bytes of compressed data, but actually wrote %d in %s", compressedLen, actualCompressedLenWritten, this.filename));
                    }
                }
                sds.done();
                this.revisionSequence.add(node);
                this.prevRevContent.done();
                this.prevRevContent = new ByteArrayDataAccess(content);
            }
            catch (HgIOException ex) {
                String m = String.format("Failed to write revision %s of file %s", ge.node().shortNotation(), this.filename);
                throw new HgInvalidControlFileException(m, ex, this.currentFile);
            }
            catch (IOException ex) {
                String m = String.format("Failed to write revision %s of file %s", ge.node().shortNotation(), this.filename);
                throw new HgInvalidControlFileException(m, ex, this.currentFile);
            }
            return this.cancelException == null;
        }

        @Override
        public void start(int count, Lifecycle.Callback callback, Object token) {
            this.progressSupport.start(count);
            this.lifecycleCallback = callback;
        }

        @Override
        public void finish(Object token) {
            this.progressSupport.done();
            this.lifecycleCallback = null;
        }

        public void checkFailure() throws CancelledException {
            if (this.cancelException != null) {
                throw this.cancelException;
            }
        }

        private void stopIfCancelled() {
            try {
                this.cancelSupport.checkCancelled();
                return;
            }
            catch (CancelledException ex) {
                this.cancelException = ex;
                this.lifecycleCallback.stop();
                return;
            }
        }
    }
}

